/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.setting;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.RangedWrapper;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.response.ResponseChat;
import com.github.tartaricacid.touhoulittlemaid.ai.service.Service;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.apache.commons.lang3.StringUtils;

public class PapiReplacer {
    static String replace(String input, EntityMaid maid, String language) {
        class_1937 level = maid.field_6002;
        return input.replace("${game_time}", PapiReplacer.getTime(level)).replace("${weather}", PapiReplacer.getWeather(level)).replace("${dimension}", PapiReplacer.getDimension(level)).replace("${mainhand_item}", PapiReplacer.getSlotItemName(class_1304.field_6173, maid)).replace("${offhand_item}", PapiReplacer.getSlotItemName(class_1304.field_6171, maid)).replace("${inventory_items}", PapiReplacer.getInventoryItems(maid)).replace("${output_json_format}", PapiReplacer.getOutputJsonFormat()).replace("${chat_language}", language).replace("${tts_language}", PapiReplacer.ttsLanguage(maid.getAiChatManager().getTtsLanguage())).replace("${healthy}", PapiReplacer.getHealthyInfo(maid)).replace("${owner_healthy}", PapiReplacer.getOwnerHealthyInfo(maid)).replace("${armor_items}", PapiReplacer.getArmorItems(maid)).replace("${effects}", PapiReplacer.getEffects(maid)).replace("${biome}", PapiReplacer.getBiome(maid)).replace("${owner_name}", PapiReplacer.getOwnerName(maid)).replace("${custom_setting}", maid.getAiChatManager().getCustomSetting());
    }

    private static String ttsLanguage(String languageTag) {
        String[] parts = ((String)languageTag).split("_");
        if (parts.length == 2) {
            languageTag = parts[0] + "-" + parts[1].toUpperCase(Locale.ENGLISH);
        }
        Locale locale = Locale.forLanguageTag((String)languageTag);
        return locale.getDisplayLanguage() + " (" + locale.getDisplayCountry() + ")";
    }

    private static String getBiome(EntityMaid maid) {
        class_1959 biome = (class_1959)maid.field_6002.method_23753(maid.method_24515()).comp_349();
        class_2960 key = maid.field_6002.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        return key == null ? "\u672a\u77e5 Biome" : key.toString();
    }

    private static String getEffects(EntityMaid maid) {
        ArrayList names = new ArrayList();
        maid.method_6026().forEach(i -> names.add(i.toString()));
        if (names.isEmpty()) {
            return "\u65e0";
        }
        return StringUtils.join(names, (String)", ");
    }

    private static String getArmorItems(EntityMaid maid) {
        ArrayList names = new ArrayList();
        maid.method_5661().forEach(stack -> {
            if (!stack.method_7960()) {
                String itemName = stack.method_7954().getString();
                int count = stack.method_7947();
                names.add(String.format("%sx%s", itemName, count));
            }
        });
        if (names.isEmpty()) {
            return "\u7a7a\u7684";
        }
        return StringUtils.join(names, (String)", ");
    }

    private static String getHealthyInfo(EntityMaid maid) {
        float maxHealth = maid.method_6063();
        float health = maid.method_6032();
        return String.format("%s (max %s)", Float.valueOf(health), Float.valueOf(maxHealth));
    }

    private static String getOwnerHealthyInfo(EntityMaid maid) {
        class_1309 owner = maid.method_35057();
        if (owner != null) {
            float maxHealth = owner.method_6063();
            float health = owner.method_6032();
            return String.format("%s (max %s)", Float.valueOf(health), Float.valueOf(maxHealth));
        }
        return "";
    }

    private static String getOwnerName(EntityMaid maid) {
        String ownerName = maid.getAiChatManager().getOwnerName();
        if (StringUtils.isBlank((CharSequence)ownerName)) {
            return "\u4e3b\u4eba";
        }
        return ownerName;
    }

    private static String getWeather(class_1937 level) {
        if (level.method_8546()) {
            return "\u96f7\u96e8\u5929";
        }
        if (level.method_8419()) {
            return "\u9634\u96e8\u5929";
        }
        return "\u6674\u5929";
    }

    private static String getTime(class_1937 level) {
        long time = level.method_8532();
        long hours = (time / 1000L + 6L) % 24L;
        long minutes = time % 1000L / 16L;
        return String.format("%02d:%02d", hours, minutes);
    }

    private static String getDimension(class_1937 level) {
        class_5321 dimension = level.method_27983();
        if (dimension == class_1937.field_25179) {
            return "\u4e3b\u4e16\u754c";
        }
        if (dimension == class_1937.field_25180) {
            return "\u4e0b\u754c";
        }
        if (dimension == class_1937.field_25181) {
            return "\u672b\u5730";
        }
        return dimension.method_29177().toString();
    }

    private static String getSlotItemName(class_1304 slot, EntityMaid maid) {
        class_1799 stack = maid.method_6118(slot);
        if (stack.method_7960()) {
            return "\u7a7a\u7684";
        }
        String itemName = stack.method_7954().getString();
        int count = stack.method_7947();
        return String.format("%sx%s", itemName, count);
    }

    private static String getInventoryItems(EntityMaid maid) {
        ArrayList<String> names = new ArrayList<String>();
        RangedWrapper backpack = maid.getAvailableBackpackInv();
        for (int i = 0; i < backpack.getSlots(); ++i) {
            class_1799 stack = backpack.getStackInSlot(i);
            if (stack.method_7960()) continue;
            String itemName = stack.method_7954().getString();
            int count = stack.method_7947();
            names.add(String.format("%sx%s", itemName, count));
        }
        if (names.isEmpty()) {
            return "\u7a7a\u7684";
        }
        return StringUtils.join(names, (String)", ");
    }

    private static String getOutputJsonFormat() {
        return Service.GSON.toJson((Object)new ResponseChat());
    }
}

