/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.HistoryChat;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.Site;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ConfigProxySelector;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.ChatClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.request.ChatCompletion;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.request.ResponseFormat;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.request.Role;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.player2.STTClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSFactory;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSRequest;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.util.CappedQueue;
import com.google.gson.Gson;
import java.net.http.HttpClient;
import java.time.Duration;
import org.jetbrains.annotations.Nullable;

public final class Service {
    public static final Gson GSON = new Gson();
    private static final HttpClient CHAT_HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).proxy(new ConfigProxySelector(AIConfig.CHAT_PROXY_ADDRESS)).build();
    private static final HttpClient TTS_HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).proxy(new ConfigProxySelector(AIConfig.TTS_PROXY_ADDRESS)).build();
    private static final HttpClient STT_HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).proxy(new ConfigProxySelector(AIConfig.STT_PROXY_ADDRESS)).build();

    public static ChatClient getChatClient(Site site) {
        String chatApiKey = site.getApiKey();
        String chatBaseUrl = site.getUrl();
        return ChatClient.create(CHAT_HTTP_CLIENT).apiKey(chatApiKey).baseUrl(chatBaseUrl);
    }

    @Nullable
    public static ChatCompletion getChatCompletion(MaidAIChatManager chatManager, String language) {
        return chatManager.getSetting().map(s -> {
            String setting = s.getSetting(chatManager.getMaid(), language);
            String model = chatManager.getChatModel();
            double chatTemperature = chatManager.getChatTemperature();
            CappedQueue<HistoryChat> history = chatManager.getHistory();
            ChatCompletion chatCompletion = ChatCompletion.create().model(model).temperature(chatTemperature).setResponseFormat(ResponseFormat.json()).systemChat(setting).assistantChat("{\"chat_text\":\"\u770b\u5230\u4f60\u771f\u5f00\u5fc3\uff01\u8981\u4e0d\u8981\u4e00\u8d77\u53bb\u6316\u77ff\uff1f\",\"tts_text\":\"\u770b\u5230\u4f60\u771f\u5f00\u5fc3\uff01\u8981\u4e0d\u8981\u4e00\u8d77\u53bb\u6316\u77ff\uff1f\"}");
            history.getDeque().descendingIterator().forEachRemaining(historyChat -> {
                Role role = historyChat.role();
                String message = historyChat.message();
                if (role.equals((Object)Role.USER)) {
                    chatCompletion.userChat(message);
                } else if (role.equals((Object)Role.ASSISTANT)) {
                    chatCompletion.assistantChat(message);
                }
            });
            chatCompletion.userChat(String.format("\u8bf7\u7528%s\u8bed\u8a00\u56de\u590d chat_text \u90e8\u5206\uff01\u5e76\u7528%s\u8bed\u8a00\u56de\u590d tts_text \u90e8\u5206\uff01", language, chatManager.getTtsLanguage()));
            return chatCompletion;
        }).orElse(null);
    }

    @Nullable
    public static TTSClient<?> getTtsClient(Site site) {
        return TTSFactory.getTtsClient(TTS_HTTP_CLIENT, site);
    }

    @Nullable
    public static TTSRequest getTtsRequest(Site site, String ttsText, String ttsLang, String model) {
        return TTSFactory.getTtsRequest(site, ttsText, ttsLang, model);
    }

    public static STTClient getSttClient(String url) {
        return STTClient.create(STT_HTTP_CLIENT).baseUrl(url);
    }
}

