/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatText;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.MaidChatBubbles;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1044;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

public class ChatBubbleRenderer {
    private static final class_4668.class_4685 NO_TRANSPARENCY = new class_4668.class_4685("no_transparency", RenderSystem::disableBlend, () -> {});
    private static final Function<class_2960, class_1921> CHAT_BUBBLE_RENDER = class_156.method_34866(ChatBubbleRenderer::chatBubbleRender);
    private static final List<Pair<Long, ChatText>> TMP_CHAT_BUBBLES = Lists.newArrayList();
    private static final String LEFT_ARROW = "left_arrow";
    private static final String MIDDLE_ARROW = "middle_arrow";
    private static final String RIGHT_ARROW = "right_arrow";

    public static void renderChatBubble(EntityMaidRenderer renderer, EntityMaid maid, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        Integer value;
        double distance = renderer.getDispatcher().method_23168((class_1297)maid);
        if (distance <= (double)((value = (Integer)renderer.getDispatcher().field_4692.method_42503().method_41753()) * value)) {
            ChatBubbleRenderer.getTmpChatBubbles(maid);
            class_327 font = renderer.method_3932();
            if (TMP_CHAT_BUBBLES.size() == 1) {
                Pair<Long, ChatText> chatBubble = TMP_CHAT_BUBBLES.get(0);
                ChatText chatText = (ChatText)chatBubble.getRight();
                RenderData data = new RenderData(renderer, maid, matrixStack, buffer, MIDDLE_ARROW);
                if (chatText.isText()) {
                    class_5250 parseText = ParseI18n.parse(chatText.getText());
                    int width = font.method_27525((class_5348)parseText);
                    ChatBubbleRenderer.renderChatBubbleBody(0, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, data, arg_0 -> ChatBubbleRenderer.lambda$renderChatBubble$1((class_2561)parseText, maid, width, packedLight, arg_0));
                }
                if (chatText.isIcon()) {
                    ChatBubbleRenderer.renderChatBubbleBody(0, -32 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data, d -> ChatBubbleRenderer.renderIcon(0, -32 + ChatBubbleRenderer.getRenderYOffset(maid), chatText.getIconPath(), d));
                }
                return;
            }
            if (TMP_CHAT_BUBBLES.size() == 2) {
                int startX;
                int startX2;
                int fullWidth;
                int width;
                Pair<Long, ChatText> chatBubble1 = TMP_CHAT_BUBBLES.get(0);
                Pair<Long, ChatText> chatBubble2 = TMP_CHAT_BUBBLES.get(1);
                ChatText chatText1 = (ChatText)chatBubble1.getRight();
                ChatText chatText2 = (ChatText)chatBubble2.getRight();
                RenderData data1 = new RenderData(renderer, maid, matrixStack, buffer, RIGHT_ARROW);
                RenderData data2 = new RenderData(renderer, maid, matrixStack, buffer, LEFT_ARROW);
                if (chatText1.isText()) {
                    class_5250 parseText1 = ParseI18n.parse(chatText1.getText());
                    width = font.method_27525((class_5348)parseText1);
                    fullWidth = (width / 20 + 2) * 20;
                    startX2 = -fullWidth / 2 - 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX2, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, data1, arg_0 -> ChatBubbleRenderer.lambda$renderChatBubble$3((class_2561)parseText1, startX2, maid, width, packedLight, arg_0));
                }
                if (chatText1.isIcon()) {
                    int fullWidth2 = 60;
                    startX = -fullWidth2 / 2 - 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data1, d -> ChatBubbleRenderer.renderIcon(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), chatText1.getIconPath(), d));
                }
                if (chatText2.isText()) {
                    class_5250 parseText2 = ParseI18n.parse(chatText2.getText());
                    width = font.method_27525((class_5348)parseText2);
                    fullWidth = (width / 20 + 2) * 20;
                    startX2 = fullWidth / 2 + 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX2, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, data2, arg_0 -> ChatBubbleRenderer.lambda$renderChatBubble$5((class_2561)parseText2, startX2, maid, width, packedLight, arg_0));
                }
                if (chatText2.isIcon()) {
                    int fullWidth3 = 60;
                    startX = fullWidth3 / 2 + 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data2, d -> ChatBubbleRenderer.renderIcon(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), chatText2.getIconPath(), d));
                }
                return;
            }
            if (TMP_CHAT_BUBBLES.size() == 3) {
                int startX;
                int startX3;
                int fullWidth;
                int width;
                Pair<Long, ChatText> chatBubble1 = TMP_CHAT_BUBBLES.get(0);
                Pair<Long, ChatText> chatBubble2 = TMP_CHAT_BUBBLES.get(1);
                Pair<Long, ChatText> chatBubble3 = TMP_CHAT_BUBBLES.get(2);
                ChatText chatText1 = (ChatText)chatBubble1.getRight();
                ChatText chatText2 = (ChatText)chatBubble2.getRight();
                ChatText chatText3 = (ChatText)chatBubble3.getRight();
                RenderData data1 = new RenderData(renderer, maid, matrixStack, buffer, RIGHT_ARROW);
                RenderData data2 = new RenderData(renderer, maid, matrixStack, buffer, LEFT_ARROW);
                RenderData data3 = new RenderData(renderer, maid, matrixStack, buffer, MIDDLE_ARROW);
                if (chatText1.isText()) {
                    class_5250 parseText1 = ParseI18n.parse(chatText1.getText());
                    width = font.method_27525((class_5348)parseText1);
                    fullWidth = (width / 20 + 2) * 20;
                    startX3 = -fullWidth / 2 - 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX3, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, data1, arg_0 -> ChatBubbleRenderer.lambda$renderChatBubble$7((class_2561)parseText1, startX3, maid, width, packedLight, arg_0));
                }
                if (chatText1.isIcon()) {
                    int fullWidth4 = 60;
                    startX = -fullWidth4 / 2 - 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data1, d -> ChatBubbleRenderer.renderIcon(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), chatText1.getIconPath(), d));
                }
                if (chatText2.isText()) {
                    class_5250 parseText2 = ParseI18n.parse(chatText2.getText());
                    width = font.method_27525((class_5348)parseText2);
                    fullWidth = (width / 20 + 2) * 20;
                    startX3 = fullWidth / 2 + 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX3, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, data2, arg_0 -> ChatBubbleRenderer.lambda$renderChatBubble$9((class_2561)parseText2, startX3, maid, width, packedLight, arg_0));
                }
                if (chatText2.isIcon()) {
                    int fullWidth5 = 60;
                    startX = fullWidth5 / 2 + 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data2, d -> ChatBubbleRenderer.renderIcon(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), chatText2.getIconPath(), d));
                }
                if (chatText3.isText()) {
                    class_5250 parseText3 = ParseI18n.parse(chatText3.getText());
                    width = font.method_27525((class_5348)parseText3);
                    ChatBubbleRenderer.renderChatBubbleBody(0, -62 + ChatBubbleRenderer.getRenderYOffset(maid), width, data3, arg_0 -> ChatBubbleRenderer.lambda$renderChatBubble$11((class_2561)parseText3, maid, width, packedLight, arg_0));
                }
                if (chatText3.isIcon()) {
                    ChatBubbleRenderer.renderChatBubbleBody(0, -62 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data3, d -> ChatBubbleRenderer.renderIcon(0, -62 + ChatBubbleRenderer.getRenderYOffset(maid), chatText3.getIconPath(), d));
                }
            }
        }
    }

    private static int getRenderYOffset(EntityMaid maid) {
        if (maid.method_6113()) {
            return 48;
        }
        return 0;
    }

    private static void renderText(class_2561 chatText, int startX, int startY, int width, int packedLight, RenderData data) {
        class_327 font = data.renderer.method_3932();
        font.method_30882(chatText, (float)(-width) / 2.0f + (float)startX, (float)(startY + 6), -16777216, false, data.matrixStack.method_23760().method_23761(), data.buffer, class_327.class_6415.field_33993, 0, packedLight);
    }

    private static void renderIcon(int startX, int startY, class_2960 iconPath, RenderData data) {
        class_4588 iconVertexBuilder = data.buffer.getBuffer(CHAT_BUBBLE_RENDER.apply(iconPath));
        class_1044 texture = class_310.method_1551().method_1531().method_4619(iconPath);
        if (texture instanceof SizeTexture) {
            int textureWidth;
            SizeTexture sizeTexture = (SizeTexture)texture;
            int textureHeight = sizeTexture.getHeight();
            int count = textureHeight / ((textureWidth = sizeTexture.getWidth()) / 3);
            if (count <= 1) {
                ChatBubbleRenderer.drawIcon(data.matrixStack, iconVertexBuilder, startX - 30, startY, 0.0f, 0.0f, 1.0f);
            } else {
                int iconDelay = data.maid.field_6012 / 2 % count;
                float vStart = 1.0f / (float)count * (float)iconDelay;
                float vEnd = 1.0f / (float)count * (float)(iconDelay + 1);
                ChatBubbleRenderer.drawIcon(data.matrixStack, iconVertexBuilder, startX - 30, startY, 0.0f, vStart, vEnd);
            }
        }
    }

    private static float getChatBubbleStartHeight(EntityMaidRenderer renderer, EntityMaid maid) {
        float height = maid.method_17682() + 0.75f;
        if (((BedrockModel)renderer.method_4038()).hasHead()) {
            height = (24.0f - ((BedrockModel)renderer.method_4038()).getHead().y) * 0.0625f + 0.75f;
        }
        return height;
    }

    private static void getTmpChatBubbles(EntityMaid maid) {
        MaidChatBubbles chatBubble = maid.getChatBubble();
        Pair<Long, ChatText> bubble1 = chatBubble.bubble1();
        Pair<Long, ChatText> bubble2 = chatBubble.bubble2();
        Pair<Long, ChatText> bubble3 = chatBubble.bubble3();
        TMP_CHAT_BUBBLES.clear();
        if (bubble1 != MaidChatBubbles.EMPTY) {
            TMP_CHAT_BUBBLES.add(bubble1);
        }
        if (bubble2 != MaidChatBubbles.EMPTY) {
            TMP_CHAT_BUBBLES.add(bubble2);
        }
        if (bubble3 != MaidChatBubbles.EMPTY) {
            TMP_CHAT_BUBBLES.add(bubble3);
        }
    }

    private static void renderChatBubbleBody(int startX, int startY, int stringWidth, RenderData data, Consumer<RenderData> consumer) {
        class_2960 bg = data.renderer.getMainInfo().getChatBubble().getBg();
        float height = ChatBubbleRenderer.getChatBubbleStartHeight(data.renderer, data.maid);
        int count = stringWidth / 20;
        int fullWidth = (count + 2) * 20;
        int leftStartX = -fullWidth / 2 + startX;
        int rightStartX = fullWidth / 2 - 20 + startX;
        int middleStartX = -fullWidth / 2 + 20 + startX;
        data.matrixStack.method_22903();
        data.matrixStack.method_46416(0.0f, height, 0.0f);
        data.matrixStack.method_22907(data.renderer.getDispatcher().method_24197());
        data.matrixStack.method_22905(0.025f, -0.025f, -0.025f);
        class_4588 vertexBuilder = data.buffer.getBuffer(CHAT_BUBBLE_RENDER.apply(bg));
        ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, leftStartX, startY, 0.2f, 0, 0);
        for (int i = 0; i < count; ++i) {
            ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, middleStartX, startY, 0.2f, 1, 0);
            middleStartX += 20;
        }
        ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, rightStartX, startY, 0.2f, 2, 0);
        if (LEFT_ARROW.equals(data.arrow)) {
            ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, leftStartX - 10, startY + 10, 0.19f, 0, 1);
        }
        if (MIDDLE_ARROW.equals(data.arrow)) {
            ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, startX - 10, startY + 10, 0.19f, 1, 1);
        }
        if (RIGHT_ARROW.equals(data.arrow)) {
            ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, rightStartX + 10, startY + 10, 0.19f, 2, 1);
        }
        consumer.accept(data);
        data.matrixStack.method_22909();
    }

    public static void drawBg(class_4587 matrixStack, class_4588 builder, int x, int y, float z, int uIndex, int vIndex) {
        float height = 20.0f;
        float width = 20.0f;
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        float u0 = (float)uIndex / 3.0f;
        float u1 = (float)(uIndex + 1) / 3.0f;
        float v0 = (float)vIndex / 2.0f;
        float v1 = (float)(vIndex + 1) / 2.0f;
        ChatBubbleRenderer.vertex(matrix4f, builder, x, (float)y + height, z, u0, v1);
        ChatBubbleRenderer.vertex(matrix4f, builder, (float)x + width, (float)y + height, z, u1, v1);
        ChatBubbleRenderer.vertex(matrix4f, builder, (float)x + width, y, z, u1, v0);
        ChatBubbleRenderer.vertex(matrix4f, builder, x, y, z, u0, v0);
    }

    public static void drawIcon(class_4587 matrixStack, class_4588 builder, int x, int y, float z, float vStart, float vEnd) {
        float height = 20.0f;
        float width = 60.0f;
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        ChatBubbleRenderer.vertex(matrix4f, builder, x, (float)y + height, z, 0.0f, vEnd);
        ChatBubbleRenderer.vertex(matrix4f, builder, (float)x + width, (float)y + height, z, 1.0f, vEnd);
        ChatBubbleRenderer.vertex(matrix4f, builder, (float)x + width, y, z, 1.0f, vStart);
        ChatBubbleRenderer.vertex(matrix4f, builder, x, y, z, 0.0f, vStart);
    }

    private static void vertex(Matrix4f matrix4f, class_4588 builder, float x, float y, float z, float u, float v) {
        builder.method_22918(matrix4f, x, y, z).method_22913(u, v);
    }

    private static class_1921 chatBubbleRender(class_2960 locationIn) {
        class_4668.class_5942 shaderStateShard = new class_4668.class_5942(class_757::method_34542);
        class_1921.class_4688 compositeState = class_1921.class_4688.method_23598().method_34578(shaderStateShard).method_34577((class_4668.class_5939)new class_4668.class_4683(locationIn, false, false)).method_23615(NO_TRANSPARENCY).method_23617(true);
        return class_1921.method_24049((String)"chat_bubble", (class_293)class_290.field_1585, (class_293.class_5596)class_293.class_5596.field_27382, (int)255, (boolean)true, (boolean)false, (class_1921.class_4688)compositeState);
    }

    private static /* synthetic */ void lambda$renderChatBubble$11(class_2561 parseText3, EntityMaid maid, int width, int packedLight, RenderData d) {
        ChatBubbleRenderer.renderText(parseText3, 0, -62 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d);
    }

    private static /* synthetic */ void lambda$renderChatBubble$9(class_2561 parseText2, int startX, EntityMaid maid, int width, int packedLight, RenderData d) {
        ChatBubbleRenderer.renderText(parseText2, startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d);
    }

    private static /* synthetic */ void lambda$renderChatBubble$7(class_2561 parseText1, int startX, EntityMaid maid, int width, int packedLight, RenderData d) {
        ChatBubbleRenderer.renderText(parseText1, startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d);
    }

    private static /* synthetic */ void lambda$renderChatBubble$5(class_2561 parseText2, int startX, EntityMaid maid, int width, int packedLight, RenderData d) {
        ChatBubbleRenderer.renderText(parseText2, startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d);
    }

    private static /* synthetic */ void lambda$renderChatBubble$3(class_2561 parseText1, int startX, EntityMaid maid, int width, int packedLight, RenderData d) {
        ChatBubbleRenderer.renderText(parseText1, startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d);
    }

    private static /* synthetic */ void lambda$renderChatBubble$1(class_2561 parseText, EntityMaid maid, int width, int packedLight, RenderData d) {
        ChatBubbleRenderer.renderText(parseText, 0, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d);
    }

    private static class RenderData {
        private final EntityMaidRenderer renderer;
        private final EntityMaid maid;
        private final class_4587 matrixStack;
        private final class_4597 buffer;
        private final String arrow;

        public RenderData(EntityMaidRenderer renderer, EntityMaid maid, class_4587 matrixStack, class_4597 buffer, String arrow) {
            this.renderer = renderer;
            this.maid = maid;
            this.matrixStack = matrixStack;
            this.buffer = buffer;
            this.arrow = arrow;
        }
    }
}

