/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource.pojo;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManger;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatText;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_2960;

public class ChatBubbleInfo {
    @SerializedName(value="bg")
    private class_2960 bg = null;
    @SerializedName(value="text")
    private Text text = null;

    public class_2960 getBg() {
        return this.bg;
    }

    public Text getText() {
        return this.text;
    }

    public ChatBubbleInfo decorate() {
        if (this.bg == null) {
            this.bg = ChatBubbleManger.DEFAULT_CHAT_BUBBLE.bg;
        }
        if (this.text == null) {
            this.text = ChatBubbleManger.DEFAULT_CHAT_BUBBLE.text;
        } else if (!this.text.isReplace()) {
            if (this.text.main.isEmpty()) {
                this.text.main = ChatBubbleManger.DEFAULT_CHAT_BUBBLE.text.main;
            } else {
                this.mergeChatText(this.text.main, ChatBubbleManger.DEFAULT_CHAT_BUBBLE.text.main);
            }
            if (this.text.special.isEmpty()) {
                this.text.special = ChatBubbleManger.DEFAULT_CHAT_BUBBLE.text.special;
            } else {
                this.mergeChatText(this.text.special, ChatBubbleManger.DEFAULT_CHAT_BUBBLE.text.special);
            }
            if (this.text.other.isEmpty()) {
                this.text.other = ChatBubbleManger.DEFAULT_CHAT_BUBBLE.text.other;
            } else {
                this.mergeChatText(this.text.other, ChatBubbleManger.DEFAULT_CHAT_BUBBLE.text.other);
            }
        }
        return this;
    }

    private void mergeChatText(HashMap<String, List<ChatText>> textTo, HashMap<String, List<ChatText>> textFrom) {
        for (String key : textFrom.keySet()) {
            List<ChatText> chatTexts = textFrom.get(key);
            if (textTo.containsKey(key)) {
                textTo.get(key).addAll(chatTexts);
                continue;
            }
            textTo.put(key, chatTexts);
        }
    }

    public static class Text {
        @SerializedName(value="replace")
        private boolean replace = false;
        @SerializedName(value="main")
        private HashMap<String, List<ChatText>> main = Maps.newHashMap();
        @SerializedName(value="special")
        private HashMap<String, List<ChatText>> special = Maps.newHashMap();
        @SerializedName(value="other")
        private HashMap<String, List<ChatText>> other = Maps.newHashMap();

        public boolean isReplace() {
            return this.replace;
        }

        public HashMap<String, List<ChatText>> getMain() {
            return this.main;
        }

        public HashMap<String, List<ChatText>> getSpecial() {
            return this.special;
        }

        public HashMap<String, List<ChatText>> getOther() {
            return this.other;
        }
    }
}

