/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.block.BlockJoy;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitPoi;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4158;
import net.minecraft.class_4215;

public class MaidJoyTask
extends MaidCheckRateTask {
    private final int closeEnoughDist;
    private final float speed;

    public MaidJoyTask(float movementSpeed, int closeEnoughDist) {
        super((Map<class_4140<?>, class_4141>)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457, InitEntities.TARGET_POS, (Object)class_4141.field_18457));
        this.closeEnoughDist = closeEnoughDist;
        this.speed = movementSpeed;
        this.setMaxCheckRate(10);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid maid) {
        if (super.checkExtraStartConditions(worldIn, maid) && maid.canBrainMoving()) {
            class_2338 joyPos = this.findJoy(worldIn, maid);
            if (joyPos != null && maid.method_18407(joyPos)) {
                if (joyPos.method_19770((class_2374)maid.method_19538()) < Math.pow(this.closeEnoughDist, 2.0)) {
                    maid.method_18868().method_18878(InitEntities.TARGET_POS, (Object)new class_4099(joyPos));
                    return true;
                }
                class_4215.method_24561((class_1309)maid, (class_2338)joyPos, (float)this.speed, (int)1);
                this.setNextCheckTickCount(5);
            } else {
                maid.method_18868().method_18875(InitEntities.TARGET_POS);
            }
        }
        return false;
    }

    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        maid.method_18868().method_18904(InitEntities.TARGET_POS).ifPresent(targetPos -> {
            class_2338 pos = targetPos.method_18989();
            class_2680 blockState = worldIn.method_8320(pos);
            class_2248 patt0$temp = blockState.method_26204();
            if (patt0$temp instanceof BlockJoy) {
                BlockJoy blockJoy = (BlockJoy)patt0$temp;
                blockJoy.startMaidSit(maid, blockState, (class_1937)worldIn, pos);
                class_1309 patt1$temp = maid.method_35057();
                if (patt1$temp instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)patt1$temp;
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, "maid_sit_joy");
                }
            }
        });
        maid.method_18868().method_18875(InitEntities.TARGET_POS);
        maid.method_18868().method_18875(class_4140.field_18445);
        maid.method_18868().method_18875(class_4140.field_18446);
    }

    @Nullable
    private class_2338 findJoy(class_3218 world, EntityMaid maid) {
        class_2338 blockPos = maid.getBrainSearchPos();
        class_4153 poiManager = world.method_19494();
        int range = (int)maid.method_18413();
        return poiManager.method_19125(type -> ((class_4158)type.comp_349()).equals((Object)InitPoi.JOY_BLOCK), blockPos, range, class_4153.class_4155.field_18489).map(class_4156::method_19141).filter(pos -> !this.isOccupied(world, (class_2338)pos)).min(Comparator.comparingDouble(pos -> pos.method_10262((class_2382)maid.method_24515()))).orElse(null);
    }

    private boolean isOccupied(class_3218 worldIn, class_2338 pos) {
        class_2586 te = worldIn.method_8321(pos);
        if (te instanceof TileEntityJoy) {
            TileEntityJoy joy = (TileEntityJoy)te;
            return worldIn.method_14190(joy.getSitId()) != null;
        }
        return true;
    }
}

