/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatTextType;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Type;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.StringUtils;

public final class ChatText {
    public static final class_2960 EMPTY_ICON_PATH = class_2960.method_60655((String)"touhou_little_maid", (String)"empty");
    public static final ChatText EMPTY_CHAT_TEXT = new ChatText(ChatTextType.EMPTY, EMPTY_ICON_PATH, "");
    public static final class_9139<ByteBuf, ChatText> STREAM_CODEC = class_9139.method_56436(ChatTextType.STREAM_CODEC, ChatText::getType, (class_9139)class_2960.field_48267, ChatText::getIconPath, (class_9139)class_9135.field_48554, ChatText::getText, ChatText::new);
    private static final String ICON_IDENTIFIER_CHAR = "%";
    private final ChatTextType type;
    private final class_2960 iconPath;
    private final String text;

    public ChatText(ChatTextType type, class_2960 iconPath, String text) {
        this.type = type;
        this.iconPath = iconPath;
        this.text = text;
    }

    public boolean isText() {
        return this.type == ChatTextType.TEXT;
    }

    public boolean isIcon() {
        return this.type == ChatTextType.ICON;
    }

    public class_2960 getIconPath() {
        return this.iconPath;
    }

    public String getText() {
        return this.text;
    }

    public ChatTextType getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChatText)) {
            return false;
        }
        ChatText chatText = (ChatText)obj;
        return this.type.equals((Object)chatText.type) && this.iconPath.equals((Object)chatText.iconPath) && this.text.equals(chatText.text);
    }

    public static class Serializer
    implements JsonDeserializer<ChatText> {
        public ChatText deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String text = class_3518.method_15287((JsonElement)json, (String)"chat_text");
            if (StringUtils.isEmpty((CharSequence)text)) {
                return EMPTY_CHAT_TEXT;
            }
            if (text.startsWith(ChatText.ICON_IDENTIFIER_CHAR) && text.endsWith(ChatText.ICON_IDENTIFIER_CHAR)) {
                String substring = text.substring(1, text.length() - 1);
                if (ResourceLocationUtil.isValidResourceLocation(substring)) {
                    return new ChatText(ChatTextType.ICON, class_2960.method_60654((String)substring), "");
                }
                return EMPTY_CHAT_TEXT;
            }
            return new ChatText(ChatTextType.TEXT, EMPTY_ICON_PATH, text);
        }
    }
}

