/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatText;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatTextType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_9262;
import net.minecraft.class_9301;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.apache.commons.lang3.StringUtils;

public class MaidScriptBookManager {
    private static final String STORE_TAG = "MaidScriptBook";
    private static final String SEPARATOR = "\n\n";
    private final Map<String, List<ChatText>> scripts = Maps.newHashMap();

    private static List<String> readBookPages(class_9302 bookContent) {
        return bookContent.method_57525(false).stream().map(class_2561::getString).toList();
    }

    private static List<String> readBookPages(class_9301 bookContent) {
        return bookContent.method_57517(false).toList();
    }

    private static class_9301 replaceBookContentWithPages(List<String> pages, class_9301 book) {
        return book.method_58187(pages.stream().map(class_9262::method_57137).toList());
    }

    private static void readScriptsFromPages(List<String> pages, Map<String, List<ChatText>> scripts) {
        scripts.clear();
        for (String page : pages) {
            String type;
            String[] split = StringUtils.split((String)page, (String)SEPARATOR);
            if (split.length < 2 || StringUtils.isBlank((CharSequence)(type = StringUtils.strip((String)split[0]).toLowerCase(Locale.US)))) continue;
            List scriptList = scripts.computeIfAbsent(type, k -> Lists.newArrayList());
            for (int j = 1; j < split.length; ++j) {
                String script = StringUtils.strip((String)split[j]);
                if (!StringUtils.isNotBlank((CharSequence)script)) continue;
                ChatText chatText = new ChatText(ChatTextType.TEXT, ChatText.EMPTY_ICON_PATH, script);
                scriptList.add(chatText);
            }
        }
    }

    private static void writeScriptsToPages(Map<String, List<ChatText>> scripts, List<String> pages) {
        pages.clear();
        for (Map.Entry<String, List<ChatText>> entry : scripts.entrySet()) {
            String type = entry.getKey();
            List<ChatText> scriptList = entry.getValue();
            if (scriptList.isEmpty()) continue;
            StringBuilder builder = new StringBuilder();
            builder.append(type).append(SEPARATOR);
            for (ChatText chatText : scriptList) {
                builder.append(chatText.getText()).append(SEPARATOR);
            }
            pages.add(builder.toString());
        }
    }

    public boolean installScript(class_1799 stack) {
        class_9302 writtenBookContent = (class_9302)stack.method_57824(class_9334.field_49606);
        if (writtenBookContent != null && !writtenBookContent.method_57525(false).isEmpty()) {
            List<String> pages = MaidScriptBookManager.readBookPages(writtenBookContent);
            MaidScriptBookManager.readScriptsFromPages(pages, this.scripts);
            return true;
        }
        class_9301 writableBookContent = (class_9301)stack.method_57824(class_9334.field_49653);
        if (writableBookContent != null && writableBookContent.method_57517(false).findAny().isPresent()) {
            List<String> pages = MaidScriptBookManager.readBookPages(writableBookContent);
            MaidScriptBookManager.readScriptsFromPages(pages, this.scripts);
            return true;
        }
        return false;
    }

    public void removeScript() {
        this.scripts.clear();
    }

    public boolean copyScript(class_1799 stack) {
        class_9301 book = (class_9301)stack.method_57824(class_9334.field_49653);
        if (book == null || !book.comp_2422().isEmpty()) {
            return false;
        }
        ArrayList pages = Lists.newArrayList();
        MaidScriptBookManager.writeScriptsToPages(this.scripts, pages);
        class_9301 newBook = MaidScriptBookManager.replaceBookContentWithPages(pages, book);
        stack.method_57379(class_9334.field_49653, (Object)newBook);
        return true;
    }

    public void addAdditionalSaveData(class_2487 compound) {
        class_2499 scriptsTags = new class_2499();
        ArrayList pages = Lists.newArrayList();
        MaidScriptBookManager.writeScriptsToPages(this.scripts, pages);
        for (String page : pages) {
            scriptsTags.add((Object)class_2519.method_23256((String)page));
        }
        compound.method_10566(STORE_TAG, (class_2520)scriptsTags);
    }

    public void readAdditionalSaveData(class_2487 compound) {
        if (!compound.method_10573(STORE_TAG, 9)) {
            return;
        }
        class_2499 scriptsTags = compound.method_10554(STORE_TAG, 8);
        ArrayList pages = Lists.newArrayList();
        for (class_2520 tag : scriptsTags) {
            pages.add(tag.method_10714());
        }
        MaidScriptBookManager.readScriptsFromPages(pages, this.scripts);
    }

    public List<ChatText> getScripts(String type) {
        return this.scripts.getOrDefault(type, Lists.newArrayList());
    }
}

