/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.CombinedInvWrapper;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.datagen.EnchantmentKeys;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7893;

public class TaskBowAttack
implements IRangedAttackTask {
    public static final class_2960 UID = class_2960.method_60655((String)"touhou_little_maid", (String)"ranged_attack");

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public class_1799 getIcon() {
        return class_1802.field_8102.method_7854();
    }

    @Override
    @Nullable
    public class_3414 getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, InitSounds.MAID_RANGE_ATTACK, 0.5f);
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(e -> this.hasBow((EntityMaid)e) && this.hasArrow((EntityMaid)e), IRangedAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.hasBow(maid) || !this.hasArrow(maid) || this.farAway((class_1309)target, maid));
        class_7893<EntityMaid> moveToTargetTask = MaidRangedWalkToTarget.create(0.6f);
        MaidAttackStrafingTask maidAttackStrafingTask = new MaidAttackStrafingTask();
        MaidShootTargetTask shootTargetTask = new MaidShootTargetTask(2);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, moveToTargetTask), Pair.of((Object)5, (Object)((Object)maidAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(e -> this.hasBow((EntityMaid)e) && this.hasArrow((EntityMaid)e), IRangedAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.hasBow(maid) || !this.hasArrow(maid) || this.farAway((class_1309)target, maid));
        MaidShootTargetTask shootTargetTask = new MaidShootTargetTask(2);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, class_1309 target, float distanceFactor) {
        class_1799 mainHandItem;
        class_1665 entityArrow = this.getArrow(shooter, distanceFactor);
        if (entityArrow != null && (mainHandItem = shooter.method_6047()).method_7909() instanceof class_1753) {
            double x = target.method_23317() - shooter.method_23317();
            double y = target.method_23320() - shooter.method_23320();
            double z = target.method_23321() - shooter.method_23321();
            float distance = shooter.method_5739((class_1297)target);
            float velocity = class_3532.method_15363((float)(distance / 10.0f), (float)1.6f, (float)3.2f);
            float inaccuracy = 1.0f - class_3532.method_15363((float)(distance / 100.0f), (float)0.0f, (float)0.9f);
            entityArrow.method_5875(true);
            entityArrow.method_7485(x, y, z, velocity, inaccuracy);
            mainHandItem.method_7970(1, (class_1309)shooter, class_1304.field_6173);
            shooter.method_5783(class_3417.field_14633, 1.0f, 1.0f / (shooter.method_59922().method_43057() * 0.4f + 0.8f));
            shooter.field_6002.method_8649((class_1297)entityArrow);
        }
    }

    @Override
    public boolean canSee(EntityMaid maid, class_1309 target) {
        return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.BOW_RANGE);
    }

    @Override
    public class_238 searchDimension(EntityMaid maid) {
        if (this.hasBow(maid)) {
            float searchRange = this.searchRadius(maid);
            if (maid.method_18410()) {
                return new class_238(maid.method_18412()).method_1014((double)searchRange);
            }
            return maid.method_5829().method_1014((double)searchRange);
        }
        return IRangedAttackTask.super.searchDimension(maid);
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        return ((Integer)MaidConfig.BOW_RANGE.get()).intValue();
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"has_bow", this::hasBow), Pair.of((Object)"has_arrow", this::hasArrow)});
    }

    private boolean hasBow(EntityMaid maid) {
        return maid.method_6047().method_7909() instanceof class_1753;
    }

    private boolean hasArrow(EntityMaid maid) {
        return this.findArrow(maid) >= 0;
    }

    private int findArrow(EntityMaid maid) {
        class_1799 mainHandItem = maid.method_6047();
        if (mainHandItem.method_7909() instanceof class_1753) {
            CombinedInvWrapper handler = maid.getAvailableInv(true);
            return ItemsUtil.findStackSlot(handler, ((class_1753)mainHandItem.method_7909()).method_19268());
        }
        return -1;
    }

    @Nullable
    private class_1665 getArrow(EntityMaid maid, float chargeTime) {
        int slot = this.findArrow(maid);
        if (slot < 0) {
            return null;
        }
        CombinedInvWrapper handler = maid.getAvailableInv(true);
        class_1799 arrowStack = handler.getStackInSlot(slot);
        class_1799 mainHandItem = maid.method_6047();
        class_5455 access = maid.field_6002.method_30349();
        class_1665 arrowEntity = class_1675.method_18813((class_1309)maid, (class_1799)arrowStack, (float)chargeTime, (class_1799)mainHandItem);
        class_1792 class_17922 = mainHandItem.method_7909();
        if (class_17922 instanceof class_1753) {
            class_1753 class_17532 = (class_1753)class_17922;
        }
        if (EnchantmentKeys.getEnchantmentLevel(access, (class_5321<class_1887>)class_1893.field_9125, mainHandItem) <= 0) {
            arrowStack.method_7934(1);
            handler.setStackInSlot(slot, arrowStack);
            arrowEntity.field_7572 = class_1665.class_1666.field_7593;
        }
        class_1324 attackDamage = maid.method_5996(class_5134.field_23721);
        double attackValue = 2.0;
        if (attackDamage != null) {
            attackValue = attackDamage.method_6201();
        }
        float multiplier = (float)(attackValue / 2.0);
        arrowEntity.method_7438(arrowEntity.method_7448() * (double)multiplier);
        return arrowEntity;
    }

    private boolean farAway(class_1309 target, EntityMaid maid) {
        return maid.method_5739((class_1297)target) > this.searchRadius(maid);
    }
}

