/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.datagen.EnchantmentKeys;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuShoot;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.item.ItemHakureiGohei;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4140;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7893;

public class TaskDanmakuAttack
implements IRangedAttackTask {
    public static final class_2960 UID = class_2960.method_60655((String)"touhou_little_maid", (String)"danmaku_attack");

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public class_1799 getIcon() {
        return InitItems.HAKUREI_GOHEI.method_7854();
    }

    @Override
    @Nullable
    public class_3414 getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, InitSounds.MAID_DANMAKU_ATTACK, 0.5f);
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(this::hasGohei, IRangedAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.hasGohei(maid) || this.farAway((class_1309)target, maid));
        class_7893<EntityMaid> moveToTargetTask = MaidRangedWalkToTarget.create(0.6f);
        MaidAttackStrafingTask maidAttackStrafingTask = new MaidAttackStrafingTask();
        MaidShootTargetTask shootTargetTask = new MaidShootTargetTask(2);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, moveToTargetTask), Pair.of((Object)5, (Object)((Object)maidAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(this::hasGohei, IRangedAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.hasGohei(maid) || this.farAway((class_1309)target, maid));
        MaidShootTargetTask shootTargetTask = new MaidShootTargetTask(2);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public boolean canSee(EntityMaid maid, class_1309 target) {
        return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.DANMAKU_RANGE);
    }

    @Override
    public class_238 searchDimension(EntityMaid maid) {
        if (this.hasGohei(maid)) {
            float searchRange = this.searchRadius(maid);
            if (maid.method_18410()) {
                return new class_238(maid.method_18412()).method_1014((double)searchRange);
            }
            return maid.method_5829().method_1014((double)searchRange);
        }
        return IRangedAttackTask.super.searchDimension(maid);
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        return ((Integer)MaidConfig.DANMAKU_RANGE.get()).intValue();
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, class_1309 target, float distanceFactor) {
        shooter.method_18868().method_18904(class_4140.field_18441).ifPresent(livingEntities -> {
            class_1799 mainHandItem = shooter.method_6047();
            if (ItemHakureiGohei.isGohei(mainHandItem)) {
                long entityCount = livingEntities.stream().filter(test -> this.enemyEntityTest(shooter, target, (class_1309)test)).count();
                class_1937 level = shooter.method_37908();
                class_1324 attackDamage = shooter.method_5996(class_5134.field_23721);
                float attackValue = 2.0f;
                if (attackDamage != null) {
                    attackValue = (float)attackDamage.method_6201();
                }
                class_5455 access = shooter.field_6002.method_30349();
                int impedingLevel = EnchantmentKeys.getEnchantmentLevel(access, EnchantmentKeys.IMPEDING, mainHandItem);
                int speedyLevel = EnchantmentKeys.getEnchantmentLevel(access, EnchantmentKeys.SPEEDY, mainHandItem);
                int multiShotLevel = EnchantmentKeys.getEnchantmentLevel(access, (class_5321<class_1887>)class_1893.field_9108, mainHandItem);
                int endersEnderLevel = EnchantmentKeys.getEnchantmentLevel(access, EnchantmentKeys.ENDERS_ENDER, mainHandItem);
                float speed = 0.3f * (distanceFactor + 1.0f) * (float)(speedyLevel + 1);
                boolean hurtEnderman = endersEnderLevel > 0;
                float distance = shooter.method_5739((class_1297)target);
                speed += class_3532.method_15363((float)(distance / 40.0f - 0.4f), (float)0.0f, (float)2.4f);
                float inaccuracy = 1.0f - class_3532.method_15363((float)(distance / 100.0f), (float)0.0f, (float)0.8f);
                if (entityCount <= 1L) {
                    if (multiShotLevel > 0) {
                        DanmakuShoot.create().setWorld(level).setThrower((class_1309)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(attackValue * (distanceFactor + 1.2f)).setGravity(0.0f).setVelocity(speed).setHurtEnderman(hurtEnderman).setInaccuracy(inaccuracy).setFanNum(3).setYawTotal(0.2617993877991494).setImpedingLevel(impedingLevel).fanShapedShot();
                    } else {
                        DanmakuShoot.create().setWorld(level).setThrower((class_1309)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(attackValue * (distanceFactor + 1.0f)).setGravity(0.0f).setVelocity(speed).setHurtEnderman(hurtEnderman).setInaccuracy(inaccuracy / 5.0f).setImpedingLevel(impedingLevel).aimedShot();
                    }
                } else if (entityCount <= 5L) {
                    DanmakuShoot.create().setWorld(level).setThrower((class_1309)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(attackValue * (distanceFactor + 1.2f)).setGravity(0.0f).setVelocity(speed).setHurtEnderman(hurtEnderman).setInaccuracy(inaccuracy / 5.0f).setFanNum(8).setYawTotal(1.0471975511965976).setImpedingLevel(impedingLevel).fanShapedShot();
                } else {
                    DanmakuShoot.create().setWorld(level).setThrower((class_1309)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(attackValue * (distanceFactor + 1.5f)).setGravity(0.0f).setVelocity(speed).setHurtEnderman(hurtEnderman).setInaccuracy(inaccuracy / 5.0f).setFanNum(32).setYawTotal(2.0943951023931953).setImpedingLevel(impedingLevel).fanShapedShot();
                }
                mainHandItem.method_7970(1, (class_1309)shooter, class_1304.field_6173);
            }
        });
    }

    private boolean enemyEntityTest(EntityMaid shooter, class_1309 target, class_1309 test) {
        boolean canAttack = shooter.method_18395(test);
        boolean sameType = target.method_5864().equals(test.method_5864());
        return canAttack && sameType && shooter.canSee(test);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.singletonList(Pair.of((Object)"has_gohei", this::hasGohei));
    }

    private boolean hasGohei(EntityMaid maid) {
        return ItemHakureiGohei.isGohei(maid.method_6047());
    }

    private boolean farAway(class_1309 target, EntityMaid maid) {
        return maid.method_5739((class_1297)target) > this.searchRadius(maid);
    }
}

