/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskAttack;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskBoardGames;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskBowAttack;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskCocoa;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskCrossBowAttack;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskDanmakuAttack;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskExtinguishing;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskFeedAnimal;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskFeedOwner;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskFishing;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskGrass;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskHoney;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskIdle;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskMelon;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskMilk;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskNormalFarm;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskShears;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskSnow;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskSugarCane;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskTorch;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskTridentAttack;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;

public final class TaskManager {
    private static Map<class_2960, IMaidTask> TASK_MAP;
    private static List<IMaidTask> TASK_INDEX;
    private static IMaidTask IDLE_TASK;

    private TaskManager() {
        IDLE_TASK = new TaskIdle();
        TASK_MAP = Maps.newHashMap();
        TASK_INDEX = Lists.newArrayList();
    }

    public static void init() {
        TaskManager manager = new TaskManager();
        manager.add(IDLE_TASK);
        manager.add(new TaskAttack());
        manager.add(new TaskBowAttack());
        manager.add(new TaskCrossBowAttack());
        manager.add(new TaskDanmakuAttack());
        manager.add(new TaskTridentAttack());
        manager.add(new TaskNormalFarm());
        manager.add(new TaskSugarCane());
        manager.add(new TaskMelon());
        manager.add(new TaskCocoa());
        manager.add(new TaskHoney());
        manager.add(new TaskGrass());
        manager.add(new TaskSnow());
        manager.add(new TaskFeedOwner());
        manager.add(new TaskShears());
        manager.add(new TaskMilk());
        manager.add(new TaskTorch());
        manager.add(new TaskFeedAnimal());
        manager.add(new TaskFishing());
        manager.add(new TaskExtinguishing());
        manager.add(new TaskBoardGames());
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.addMaidTask(manager);
        }
        TASK_MAP = ImmutableMap.copyOf(TASK_MAP);
        TASK_INDEX = ImmutableList.copyOf(TASK_INDEX);
    }

    public static Optional<IMaidTask> findTask(class_2960 uid) {
        return Optional.ofNullable(TASK_MAP.get(uid));
    }

    public static IMaidTask getIdleTask() {
        return IDLE_TASK;
    }

    public static Map<class_2960, IMaidTask> getTaskMap() {
        return TASK_MAP;
    }

    public static List<IMaidTask> getTaskIndex() {
        return TASK_INDEX;
    }

    public void add(IMaidTask task) {
        TASK_MAP.put(task.getUid(), task);
        TASK_INDEX.add(task);
    }
}

