/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.Cube;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.FaceUv;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.ModelProperties;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.UvFaces;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.UvUnion;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoQuad;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoVertex;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.VectorUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class GeoCube {
    public final List<GeoQuad> quads = new ObjectArrayList(6);
    public final Vector3f size = new Vector3f();

    private GeoCube(double[] size) {
        if (size.length >= 3) {
            this.size.set((float)size[0], (float)size[1], (float)size[2]);
        }
    }

    public static GeoCube createFromPojoCube(Cube cubeIn, ModelProperties properties, Double boneInflate, Boolean mirror) {
        GeoQuad quadDown;
        GeoQuad quadUp;
        GeoQuad quadSouth;
        GeoQuad quadNorth;
        GeoQuad quadEast;
        GeoQuad quadWest;
        GeoCube cube = new GeoCube(cubeIn.getSize());
        UvUnion uvUnion = cubeIn.getUv();
        UvFaces faces = uvUnion.faceUV;
        boolean isBoxUV = uvUnion.isBoxUV;
        double inflate = cubeIn.getInflate() == null ? (boneInflate == null ? 0.0 : boneInflate) : cubeIn.getInflate() / 16.0;
        float textureHeight = properties.getTextureHeight().floatValue();
        float textureWidth = properties.getTextureWidth().floatValue();
        class_243 size = VectorUtils.fromArray(cubeIn.getSize());
        class_243 origin = VectorUtils.fromArray(cubeIn.getOrigin());
        origin = new class_243(-(origin.field_1352 + size.field_1352) / 16.0, origin.field_1351 / 16.0, origin.field_1350 / 16.0);
        size = size.method_18805(0.0625, 0.0625, 0.0625);
        Vector3f rotation = VectorUtils.convertDoubleToFloat(VectorUtils.fromArray(cubeIn.getRotation()));
        rotation.mul(-1.0f, -1.0f, 1.0f);
        rotation.set((float)Math.toRadians(rotation.x()), (float)Math.toRadians(rotation.y()), (float)Math.toRadians(rotation.z()));
        Vector3f pivot = VectorUtils.convertDoubleToFloat(VectorUtils.fromArray(cubeIn.getPivot()));
        pivot.mul(-1.0f, 1.0f, 1.0f);
        GeoVertex P12 = new GeoVertex(origin.field_1352 - inflate, origin.field_1351 - inflate, origin.field_1350 - inflate);
        GeoVertex P22 = new GeoVertex(origin.field_1352 - inflate, origin.field_1351 - inflate, origin.field_1350 + size.field_1350 + inflate);
        GeoVertex P32 = new GeoVertex(origin.field_1352 - inflate, origin.field_1351 + size.field_1351 + inflate, origin.field_1350 - inflate);
        GeoVertex P42 = new GeoVertex(origin.field_1352 - inflate, origin.field_1351 + size.field_1351 + inflate, origin.field_1350 + size.field_1350 + inflate);
        GeoVertex P5 = new GeoVertex(origin.field_1352 + size.field_1352 + inflate, origin.field_1351 - inflate, origin.field_1350 - inflate);
        GeoVertex P6 = new GeoVertex(origin.field_1352 + size.field_1352 + inflate, origin.field_1351 - inflate, origin.field_1350 + size.field_1350 + inflate);
        GeoVertex P72 = new GeoVertex(origin.field_1352 + size.field_1352 + inflate, origin.field_1351 + size.field_1351 + inflate, origin.field_1350 - inflate);
        GeoVertex P8 = new GeoVertex(origin.field_1352 + size.field_1352 + inflate, origin.field_1351 + size.field_1351 + inflate, origin.field_1350 + size.field_1350 + inflate);
        if (!isBoxUV) {
            FaceUv west = faces.getWest();
            FaceUv east = faces.getEast();
            FaceUv north = faces.getNorth();
            FaceUv south = faces.getSouth();
            FaceUv up = faces.getUp();
            FaceUv down = faces.getDown();
            quadWest = west == null ? null : new GeoQuad(new GeoVertex[]{P42, P32, P12, P22}, west.getUv(), west.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11039);
            quadEast = east == null ? null : new GeoQuad(new GeoVertex[]{P72, P8, P6, P5}, east.getUv(), east.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11034);
            quadNorth = north == null ? null : new GeoQuad(new GeoVertex[]{P32, P72, P5, P12}, north.getUv(), north.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11043);
            quadSouth = south == null ? null : new GeoQuad(new GeoVertex[]{P8, P42, P22, P6}, south.getUv(), south.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11035);
            quadUp = up == null ? null : new GeoQuad(new GeoVertex[]{P42, P8, P72, P32}, up.getUv(), up.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11036);
            GeoQuad geoQuad = quadDown = down == null ? null : new GeoQuad(new GeoVertex[]{P12, P5, P6, P22}, down.getUv(), down.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11033);
            if (Boolean.TRUE.equals(cubeIn.getMirror()) || Boolean.TRUE.equals(mirror)) {
                quadWest = west == null ? null : new GeoQuad(new GeoVertex[]{P72, P8, P6, P5}, west.getUv(), west.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11039);
                quadEast = east == null ? null : new GeoQuad(new GeoVertex[]{P42, P32, P12, P22}, east.getUv(), east.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11034);
                quadNorth = north == null ? null : new GeoQuad(new GeoVertex[]{P32, P72, P5, P12}, north.getUv(), north.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11043);
                quadSouth = south == null ? null : new GeoQuad(new GeoVertex[]{P8, P42, P22, P6}, south.getUv(), south.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11035);
                quadUp = up == null ? null : new GeoQuad(new GeoVertex[]{P12, P5, P6, P22}, up.getUv(), up.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11036);
                quadDown = down == null ? null : new GeoQuad(new GeoVertex[]{P42, P8, P72, P32}, down.getUv(), down.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11033);
            }
        } else {
            double[] uv = cubeIn.getUv().boxUVCoords;
            class_243 uvSize = VectorUtils.fromArray(cubeIn.getSize());
            uvSize = new class_243(Math.floor(uvSize.field_1352), Math.floor(uvSize.field_1351), Math.floor(uvSize.field_1350));
            quadWest = new GeoQuad(new GeoVertex[]{P42, P32, P12, P22}, new double[]{uv[0] + uvSize.field_1350 + uvSize.field_1352, uv[1] + uvSize.field_1350}, new double[]{uvSize.field_1350, uvSize.field_1351}, textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11039);
            quadEast = new GeoQuad(new GeoVertex[]{P72, P8, P6, P5}, new double[]{uv[0], uv[1] + uvSize.field_1350}, new double[]{uvSize.field_1350, uvSize.field_1351}, textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11034);
            quadNorth = new GeoQuad(new GeoVertex[]{P32, P72, P5, P12}, new double[]{uv[0] + uvSize.field_1350, uv[1] + uvSize.field_1350}, new double[]{uvSize.field_1352, uvSize.field_1351}, textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11043);
            quadSouth = new GeoQuad(new GeoVertex[]{P8, P42, P22, P6}, new double[]{uv[0] + uvSize.field_1350 + uvSize.field_1352 + uvSize.field_1350, uv[1] + uvSize.field_1350}, new double[]{uvSize.field_1352, uvSize.field_1351}, textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11035);
            quadUp = new GeoQuad(new GeoVertex[]{P42, P8, P72, P32}, new double[]{uv[0] + uvSize.field_1350, uv[1]}, new double[]{uvSize.field_1352, uvSize.field_1350}, textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11036);
            quadDown = new GeoQuad(new GeoVertex[]{P12, P5, P6, P22}, new double[]{uv[0] + uvSize.field_1350 + uvSize.field_1352, uv[1] + uvSize.field_1350}, new double[]{uvSize.field_1352, -uvSize.field_1350}, textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11033);
            if (Boolean.TRUE.equals(cubeIn.getMirror()) || Boolean.TRUE.equals(mirror)) {
                quadWest = new GeoQuad(new GeoVertex[]{P72, P8, P6, P5}, new double[]{uv[0] + uvSize.field_1350 + uvSize.field_1352, uv[1] + uvSize.field_1350}, new double[]{uvSize.field_1350, uvSize.field_1351}, textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11039);
                quadEast = new GeoQuad(new GeoVertex[]{P42, P32, P12, P22}, new double[]{uv[0], uv[1] + uvSize.field_1350}, new double[]{uvSize.field_1350, uvSize.field_1351}, textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11034);
                quadNorth = new GeoQuad(new GeoVertex[]{P32, P72, P5, P12}, new double[]{uv[0] + uvSize.field_1350, uv[1] + uvSize.field_1350}, new double[]{uvSize.field_1352, uvSize.field_1351}, textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11043);
                quadSouth = new GeoQuad(new GeoVertex[]{P8, P42, P22, P6}, new double[]{uv[0] + uvSize.field_1350 + uvSize.field_1352 + uvSize.field_1350, uv[1] + uvSize.field_1350}, new double[]{uvSize.field_1352, uvSize.field_1351}, textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11035);
                quadUp = new GeoQuad(new GeoVertex[]{P42, P8, P72, P32}, new double[]{uv[0] + uvSize.field_1350, uv[1]}, new double[]{uvSize.field_1352, uvSize.field_1350}, textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11036);
                quadDown = new GeoQuad(new GeoVertex[]{P12, P5, P6, P22}, new double[]{uv[0] + uvSize.field_1350 + uvSize.field_1352, uv[1] + uvSize.field_1350}, new double[]{uvSize.field_1352, -uvSize.field_1350}, textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11033);
            }
        }
        if (quadWest != null) {
            cube.quads.add(quadWest);
        }
        if (quadEast != null) {
            cube.quads.add(quadEast);
        }
        if (quadNorth != null) {
            cube.quads.add(quadNorth);
        }
        if (quadSouth != null) {
            cube.quads.add(quadSouth);
        }
        if (quadUp != null) {
            cube.quads.add(quadUp);
        }
        if (quadDown != null) {
            cube.quads.add(quadDown);
        }
        class_4587 poseStack = new class_4587();
        poseStack.method_49278(new Quaternionf().rotateZYX(rotation.z(), rotation.y(), rotation.x()), pivot.x() / 16.0f, pivot.y() / 16.0f, pivot.z() / 16.0f);
        for (GeoQuad quad : cube.quads) {
            quad.normal.mul((Matrix3fc)poseStack.method_23760().method_23762());
            for (GeoVertex vertex : quad.vertices) {
                Vector4f vec4 = new Vector4f(vertex.position.x, vertex.position.y, vertex.position.z, 1.0f);
                vec4.mul((Matrix4fc)poseStack.method_23760().method_23761());
                vertex.position.set(vec4.x, vec4.y, vec4.z);
            }
        }
        return cube;
    }
}

