/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandler;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public final class ItemsUtil {
    private ItemsUtil() {
    }

    public static void dropEntityItems(class_1297 entity, IItemHandler itemHandler, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            class_1799 stackInSlot = itemHandler.getStackInSlot(i);
            class_1799 extractItem = itemHandler.extractItem(i, stackInSlot.method_7947(), false);
            if (extractItem.method_7960()) continue;
            entity.method_5775(extractItem);
        }
    }

    public static void dropEntityItems(class_1297 entity, IItemHandler itemHandler, int startIndex) {
        ItemsUtil.dropEntityItems(entity, itemHandler, startIndex, itemHandler.getSlots());
    }

    public static void dropEntityItems(class_1297 entity, IItemHandler itemHandler) {
        ItemsUtil.dropEntityItems(entity, itemHandler, 0, itemHandler.getSlots());
    }

    public static int findStackSlot(IItemHandler handler, Predicate<class_1799> filter) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            class_1799 stack = handler.getStackInSlot(i);
            if (!filter.test(stack)) continue;
            return i;
        }
        return -1;
    }

    public static List<Integer> getFilterStackSlots(IItemHandler handler, Predicate<class_1799> filter) {
        IntArrayList slots = new IntArrayList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            class_1799 stack = handler.getStackInSlot(i);
            if (!filter.test(stack)) continue;
            slots.add(i);
        }
        return slots;
    }

    public static boolean isStackIn(IItemHandler handler, Predicate<class_1799> filter) {
        return ItemsUtil.findStackSlot(handler, filter) >= 0;
    }

    public static class_1799 getStack(IItemHandler handler, Predicate<class_1799> filter) {
        int slotIndex = ItemsUtil.findStackSlot(handler, filter);
        if (slotIndex >= 0) {
            return handler.getStackInSlot(slotIndex);
        }
        return class_1799.field_8037;
    }

    public static int getBaubleSlotInMaid(EntityMaid maid, IMaidBauble bauble) {
        BaubleItemHandler handler = maid.getMaidBauble();
        for (int i = 0; i < handler.getSlots(); ++i) {
            IMaidBauble baubleIn = handler.getBaubleInSlot(i);
            if (baubleIn != bauble) continue;
            return i;
        }
        return -1;
    }

    public static String getItemId(class_1792 item) {
        class_2960 key = class_7923.field_41178.method_10221((Object)item);
        Preconditions.checkNotNull((Object)key);
        return key.toString();
    }

    public static class_1799 getItemStack(String itemId) {
        class_2960 resourceLocation = class_2960.method_60654((String)itemId);
        class_1792 value = (class_1792)class_7923.field_41178.method_10223(resourceLocation);
        return new class_1799((class_1935)value);
    }
}

