package com.github.tartaricacid.touhoulittlemaid.block.multiblock;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.block.IMultiBlock;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagBlock;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityAltar;
import com.github.tartaricacid.touhoulittlemaid.util.PosListData;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3499;

public class MultiBlockAltar implements IMultiBlock {
    private static final class_2960 ALTAR_SOUTH = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "altar_south");
    private static final class_2960 ALTAR_NORTH = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "altar_north");
    private static final class_2960 ALTAR_EAST = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "altar_east");
    private static final class_2960 ALTAR_WEST = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "altar_west");
    private static final class_2338 SOUTH_POS = new class_2338(-4, -3, 0);
    private static final class_2338 NORTH_POS = new class_2338(-3, -3, -7);
    private static final class_2338 EAST_POS = new class_2338(0, -3, -3);
    private static final class_2338 WEST_POS = new class_2338(-7, -3, -4);

    @Override
    public boolean isCoreBlock(class_2680 blockState) {
        return blockState.method_26164(TagBlock.ALTAR_TORII);
    }

    @Override
    public boolean isMatch(class_1937 world, class_2338 posStart, class_2350 direction, class_3499 template) {
        class_3499.class_5162 palette = template.field_15586.getFirst();
        for (class_3499.class_3501 blockInfo : palette.method_27125()) {
            class_2680 worldState = world.method_8320(posStart.method_10081(blockInfo.comp_1341()));
            class_2680 infoState = blockInfo.comp_1342();
            // 橡木部分 -> 御柱
            if (infoState.method_27852(class_2246.field_10431)) {
                if (!worldState.method_26164(TagBlock.ALTAR_PILLAR)) {
                    return false;
                }
            }
            // 羊毛部分 -> 鸟居
            else if (infoState.method_27852(class_2246.field_10314)) {
                if (!worldState.method_26164(TagBlock.ALTAR_TORII)) {
                    return false;
                }
            }
            // 其他情况照常检查
            else if (!worldState.equals(infoState)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void build(class_1937 worldIn, class_2338 posStart, class_2350 direction, class_3499 template) {
        PosListData posList = new PosListData();
        PosListData canPlaceItemPosList = new PosListData();
        class_3499.class_5162 palette = template.field_15586.getFirst();

        for (class_3499.class_3501 blockInfo : palette.method_27125()) {
            posList.add(posStart.method_10081(blockInfo.comp_1341()));
            if (blockInfo.comp_1341().method_10264() == 2 && blockInfo.comp_1342().method_27852(class_2246.field_10431)) {
                canPlaceItemPosList.add(posStart.method_10081(blockInfo.comp_1341()));
            }
        }

        class_2338 currentCenterPos = posStart.method_10059(getCenterPos(direction));
        for (class_3499.class_3501 blockInfo : palette.method_27125()) {
            class_2338 currentPos = posStart.method_10081(blockInfo.comp_1341());
            class_2680 currentState = worldIn.method_8320(currentPos);
            worldIn.method_8652(currentPos, InitBlocks.ALTAR.method_9564(), class_2248.field_31036);
            class_2586 te = worldIn.method_8321(currentPos);
            if (te instanceof TileEntityAltar altar) {
                boolean isRender = currentPos.equals(currentCenterPos);
                boolean canPlaceItem = blockInfo.comp_1341().method_10264() == 2 && blockInfo.comp_1342().method_27852(class_2246.field_10431);
                altar.setForgeData(currentState, isRender,
                        canPlaceItem, direction, posList, canPlaceItemPosList);
            }
        }
    }

    @Override
    public boolean directionIsSuitable(class_2350 direction) {
        return direction != class_2350.field_11033 && direction != class_2350.field_11036;
    }

    @Override
    public class_2338 getCenterPos(class_2350 facing) {
        return switch (facing) {
            case field_11043 -> SOUTH_POS;
            case field_11034 -> WEST_POS;
            case field_11039 -> EAST_POS;
            default -> NORTH_POS;
        };
    }

    @Override
    public class_3499 getTemplate(class_3218 world, class_2350 facing) {
        return switch (facing) {
            case field_11043 -> getAltarTemplate(world, ALTAR_SOUTH);
            case field_11034 -> getAltarTemplate(world, ALTAR_WEST);
            case field_11039 -> getAltarTemplate(world, ALTAR_EAST);
            default -> getAltarTemplate(world, ALTAR_NORTH);
        };
    }

    private class_3499 getAltarTemplate(class_3218 world, class_2960 location) {
        return world.method_14183().method_15091(location);
    }
}
