package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class MaidAttackStrafingTask extends class_4097<EntityMaid> {
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public MaidAttackStrafingTask() {
        super(ImmutableMap.of(class_4140.field_18445, class_4141.field_18457,
                        class_4140.field_18446, class_4141.field_18458,
                        class_4140.field_22355, class_4141.field_18456,
                        class_4140.field_18442, class_4141.field_18456),
                1200);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        return owner.method_6047().method_7909() instanceof class_1811 &&
               owner.method_18868().method_18904(class_4140.field_22355)
                       .filter(class_1297::method_5805)
                       .isPresent();
    }

    @Override
    protected void tick(class_3218 worldIn, EntityMaid owner, long gameTime) {
        class_1799 stack = owner.method_6047();
        if (!(stack.method_7909() instanceof class_1811)) {
            return;
        }
        owner.method_18868().method_18904(class_4140.field_22355).ifPresent((target) -> {
            int maxAttackDistance = ((class_1811) stack.method_7909()).method_24792();
            double distance = owner.method_5739(target);

            // 如果在最大攻击距离之内，而且看见的时长足够长
            if (distance < owner.searchRadius()) {
                ++this.strafingTime;
            } else {
                this.strafingTime = -1;
            }

            // 如果攻击时间也足够长，随机对走位方向和前后走位进行反转
            if (this.strafingTime >= 20) {
                if (owner.method_59922().method_43057() < 0.3) {
                    this.strafingClockwise = !this.strafingClockwise;
                }
                if (owner.method_59922().method_43057() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }

            // 如果攻击时间大于 -1
            if (this.strafingTime > -1) {
                // 依据距离远近决定是否前后走位
                if (distance > maxAttackDistance * 0.5) {
                    this.strafingBackwards = false;
                } else if (distance < maxAttackDistance * 0.2) {
                    this.strafingBackwards = true;
                }

                // 应用走位
                owner.method_5962().method_6243(this.strafingBackwards ? -0.5F : 0.5F, this.strafingClockwise ? 0.5F : -0.5F);
                owner.method_36456(class_3532.method_20306(owner.method_36454(), owner.field_6241, 0.0F));
                class_4215.method_19554(owner, target);
            } else {
                // 否则只朝向攻击目标
                class_4215.method_19554(owner, target);
            }
        });
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    @Override
    protected void stop(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(false);
        entityIn.method_5962().method_6243(0, 0);
    }

    @Override
    protected boolean canStillUse(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        return this.checkExtraStartConditions(worldIn, entityIn);
    }
}
