package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandler;
import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class MaidFarmMoveTask extends MaidMoveToBlockTask {
    private final class_2371<class_1799> seeds = class_2371.method_10211();
    private final IFarmTask task;

    public MaidFarmMoveTask(IFarmTask task, float movementSpeed) {
        super(movementSpeed, 2);
        this.task = task;
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        seeds.clear();
        IItemHandler inv = entityIn.getAvailableInv(true);
        for (int i = 0; i < inv.getSlots(); i++) {
            class_1799 stack = inv.getStackInSlot(i);
            if (task.isSeed(stack)) {
                seeds.add(stack);
            }
        }
        this.searchForDestination(worldIn, entityIn);
    }

    @Override
    protected boolean shouldMoveTo(class_3218 worldIn, EntityMaid maid, class_2338 basePos) {
        if (task.checkCropPosAbove()) {
            class_2338 above2Pos = basePos.method_10086(2);
            class_2680 stateUp2 = worldIn.method_8320(above2Pos);
            if (!stateUp2.method_26220(worldIn, above2Pos).method_1110()) {
                return false;
            }
        }

        class_2338 cropPos = basePos.method_10084();
        class_2680 cropState = worldIn.method_8320(cropPos);
        if (task.canHarvest(maid, cropPos, cropState)) {
            return true;
        }

        class_2680 baseState = worldIn.method_8320(basePos);
        return seeds.stream().anyMatch(seed -> task.canPlant(maid, basePos, baseState, seed));
    }
}
