package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManger;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import net.minecraft.class_6670;

public class MaidFeedAnimalTask extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 12;
    private final float speedModifier;
    private final int maxAnimalCount;
    private class_1429 feedEntity = null;
    private long chatBubbleKey = -1;

    public MaidFeedAnimalTask(float speedModifier, int maxAnimalCount) {
        super(ImmutableMap.of(class_4140.field_18442, class_4141.field_18456,
                class_4140.field_18445, class_4141.field_18457));
        this.speedModifier = speedModifier;
        this.maxAnimalCount = maxAnimalCount;
        this.setMaxCheckRate(MAX_DELAY_TIME);
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        feedEntity = null;
        long animalCount = this.getEntities(maid)
                .method_38980(e -> maid.method_18407(e.method_24515()))
                .filter(class_1297::method_5805)
                .filter(e -> e instanceof class_1429).count();

        if (animalCount < maxAnimalCount) {
            this.getEntities(maid)
                    .method_38980(e -> maid.method_18407(e.method_24515()))
                    .filter(class_1297::method_5805)
                    .filter(e -> e instanceof class_1429)
                    .filter(e -> ((class_1429) e).method_5618() == 0)
                    .filter(e -> ((class_1429) e).method_6482())
                    .filter(e -> ItemsUtil.isStackIn(maid.getAvailableInv(false), ((class_1429) e)::method_6481))
                    .filter(maid::canPathReach)
                    .findFirst()
                    .ifPresent(e -> {
                        feedEntity = (class_1429) e;
                        class_4215.method_24557(maid, e, this.speedModifier, 0);
                    });

            if (feedEntity != null && feedEntity.method_24516(maid, 2)) {
                class_1799 food = ItemsUtil.getStack(maid.getAvailableInv(false), feedEntity::method_6481);
                if (!food.method_7960()) {
                    food.method_7934(1);
                    maid.method_6104(class_1268.field_5808);
                    feedEntity.method_6480(null);
                    if (maid.method_35057() instanceof class_3222 serverPlayer) {
                        InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.MAID_FEED_ANIMAL);
                    }
                }
                feedEntity = null;
            }
        } else {
            this.chatBubbleKey = maid.getChatBubbleManager().addTextChatBubbleIfTimeout("chat_bubble.touhou_little_maid.inner.feed_animal.max_number", chatBubbleKey);
        }
    }

    private class_6670 getEntities(EntityMaid maid) {
        return maid.method_18868().method_18904(class_4140.field_18442).orElse(class_6670.method_38971());
    }
}
