/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.AnimatableEntity;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.context.AnimationContext;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.Color;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.extended.LivingEntityRendererAccessor;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.data.EntityModelData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.EModelRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.IRenderCycle;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public abstract class GeoReplacedEntityRenderer<T extends class_1309, E extends AnimatableEntity<T>>
extends class_922<T, class_572<T>>
implements IGeoRenderer<T> {
    protected final List<GeoLayerRenderer> layerRenderers = new ObjectArrayList();
    protected AnimatableEntity<T> currentAnimatable;
    protected float widthScale = 1.0f;
    protected float heightScale = 1.0f;
    protected Matrix4f dispatchedMat = new Matrix4f();
    protected Matrix4f renderEarlyMat = new Matrix4f();
    protected class_4597 rtb = null;
    private IRenderCycle currentModelRenderCycle = EModelRenderCycle.INITIAL;

    public GeoReplacedEntityRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, (class_583)new class_572(renderManager.method_32167(class_5602.field_27577)), 0.5f);
    }

    public static int getPackedOverlay(class_1309 entity, float u) {
        return class_4608.method_23625((int)class_4608.method_23210((float)u), (int)class_4608.method_23212((entity.field_6235 > 0 || entity.field_6213 > 0 ? 1 : 0) != 0));
    }

    private static float getFacingAngle(class_2350 facingIn) {
        return switch (facingIn) {
            case class_2350.field_11035 -> 90.0f;
            case class_2350.field_11043 -> 270.0f;
            case class_2350.field_11034 -> 180.0f;
            default -> 0.0f;
        };
    }

    private static void renderLeashPiece(class_4588 buffer, Matrix4f positionMatrix, float xDif, float yDif, float zDif, int entityBlockLight, int holderBlockLight, int entitySkyLight, int holderSkyLight, float width, float yOffset, float xOffset, float zOffset, int segment, boolean isLeashKnot) {
        float piecePosPercent = (float)segment / 24.0f;
        int lerpBlockLight = (int)class_3532.method_16439((float)piecePosPercent, (float)entityBlockLight, (float)holderBlockLight);
        int lerpSkyLight = (int)class_3532.method_16439((float)piecePosPercent, (float)entitySkyLight, (float)holderSkyLight);
        int packedLight = class_765.method_23687((int)lerpBlockLight, (int)lerpSkyLight);
        float knotColourMod = segment % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = xDif * piecePosPercent;
        float y = yDif > 0.0f ? yDif * piecePosPercent * piecePosPercent : yDif - yDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = zDif * piecePosPercent;
        buffer.method_22918(positionMatrix, x - xOffset, y + yOffset, z + zOffset).method_22915(red, green, blue, 1.0f).method_60803(packedLight);
        buffer.method_22918(positionMatrix, x + xOffset, y + width - yOffset, z - zOffset).method_22915(red, green, blue, 1.0f).method_60803(packedLight);
    }

    @Override
    @Nonnull
    public IRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    @Override
    public void setCurrentModelRenderCycle(IRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }

    @Override
    public float getWidthScale(T animatable) {
        return this.widthScale;
    }

    @Override
    public float getHeightScale(T entity) {
        return this.heightScale;
    }

    @Override
    public void renderEarly(T animatable, class_4587 poseStack, float partialTick, class_4597 bufferSource, class_4588 buffer, int packedLight, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.renderEarlyMat = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        IGeoRenderer.super.renderEarly(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlayIn, red, green, blue, alpha);
    }

    public void method_4054(T entity, float entityYaw, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        this.render(entity, this.getAnimatableEntity(entity), entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void render(T entity, E animatable, float entityYaw, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        class_2350 direction;
        class_1297 class_12972;
        class_1308 mob;
        class_1297 leashHolder;
        this.currentAnimatable = animatable;
        this.dispatchedMat = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        boolean shouldSit = entity.method_5765() && entity.method_5854() != null;
        this.setCurrentModelRenderCycle(EModelRenderCycle.INITIAL);
        poseStack.method_22903();
        if (entity instanceof class_1308 && (leashHolder = (mob = (class_1308)entity).method_60952()) != null) {
            this.renderLeash(entity, partialTick, poseStack, bufferSource, leashHolder);
        }
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        entityModelData.isChild = entity.method_6109();
        float lerpBodyRot = class_3532.method_17821((float)partialTick, (float)((class_1309)entity).field_6220, (float)((class_1309)entity).field_6283);
        float lerpHeadRot = class_3532.method_17821((float)partialTick, (float)((class_1309)entity).field_6259, (float)((class_1309)entity).field_6241);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && (class_12972 = entity.method_5854()) instanceof class_1309) {
            class_1309 vehicle = (class_1309)class_12972;
            lerpBodyRot = class_3532.method_17821((float)partialTick, (float)vehicle.field_6220, (float)vehicle.field_6283);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = class_3532.method_15363((float)class_3532.method_15393((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (entity.method_18376() == class_4050.field_18078 && (direction = entity.method_18401()) != null) {
            float eyeOffset = entity.method_18381(class_4050.field_18076) - 0.1f;
            poseStack.method_46416((float)(-direction.method_10148()) * eyeOffset, 0.0f, (float)(-direction.method_10165()) * eyeOffset);
        }
        float lerpedAge = (float)((class_1309)entity).field_6012 + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        this.method_4058(entity, poseStack, lerpedAge, lerpBodyRot, partialTick, entity.method_55693());
        this.preRenderCallback((class_1309)entity, poseStack, partialTick);
        if (!shouldSit && entity.method_5805()) {
            limbSwingAmount = ((class_1309)entity).field_42108.method_48570(partialTick);
            limbSwing = ((class_1309)entity).field_42108.method_48572(partialTick);
            if (entity.method_6109()) {
                limbSwing *= 3.0f;
            }
        }
        float headPitch = class_3532.method_16439((float)partialTick, (float)((class_1309)entity).field_6004, (float)entity.method_36455());
        entityModelData.headPitch = -headPitch;
        entityModelData.netHeadYaw = -class_3532.method_15363((float)class_3532.method_15393((float)netHeadYaw), (float)-85.0f, (float)85.0f);
        AnimationEvent<E> predicate = new AnimationEvent<E>(animatable, limbSwing, limbSwingAmount, partialTick, limbSwingAmount <= -this.getSwingMotionAnimThreshold() || limbSwingAmount <= this.getSwingMotionAnimThreshold(), Collections.singletonList(entityModelData));
        AnimationContext<T> ctx = new AnimationContext<T>(entity, this.currentAnimatable, predicate, entityModelData);
        ((AnimatableEntity)animatable).setCustomAnimations(ctx, predicate);
        AnimatedGeoModel model = ((AnimatableEntity)animatable).getCurrentModel();
        if (model != null) {
            poseStack.method_46416(0.0f, 0.01f, 0.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.getTextureLocation(entity));
            Color renderColor = this.getRenderColor(entity, partialTick, poseStack, bufferSource, null, packedLight);
            class_1921 renderType = this.getRenderType(entity, partialTick, poseStack, bufferSource, null, packedLight, this.getTextureLocation(entity));
            if (class_310.method_1551().field_1724 != null && !entity.method_5756((class_1657)class_310.method_1551().field_1724)) {
                class_4588 translucentBuffer = bufferSource.getBuffer(class_1921.method_23578((class_2960)this.getTextureLocation(entity)));
                this.render(model, entity, partialTick, renderType, poseStack, bufferSource, translucentBuffer, packedLight, GeoReplacedEntityRenderer.getPackedOverlay(entity, this.getOverlayProgress((class_1309)entity, partialTick)), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
            }
        }
        if (!entity.method_7325()) {
            for (GeoLayerRenderer layerRenderer : this.layerRenderers) {
                layerRenderer.render(poseStack, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTick, lerpedAge, netHeadYaw, headPitch);
            }
        }
        poseStack.method_22909();
        ((LivingEntityRendererAccessor)((Object)this)).tlm$renderNameTag((class_1309)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    protected float getOverlayProgress(class_1309 entity, float partialTicks) {
        return 0.0f;
    }

    protected void preRenderCallback(class_1309 entity, class_4587 poseStack, float partialTick) {
    }

    @Override
    @NotNull
    public class_2960 getTextureLocation(T entity) {
        return ((AnimatableEntity)this.getAnimatableEntity(entity)).getTextureLocation();
    }

    protected void method_4058(T pEntityLiving, class_4587 pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks, float pScale) {
        super.method_4058(pEntityLiving, pPoseStack, pAgeInTicks, pRotationYaw, pPartialTicks, pScale);
        if (((class_1309)pEntityLiving).field_6213 <= 0 && pEntityLiving.method_6123()) {
            pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(((float)((class_1309)pEntityLiving).field_6012 + pPartialTicks) * 75.0f));
            pPoseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f + pEntityLiving.method_36455()));
        }
    }

    protected boolean isVisible(class_1309 entity) {
        return !entity.method_5767();
    }

    protected float getDeathMaxRotation(class_1309 entity) {
        return 90.0f;
    }

    public boolean method_4055(T entity) {
        double nameRenderDistance;
        double d = nameRenderDistance = entity.method_21751() ? 32.0 : 64.0;
        if (this.field_4676.method_23168(entity) >= nameRenderDistance * nameRenderDistance) {
            return false;
        }
        return entity.method_5733() || entity == this.field_4676.field_4678 && entity.method_16914() && class_310.method_1498();
    }

    protected float getSwingProgress(class_1309 entity, float partialTick) {
        return entity.method_6055(partialTick);
    }

    protected float getSwingMotionAnimThreshold() {
        return 0.15f;
    }

    public final boolean addLayer(GeoLayerRenderer<T, ?> layer) {
        return this.layerRenderers.add(layer);
    }

    public abstract E getAnimatableEntity(T var1);

    public <E extends class_1297> void renderLeash(T entity, float partialTick, class_4587 poseStack, class_4597 bufferSource, E leashHolder) {
        int segment;
        double lerpBodyAngle = class_3532.method_16439((float)partialTick, (float)((class_1309)entity).field_6283, (float)((class_1309)entity).field_6220) * ((float)Math.PI / 180) + 1.5707964f;
        class_243 leashOffset = entity.method_45321(1.0f);
        double xAngleOffset = Math.cos(lerpBodyAngle) * leashOffset.field_1350 + Math.sin(lerpBodyAngle) * leashOffset.field_1352;
        double zAngleOffset = Math.sin(lerpBodyAngle) * leashOffset.field_1350 - Math.cos(lerpBodyAngle) * leashOffset.field_1352;
        double lerpOriginX = class_3532.method_16436((double)partialTick, (double)((class_1309)entity).field_6014, (double)entity.method_23317()) + xAngleOffset;
        double lerpOriginY = class_3532.method_16436((double)partialTick, (double)((class_1309)entity).field_6036, (double)entity.method_23318()) + leashOffset.field_1351;
        double lerpOriginZ = class_3532.method_16436((double)partialTick, (double)((class_1309)entity).field_5969, (double)entity.method_23321()) + zAngleOffset;
        class_243 ropeGripPosition = leashHolder.method_30951(partialTick);
        float xDif = (float)(ropeGripPosition.field_1352 - lerpOriginX);
        float yDif = (float)(ropeGripPosition.field_1351 - lerpOriginY);
        float zDif = (float)(ropeGripPosition.field_1350 - lerpOriginZ);
        float offsetMod = (float)class_3532.method_15345((double)(xDif * xDif + zDif * zDif)) * 0.025f / 2.0f;
        float xOffset = zDif * offsetMod;
        float zOffset = xDif * offsetMod;
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23587());
        class_2338 entityEyePos = class_2338.method_49638((class_2374)entity.method_5836(partialTick));
        class_2338 holderEyePos = class_2338.method_49638((class_2374)leashHolder.method_5836(partialTick));
        int entityBlockLight = this.method_24087((class_1297)entity, entityEyePos);
        int holderBlockLight = leashHolder.method_5809() ? 15 : leashHolder.method_37908().method_8314(class_1944.field_9282, holderEyePos);
        int entitySkyLight = entity.method_37908().method_8314(class_1944.field_9284, entityEyePos);
        int holderSkyLight = entity.method_37908().method_8314(class_1944.field_9284, holderEyePos);
        poseStack.method_22903();
        poseStack.method_22904(xAngleOffset, leashOffset.field_1351, zAngleOffset);
        Matrix4f posMatrix = poseStack.method_23760().method_23761();
        for (segment = 0; segment <= 24; ++segment) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.025f, xOffset, zOffset, segment, false);
        }
        for (segment = 24; segment >= 0; --segment) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.0f, xOffset, zOffset, segment, true);
        }
        poseStack.method_22909();
    }

    @Override
    public class_4597 getCurrentRTB() {
        return this.rtb;
    }

    @Override
    public void setCurrentRTB(class_4597 bufferSource) {
        this.rtb = bufferSource;
    }

    public List<GeoLayerRenderer> getLayerRenderers() {
        return this.layerRenderers;
    }
}

