package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ErrorCode;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ServiceType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.TTSAudioToClientMessage;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import java.net.http.HttpRequest;

public class TTSCallback implements ResponseCallback<byte[]> {
    private final EntityMaid maid;
    private final String chatText;
    private final long waitingChatBubbleId;

    public TTSCallback(EntityMaid maid, String chatText, long waitingChatBubbleId) {
        this.maid = maid;
        this.chatText = chatText;
        this.waitingChatBubbleId = waitingChatBubbleId;
    }

    @Override
    public void onFailure(HttpRequest request, Throwable throwable, int errorCode) {
        if (maid.field_6002 instanceof class_3218 serverLevel) {
            MinecraftServer server = serverLevel.method_8503();
            server.method_20493(() -> {
                if (maid.method_35057() instanceof class_3222 player) {
                    String cause = throwable.getLocalizedMessage();
                    class_5250 errorMessage = ErrorCode.getErrorMessage(ServiceType.TTS, errorCode, cause);
                    player.method_43496(errorMessage.method_27692(class_124.field_1061));
                }
                maid.getChatBubbleManager().addLLMChatText(chatText, waitingChatBubbleId);
            });
        }
        TouhouLittleMaid.LOGGER.error("LLM request failed: {}, error is {}", request, throwable.getMessage());
    }

    @Override
    public void onSuccess(byte[] data) {
        if (!(maid.field_6002 instanceof class_3218 serverLevel)) {
            return;
        }
        class_1309 owner = maid.method_35057();
        if (!(owner instanceof class_3222 player)) {
            return;
        }
        MinecraftServer server = serverLevel.method_8503();
        server.method_20493(() -> {
            ServerPlayNetworking.send(player, TTSAudioToClientMessage.ID, TTSAudioToClientMessage.encode(maid.method_5628(), data));
            maid.getChatBubbleManager().addLLMChatText(chatText, waitingChatBubbleId);
        });
    }
}