package com.github.tartaricacid.touhoulittlemaid.client.gui.block;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ScreenAccessor;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.BeaconEffectButton;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetBeaconOverflowMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.StorageAndTakePowerMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon.BeaconEffect;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import java.text.DecimalFormat;

public class MaidBeaconGui extends class_437 {
    private static final class_2960 BG = new class_2960(TouhouLittleMaid.MOD_ID, "textures/gui/maid_beacon.png");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private final TileEntityMaidBeacon beacon;

    protected int imageWidth = 300;
    protected int imageHeight = 113;
    protected int leftPos;
    protected int topPos;
    private boolean overflowDelete;
    private int potionIndex;

    public MaidBeaconGui(TileEntityMaidBeacon beacon) {
        super(class_2561.method_43470("Maid Beacon GUI"));
        this.beacon = beacon;
        this.overflowDelete = beacon.isOverflowDelete();
        this.potionIndex = beacon.getPotionIndex();
    }

    @Override
    protected void method_25426() {
        this.method_37067();
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;

        this.addEffectButton(this.leftPos + 146, 26, this.topPos + 19);
        this.addStorageAndTakeButton();
        this.method_37063(class_4185.method_46430(getOverflowDeleteButtonText(this.overflowDelete), b -> {
            this.overflowDelete = !this.overflowDelete;
            ClientPlayNetworking.send(SetBeaconOverflowMessage.ID, SetBeaconOverflowMessage.encode(beacon.method_11016(), this.overflowDelete));
            this.method_25426();
        }).method_46433(leftPos + 118, topPos + 94).method_46437(154, 20).method_46431());
    }

    private void addStorageAndTakeButton() {
        this.method_37063(class_4185.method_46430(class_2561.method_43471("gui.touhou_little_maid.maid_beacon.add_one")
                , b -> ClientPlayNetworking.send(StorageAndTakePowerMessage.ID, StorageAndTakePowerMessage.encode(beacon.method_11016(), 1, true))).method_46433(leftPos + 118, topPos + 72).method_46437(76, 20).method_46431());

        this.method_37063(class_4185.method_46430(class_2561.method_43471("gui.touhou_little_maid.maid_beacon.min_one")
                , b -> ClientPlayNetworking.send(StorageAndTakePowerMessage.ID, StorageAndTakePowerMessage.encode(beacon.method_11016(), 1, false))).method_46433(leftPos + 196, topPos + 72).method_46437(76, 20).method_46431());
    }

    private void addEffectButton(int start, int spacing, int y) {
        this.method_37063(new BeaconEffectButton(BeaconEffect.SPEED, start, y, potionIndex, beacon, (isStateTriggered) -> {
            this.potionIndex = isStateTriggered ? BeaconEffect.SPEED.ordinal() : -1;
            this.method_25426();
        }));
        this.method_37063(new BeaconEffectButton(BeaconEffect.FIRE_RESISTANCE, start + spacing, y, potionIndex, beacon, (isStateTriggered) -> {
            this.potionIndex = isStateTriggered ? BeaconEffect.FIRE_RESISTANCE.ordinal() : -1;
            this.method_25426();
        }));
        this.method_37063(new BeaconEffectButton(BeaconEffect.STRENGTH, start + spacing * 2, y, potionIndex, beacon, (isStateTriggered) -> {
            this.potionIndex = isStateTriggered ? BeaconEffect.STRENGTH.ordinal() : -1;
            this.method_25426();
        }));
        this.method_37063(new BeaconEffectButton(BeaconEffect.RESISTANCE, start + spacing * 3, y, potionIndex, beacon, (isStateTriggered) -> {
            this.potionIndex = isStateTriggered ? BeaconEffect.RESISTANCE.ordinal() : -1;
            this.method_25426();
        }));
        this.method_37063(new BeaconEffectButton(BeaconEffect.REGENERATION, start + spacing * 4, y, potionIndex, beacon, (isStateTriggered) -> {
            this.potionIndex = isStateTriggered ? BeaconEffect.REGENERATION.ordinal() : -1;
            this.method_25426();
        }));
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25302(BG, leftPos, topPos + 2, 0, 0, 142, 111);
        graphics.method_25302(BG, leftPos + 118, topPos + 1, 44, 111, 154, 15);

        graphics.method_25302(BG, leftPos + 224, topPos + 44, 44, 126, 12, 12);
        graphics.method_25302(BG, leftPos + 224, topPos + 58, 44, 138, 12, 12);

        graphics.method_25302(BG, leftPos + 146, topPos + 46, 58, 128, 74, 9);
        graphics.method_25302(BG, leftPos + 146, topPos + 59, 58, 128, 74, 9);
        float percent = beacon.getStoragePower() / beacon.getMaxStorage();
        graphics.method_25302(BG, leftPos + 146, topPos + 48, 58, 138, (int) (74 * percent), 5);

        this.renderPlayerPower(graphics);
        graphics.method_25303(field_22793, DECIMAL_FORMAT.format(beacon.getStoragePower()), leftPos + 240, topPos + 46, 0xffffff);
        if (potionIndex == -1) {
            this.drawCenteredString(graphics, field_22793, class_1074.method_4662("gui.touhou_little_maid.maid_beacon.cost_power", DECIMAL_FORMAT.format(0)), leftPos + 195, topPos + 5, class_124.field_1063.method_532());
        } else {
            this.drawCenteredString(graphics, field_22793, class_2561.method_43469("gui.touhou_little_maid.maid_beacon.cost_power", DECIMAL_FORMAT.format(beacon.getEffectCost() * 900)).method_27692(class_124.field_1061), leftPos + 195, topPos + 5, 0xffffff);
        }
        ((ScreenAccessor) this).tlm$getRenderables().stream().filter(b -> b instanceof BeaconEffectButton).forEach(b -> ((BeaconEffectButton) b).renderToolTip(graphics, this, mouseX, mouseY));
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        //InputConstants.Key mouseKey = InputConstants.getKey(keyCode, scanCode);
        if (this.field_22787 != null && this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)/*isActiveAndMatches(mouseKey)*/) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void renderPlayerPower(class_332 graphics) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            PowerAttachment power = player.getAttachedOrCreate(InitDataAttachment.POWER_NUM, () -> new PowerAttachment(0));
            float percent = power.get() / PowerAttachment.MAX_POWER;
            graphics.method_25302(BG, leftPos + 146, topPos + 61, 58, 143, (int) (74 * percent), 5);
            graphics.method_25303(field_22793, DECIMAL_FORMAT.format(power.get()), leftPos + 240, topPos + 60, 0xffffff);
        }
    }

    private class_5250 getOverflowDeleteButtonText(boolean overflowDelete) {
        return overflowDelete ? class_2561.method_43471("gui.touhou_little_maid.maid_beacon.overflow_delete_true") :
                class_2561.method_43471("gui.touhou_little_maid.maid_beacon.overflow_delete_false");
    }

    private void drawCenteredString(class_332 graphics, class_327 font, String text, int pX, int pY, int color) {
        graphics.method_51433(font, text, pX - font.method_1727(text) / 2, pY, color, false);
    }

    private void drawCenteredString(class_332 graphics, class_327 font, class_2561 text, int pX, int pY, int color) {
        graphics.method_51439(font, text, pX - font.method_27525(text) / 2, pY, color, false);
    }
}
