package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache;

import com.github.tartaricacid.touhoulittlemaid.client.gui.block.ModelSwitcherGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.block.ModelSwitcherModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.AbstractModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.ChairModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.MaidModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_490;
import java.util.LinkedList;

import static com.github.tartaricacid.touhoulittlemaid.client.event.SpecialMaidRenderEvent.EASTER_EGG_MODEL;
import static com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil.clearMaidDataResidue;

@Environment(EnvType.CLIENT)
public final class CacheIconManager {
    private static final LinkedList<MaidModelInfo> MAID_CACHE_QUEUE = new LinkedList<>();
    private static final LinkedList<ChairModelInfo> CHAIR_CACHE_QUEUE = new LinkedList<>();

    public static void clearCache() {
        MAID_CACHE_QUEUE.clear();
        CHAIR_CACHE_QUEUE.clear();
    }

    public static void addMaidPack(CustomModelPack<MaidModelInfo> customModelPack) {
        MAID_CACHE_QUEUE.addAll(customModelPack.getModelList());
    }

    public static void addChairPack(CustomModelPack<ChairModelInfo> customModelPack) {
        CHAIR_CACHE_QUEUE.addAll(customModelPack.getModelList());
    }

    public static void openMaidModelGui(EntityMaid maid) {
        MaidModelGui maidModelGui = new MaidModelGui(maid);
        if (MiscConfig.MODEL_ICON_CACHE.get() && !MAID_CACHE_QUEUE.isEmpty()) {
            var maidCacheScreen = getMaidCacheScreen(maidModelGui);
            class_310.method_1551().method_1507(maidCacheScreen);
        } else {
            class_310.method_1551().method_1507(maidModelGui);
        }
    }

    public static void openChairModelGui(EntityChair chair) {
        ChairModelGui chairModelGui = new ChairModelGui(chair);
        if (MiscConfig.MODEL_ICON_CACHE.get() && !CHAIR_CACHE_QUEUE.isEmpty()) {
            var chairCacheScreen = getChairCacheScreen(chairModelGui);
            class_310.method_1551().method_1507(chairCacheScreen);
        } else {
            class_310.method_1551().method_1507(chairModelGui);
        }
    }

    public static void openModelSwitcherModelGui(EntityMaid maid, TileEntityModelSwitcher.ModeInfo info, ModelSwitcherGui modelSwitcherGui) {
        ModelSwitcherModelGui switcherModelGui = new ModelSwitcherModelGui(maid, info, modelSwitcherGui);
        if (MiscConfig.MODEL_ICON_CACHE.get() && !MAID_CACHE_QUEUE.isEmpty()) {
            var maidCacheScreen = getMaidCacheScreen(switcherModelGui);
            class_310.method_1551().method_1507(maidCacheScreen);
        } else {
            class_310.method_1551().method_1507(switcherModelGui);
        }
    }

    private static CacheScreen<EntityMaid, MaidModelInfo> getMaidCacheScreen(AbstractModelGui<EntityMaid, MaidModelInfo> maidModelGui) {
        return new CacheScreen<>(maidModelGui, InitEntities.MAID, MAID_CACHE_QUEUE, (graphics, posX, posY, modelInfo, scaleModified, maid) -> {
            clearMaidDataResidue(maid, false);
            if (modelInfo.getEasterEgg() != null) {
                maid.setModelId(EASTER_EGG_MODEL);
            } else {
                maid.setModelId(modelInfo.getModelId().toString());
            }
            // 女仆换皮肤界面需要指定 YSM 渲染为空
            maid.setIsYsmModel(false);
            int scale = scaleModified / 2;
            class_490.method_2486(graphics,
                    posX + scale,
                    posY + scaleModified,
                    (int) (scale * modelInfo.getRenderItemScale()),
                    -25, -20, maid);
        });
    }

    private static CacheScreen<EntityChair, ChairModelInfo> getChairCacheScreen(ChairModelGui chairModelGui) {
        return new CacheScreen<>(chairModelGui, InitEntities.CHAIR, CHAIR_CACHE_QUEUE, (graphics, posX, posY, modelInfo, scaleModified, chair) -> {
            chair.setModelId(modelInfo.getModelId().toString());
            int scale = scaleModified / 2;
            class_490.method_2486(graphics,
                    posX + scale,
                    posY + scaleModified - 5,
                    (int) (scale * modelInfo.getRenderItemScale() * 0.9),
                    -25, -20, chair);
        });
    }
}
