package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.response.ResponseChat;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMMessage;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.Role;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.HistoryChatWidget;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.TabIndex;
import com.github.tartaricacid.touhoulittlemaid.network.message.ClearMaidAIDataMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenMaidGuiMessage;
import com.google.common.collect.Lists;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1068;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

import java.util.Deque;
import java.util.List;

public class HistoryAIChatScreen extends class_437 {
    private final EntityMaid maid;
    private final class_2960 playerSkin;
    private final List<LLMMessage> history = Lists.newArrayList();
    private final List<class_4068> historyWidgets = Lists.newArrayList();

    private double scroll = 0;
    private int maxHeight = 0;
    private int posX = 0;

    public HistoryAIChatScreen(EntityMaid maid) {
        super(class_2561.method_43470("Maid History AI Chat Screen"));
        this.maid = maid;
        this.playerSkin = this.getPlayerSkin();
        this.transformMessage();
    }

    @Override
    protected void method_25426() {
        this.method_37067();
        historyWidgets.clear();
        this.posX = this.field_22789 / 2 - 75;
        this.maxHeight = 10;
        for (LLMMessage message : this.history) {
            int lineHeight = this.addHistoryWidget(message, posX);
            maxHeight += lineHeight + 5;
        }
        this.addButtons();

        // 让滚动一开始就在中间
        if (this.maxHeight < this.field_22790) {
            this.scroll = (this.field_22790 - this.maxHeight) / 2d;
        } else {
            double topMax = this.field_22790 / 2.0 - 100;
            double bottomMax = this.field_22790 / 2.0 + 100;
            double scrollBottom = scroll + maxHeight;
            if (scroll > topMax) {
                scroll = topMax;
            }
            if (bottomMax > scrollBottom) {
                scroll = bottomMax - maxHeight;
            }
        }
    }

    private void addButtons() {
        class_5250 clearName = class_2561.method_43471("gui.touhou_little_maid.button.maid_ai_chat_config.clear_history_chat");
        class_5250 clearMsg = class_2561.method_43471("gui.touhou_little_maid.button.maid_ai_chat_config.clear_history_chat.confirm");
        this.method_37063(class_4185.method_46430(clearName, button -> Screens.getClient(this).method_1507(new class_410(yes -> {
            if (yes) {
                this.history.clear();
                this.historyWidgets.clear();
                this.maid.getAiChatManager().getHistory().getDeque().clear();
                class_2540 buf = ClearMaidAIDataMessage.encode(this.maid.method_5628());
                ClientPlayNetworking.send(ClearMaidAIDataMessage.ID, buf);
            }
            Screens.getClient(this).method_1507(this);
        }, clearName, clearMsg))).method_46434(posX + 150, this.field_22790 / 2 - 20, 120, 20).method_46431());
        this.method_37063(class_4185.method_46430(class_5244.field_24339, button -> {
            ClientPlayNetworking.send(OpenMaidGuiMessage.ID, OpenMaidGuiMessage.encode(this.maid.method_5628(), TabIndex.MAID_AI_CHAT_CONFIG));
        }).method_46434(posX + 150, this.field_22790 / 2 + 5, 120, 20).method_46431());
    }

    private int addHistoryWidget(LLMMessage message, int posX) {
        boolean isLeft = message.role() != Role.USER;
        class_2561 msg = class_2561.method_43470(message.message());
        int width = Math.min(field_22793.method_27525(msg), 140) + 10;
        int lineHeight = 10 + field_22793.method_1728(msg, 140).size() * field_22793.field_2000;
        if (isLeft) {
            historyWidgets.add(new HistoryChatWidget(posX - 100, maxHeight,
                    width, lineHeight, msg, playerSkin, message.gameTime(), true));
        } else {
            historyWidgets.add(new HistoryChatWidget(posX + 100 - width, maxHeight,
                    width, lineHeight, msg, playerSkin, message.gameTime(), false));
        }
        return lineHeight;
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);

        class_5250 title = class_2561.method_43471("gui.touhou_little_maid.button.maid_ai_chat_config.history_chat.title");
        graphics.method_27534(field_22793, title, posX + 210, this.field_22790 / 2 - 35, 0xFFFFFF);

        if (this.historyWidgets.isEmpty()) {
            class_5250 empty = class_2561.method_43471("gui.touhou_little_maid.button.maid_ai_chat_config.history_chat_is_empty");
            List<class_5481> split = field_22793.method_1728(empty, 150);
            for (int i = 0; i < split.size(); i++) {
                int height = i * field_22793.field_2000;
                graphics.method_35719(field_22793, split.get(i), posX, this.field_22790 / 2 - 10 + height, 0xff5555);
            }
        } else {
            graphics.method_44379(posX - 128, 5, posX + 128, this.field_22790 - 5);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22904(0, scroll, 0);
            for (class_4068 renderable : this.historyWidgets) {
                renderable.method_25394(graphics, mouseX, mouseY, partialTicks);
            }
            graphics.method_51448().method_22909();
            graphics.method_44380();
        }
    }

    @Override
    public boolean method_25401(double pMouseX, double pMouseY, double delta) {
        if (delta != 0) {
            double topMax = this.field_22790 / 2.0 - 100;
            double bottomMax = this.field_22790 / 2.0 + 100;
            double scrollBottom = scroll + maxHeight;
            if (delta < 0 && bottomMax < scrollBottom) {
                scroll += delta * 15;
            }
            if (0 < delta && scroll < topMax) {
                scroll += delta * 15;
            }
        }
        return super.method_25401(pMouseX, pMouseY, delta);
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    private void transformMessage() {
        Deque<LLMMessage> deque = this.maid.getAiChatManager().getHistory().getDeque();
        deque.descendingIterator().forEachRemaining(message -> {
            if (message.role() == Role.USER) {
                this.history.add(message);
            } else if (message.role() == Role.ASSISTANT && StringUtils.isNotBlank(message.message())) {
                ResponseChat responseChat = new ResponseChat(message.message());
                this.history.add(new LLMMessage(Role.ASSISTANT, responseChat.getChatText(), message.gameTime(), null, null));
            }
        });
    }

    private class_2960 getPlayerSkin() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return class_1068.method_4648(class_156.field_25140);
        }
        return mc.method_1582().method_44705(player.method_7334());
    }
}