package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.compat.oculus.OculusCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.MaidFishingHook;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Environment(EnvType.CLIENT)
public class MaidFishingHookRenderer<T extends MaidFishingHook> extends class_897<T> {
    private static final class_2960 TEXTURE_LOCATION = new class_2960("textures/entity/fishing_hook.png");
    private static final class_1921 RENDER_TYPE = class_1921.method_23576(TEXTURE_LOCATION);

    public MaidFishingHookRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public void render(T fishingHook, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        EntityMaid maid = fishingHook.getMaidOwner();
        if (maid == null) {
            return;
        }
        poseStack.method_22903();
        this.renderBobber(fishingHook, poseStack, buffer, packedLight);
        this.renderFishingLine(fishingHook, partialTicks, poseStack, buffer, maid);
        poseStack.method_22909();
        super.method_3936(fishingHook, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void renderBobber(T fishingHook, class_4587 poseStack, class_4597 buffer, int packedLight) {
        poseStack.method_22903();
        poseStack.method_22905(0.5F, 0.5F, 0.5F);
        poseStack.method_22907(this.field_4676.method_24197());
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0F));

        class_4587.class_4665 lasted = poseStack.method_23760();
        Matrix4f lastedPose = lasted.method_23761();
        Matrix3f lastedNormal = lasted.method_23762();

        class_4588 consumer = buffer.getBuffer(RENDER_TYPE);
        vertex(consumer, lastedPose, lastedNormal, packedLight, 0.0F, 0, 0, 1);
        vertex(consumer, lastedPose, lastedNormal, packedLight, 1.0F, 0, 1, 1);
        vertex(consumer, lastedPose, lastedNormal, packedLight, 1.0F, 1, 1, 0);
        vertex(consumer, lastedPose, lastedNormal, packedLight, 0.0F, 1, 0, 0);

        poseStack.method_22909();
    }

    protected float[] getLineColor(T fishingHook) {
        return new float[]{0f, 0f, 0f};
    }

    protected void renderFishingLine(T fishingHook, float partialTicks, class_4587 poseStack, class_4597 buffer, EntityMaid maid) {
        float lerpBodyRot;
        if (maid.method_5854() instanceof class_1309 vehicle) {
            lerpBodyRot = class_3532.method_16439(partialTicks, vehicle.field_6220, vehicle.field_6283) * ((float) Math.PI / 180F);
        } else {
            lerpBodyRot = class_3532.method_16439(partialTicks, maid.field_6220, maid.field_6283) * ((float) Math.PI / 180F);
        }
        double sin = class_3532.method_15374(lerpBodyRot);
        double cos = class_3532.method_15362(lerpBodyRot);

        double x1 = class_3532.method_16436(partialTicks, maid.field_6014, maid.method_23317()) - cos * 0.35D - sin * 0.8D;
        double y1 = maid.field_6036 + maid.method_5751() + (maid.method_23318() - maid.field_6036) * partialTicks - 0.45D;
        double z1 = class_3532.method_16436(partialTicks, maid.field_5969, maid.method_23321()) - sin * 0.35D + cos * 0.8D;

        double x2 = class_3532.method_16436(partialTicks, fishingHook.field_6014, fishingHook.method_23317());
        double y2 = class_3532.method_16436(partialTicks, fishingHook.field_6036, fishingHook.method_23318()) + 0.25D;
        double z2 = class_3532.method_16436(partialTicks, fishingHook.field_5969, fishingHook.method_23321());

        float x = (float) (x1 - x2);
        float y = (float) (y1 - y2) - 0.1875F;
        float z = (float) (z1 - z2);

        float[] colors = getLineColor(fishingHook);

        class_4588 lineConsumer = buffer.getBuffer(class_1921.method_34572());
        class_4587.class_4665 lasted = poseStack.method_23760();
        for (int i = 0; i <= 16; ++i) {
            stringVertex(x, y, z, lineConsumer, lasted, fraction(i), fraction(i + 1), colors[0], colors[1], colors[2]);
        }
        if (OculusCompat.isOculusInstalled()) {
            lineConsumer.method_22912(0.0, 0.0, 0.0).method_1336(0, 0, 0, 255).method_22914(0.0F, 0.0F, 0.0F).method_1344();
        }
    }

    protected float fraction(int numerator) {
        return (float) numerator / (float) 16;
    }

    protected void vertex(class_4588 consumer, Matrix4f pose, Matrix3f normal, int lightMapUV, float pX, int pY, int pU, int pV) {
        consumer.method_22918(pose, pX - 0.5F, pY - 0.5F, 0.0F)
                .method_1336(255, 255, 255, 255)
                .method_22913((float) pU, (float) pV)
                .method_22922(class_4608.field_21444)
                .method_22916(lightMapUV)
                .method_23763(normal, 0.0F, 1.0F, 0.0F)
                .method_1344();
    }

    protected static void renderPosTexture(class_4588 builder, Matrix4f matrix4f, Matrix3f matrix3f, int lightMapUV, float x, int y, int u, int v) {
        builder.method_22918(matrix4f, x - 0.5F, (float) y - 0.5F, 0.0F)
                .method_1336(255, 255, 255, 255)
                .method_22913((float) u, (float) v)
                .method_22922(class_4608.field_21444).method_22916(lightMapUV)
                .method_23763(matrix3f, 0.0F, 1.0F, 0.0F)
                .method_1344();
    }

    protected static void vertex(class_4588 builder, Matrix4f matrix4f, Matrix3f matrix3f, int lightMapUV, float x, int y, int u, int v, float r, float g, float b) {
        builder.method_22918(matrix4f, x - 0.5F, (float) y - 0.5F, 0.0F)
                .method_22915(r, g, b, 1.0F)
                .method_22913((float) u, (float) v)
                .method_22922(class_4608.field_21444)
                .method_22916(lightMapUV).method_23763(matrix3f, 0.0F, 1.0F, 0.0F)
                .method_1344();
    }

    protected void stringVertex(float pX, float pY, float pZ, class_4588 consumer, class_4587.class_4665 pose, float fraction1, float fraction2, float r, float g, float b) {
        float x = pX * fraction1;
        float y = pY * (fraction1 * fraction1 + fraction1) * 0.5F + 0.25F;
        float z = pZ * fraction1;

        float nx = pX * fraction2 - x;
        float ny = pY * (fraction2 * fraction2 + fraction2) * 0.5F + 0.25F - y;
        float nz = pZ * fraction2 - z;
        float sqrt = class_3532.method_15355(nx * nx + ny * ny + nz * nz);

        nx /= sqrt;
        ny /= sqrt;
        nz /= sqrt;

        consumer.method_22918(pose.method_23761(), x, y, z)
                .method_22915(r, g, b, 1.0F)
                .method_23763(pose.method_23762(), nx, ny, nz)
                .method_1344();
    }

    @Override
    public class_2960 getTextureLocation(T pEntity) {
        return TEXTURE_LOCATION;
    }
}
