package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.client.render.MaidRenderState;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityStatue;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_898;

import static com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader.STATUE_BASE;
import static com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil.clearMaidDataResidue;

public class TileEntityStatueRenderer implements class_827<TileEntityStatue> {
    private static final class_2960 TEXTURE = new class_2960(TouhouLittleMaid.MOD_ID, "textures/bedrock/block/statue_base.png");
    private final SimpleBedrockModel<class_1297> BASE_MODEL;

    public TileEntityStatueRenderer(class_5614.class_5615 context) {
        BASE_MODEL = BedrockModelLoader.getModel(STATUE_BASE);
    }

    @Override
    public void render(TileEntityStatue te, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!te.isCoreBlock()) {
            return;
        }

        poseStack.method_22903();
        this.setTranslateAndPose(te, poseStack);
        poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
        class_4588 buffer = bufferIn.getBuffer(class_1921.method_23578(TEXTURE));
        BASE_MODEL.method_2828(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0F, 1.0F, 1.0F, 1.0F);
        poseStack.method_22909();

        class_2487 data = te.getExtraMaidData();
        class_1937 world = class_310.method_1551().field_1687;
        if (data == null || world == null) {
            return;
        }
        class_1299.method_5898(data.method_10558("id")).ifPresent(type -> {
                    try {
                        renderEntity(te, poseStack, bufferIn, combinedLightIn, data, world, type);
                    } catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
        );
    }

    private void renderEntity(TileEntityStatue te, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, class_2487 data, class_1937 world, class_1299<?> type) throws ExecutionException {
        class_1297 entity;
        if (type.equals(InitEntities.MAID)) {
            long posId = te.method_11016().method_10063();
            entity = EntityCacheUtil.STATUE_CACHE.get(posId, () -> new EntityMaid(world));
        } else {
            entity = EntityCacheUtil.ENTITY_CACHE.get(type, () -> {
                class_1297 e = type.method_5883(world);
                return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
            });
        }

        entity.method_5651(data);
        if (entity instanceof EntityMaid maid) {
            clearMaidDataResidue(maid, true);
            maid.renderState = MaidRenderState.STATUE;
        }

        float size = te.getSize().getScale();
        float offset = 0;
        if (te.getSize() == TileEntityStatue.Size.MIDDLE) {
            offset = 1.0f / 4.0f;
        } else if (te.getSize() == TileEntityStatue.Size.BIG) {
            offset = 1.0f / 3.0f;
        }

        poseStack.method_22903();
        poseStack.method_22905(size, size, size);
        poseStack.method_22904(0.5 / size, 0.21328125, 0.5 / size);
        switch (te.getFacing()) {
            case field_11034:
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(90));
                break;
            case field_11039:
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(270));
                break;
            case field_11035:
                break;
            case field_11043:
            default:
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180));
                break;
        }
        class_898 render = class_310.method_1551().method_1561();
        boolean isShowHitBox = render.method_3958();
        render.method_3955(false);
        render.method_3954(entity, offset, 0, -offset, 0, 0,
                poseStack, bufferIn, combinedLightIn);
        render.method_3955(isShowHitBox);
        poseStack.method_22909();
    }

    private void setTranslateAndPose(TileEntityStatue te, class_4587 poseStack) {
        float size = te.getSize().getScale();
        float offset = 0;
        if (te.getSize() == TileEntityStatue.Size.MIDDLE) {
            offset = 1.0f / 4.0f;
        } else if (te.getSize() == TileEntityStatue.Size.BIG) {
            offset = 1.0f / 3.0f;
        }

        switch (te.getFacing()) {
            case field_11034:
                poseStack.method_46416(-offset * size, 0, -offset * size);
                break;
            case field_11043:
                poseStack.method_46416(-offset * size, 0, offset * size);
                break;
            case field_11039:
                poseStack.method_46416(offset * size, 0, offset * size);
                break;
            case field_11035:
                poseStack.method_46416(offset * size, 0, -offset * size);
                break;
            default:
                poseStack.method_46416(0, 0, 0);
        }
        poseStack.method_22905(size, size, size);
        poseStack.method_22904(0.5 / size, 1.5, 0.5 / size);
    }
}