package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandler;
import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

import static com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask.VERTICAL_SEARCH_RANGE;

public class MaidFarmMoveTask extends MaidMoveToBlockTask {
    private static final int MAX_ITEMS = 8;
    private final class_2371<class_1799> seeds = class_2371.method_10211();
    private final IFarmTask task;
    private long chatBubbleKey = -1;

    public MaidFarmMoveTask(IFarmTask task, float movementSpeed) {
        super(movementSpeed, 2);
        this.task = task;
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        // 如果周围掉落物过多，女仆将不执行收菜任务
        // 这是因为很多玩家在挂机时，女仆会无休止的收菜，导致掉落物过多
        // 而女仆又会疯狂检索周围掉落物，加剧了服务器的卡顿
        if (super.checkExtraStartConditions(worldIn, owner)) {
            // 如果掉落物超过 MAX_ITEMS 个，女仆将不执行收菜任务
            if (this.getItemEntityCount(worldIn, owner) < MAX_ITEMS) {
                return true;
            } else {
                this.chatBubbleKey = owner.getChatBubbleManager()
                        .addTextChatBubbleIfTimeout("chat_bubble.touhou_little_maid.inner.farm.too_many_item_entities", chatBubbleKey);
                return false;
            }
        }
        return false;
    }

    private int getItemEntityCount(class_3218 worldIn, EntityMaid maid) {
        float radius = maid.method_18413();
        class_238 aabb;
        if (maid.method_18410()) {
            aabb = new class_238(maid.method_18412()).method_1009(radius, VERTICAL_SEARCH_RANGE, radius);
        } else {
            aabb = maid.method_5829().method_1009(radius, VERTICAL_SEARCH_RANGE, radius);
        }
        return worldIn.method_8390(class_1297.class, aabb, class_1297::method_5805).size();
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        seeds.clear();
        IItemHandler inv = entityIn.getAvailableInv(true);
        for (int i = 0; i < inv.getSlots(); i++) {
            class_1799 stack = inv.getStackInSlot(i);
            if (task.isSeed(stack)) {
                seeds.add(stack);
            }
        }
        this.searchForDestination(worldIn, entityIn);
    }

    @Override
    protected boolean shouldMoveTo(class_3218 worldIn, EntityMaid maid, class_2338 basePos) {
        if (task.checkCropPosAbove()) {
            class_2338 above2Pos = basePos.method_10086(2);
            class_2680 stateUp2 = worldIn.method_8320(above2Pos);
            if (!stateUp2.method_26220(worldIn, above2Pos).method_1110()) {
                return false;
            }
        }

        class_2338 cropPos = basePos.method_10084();
        class_2680 cropState = worldIn.method_8320(cropPos);
        if (task.canHarvest(maid, cropPos, cropState)) {
            return true;
        }

        class_2680 baseState = worldIn.method_8320(basePos);
        return seeds.stream().anyMatch(seed -> task.canPlant(maid, basePos, baseState, seed));
    }
}
