package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandler;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IChestType;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidWirelessIOEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.inventory.chest.ChestManager;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

import static com.github.tartaricacid.touhoulittlemaid.util.BytesBooleansConvert.bytes2Booleans;

public class WirelessIOBauble implements IMaidBauble {
    private static final int SLOT_NUM = 38;

    @Nonnull
    public static class_1799 insertItemStacked(IItemHandler inventory, @Nonnull class_1799 stack, boolean simulate, @Nullable boolean[] slotConfig) {
        if (stack.method_7960()) {
            return stack;
        }
        if (!stack.method_7946()) {
            return insertItem(inventory, stack, simulate, slotConfig);
        }
        int sizeInventory = inventory.getSlots();
        for (int i = 0; i < sizeInventory; i++) {
            class_1799 slot = inventory.getStackInSlot(i);
            if (slotConfig != null && i < slotConfig.length && slotConfig[i]) {
                continue;
            }
            if (canItemStacksStackRelaxed(slot, stack)) {
                stack = inventory.insertItem(i, stack, simulate);
                if (stack.method_7960()) {
                    break;
                }
            }
        }

        if (!stack.method_7960()) {
            for (int i = 0; i < sizeInventory; i++) {
                if (slotConfig != null && i < slotConfig.length && slotConfig[i]) {
                    continue;
                }
                if (inventory.getStackInSlot(i).method_7960()) {
                    stack = inventory.insertItem(i, stack, simulate);
                    if (stack.method_7960()) {
                        break;
                    }
                }
            }
        }

        return stack;
    }

    public static class_1799 insertItem(IItemHandler dest, @Nonnull class_1799 stack, boolean simulate, @Nullable boolean[] slotConfig) {
        if (stack.method_7960()) {
            return stack;
        }
        for (int i = 0; i < dest.getSlots(); i++) {
            if (slotConfig != null && i < slotConfig.length && slotConfig[i]) {
                continue;
            }
            stack = dest.insertItem(i, stack, simulate);
            if (stack.method_7960()) {
                return class_1799.field_8037;
            }
        }
        return stack;
    }

    public static boolean canItemStacksStackRelaxed(@Nonnull class_1799 a, @Nonnull class_1799 b) {
        if (a.method_7960() || b.method_7960() || a.method_7909() != b.method_7909()) {
            return false;
        }
        if (!a.method_7946()) {
            return false;
        }
        if (a.method_7985() != b.method_7985()) {
            return false;
        }
        return (!a.method_7985() || Objects.equals(a.method_7969(), Objects.requireNonNull(b.method_7969())))/* && a.areCapsCompatible(b)*/;
    }

    @Override
    public void onTick(EntityMaid maid, class_1799 baubleItem) {
        if (maid.field_6012 % 100 == 0 && !maid.guiOpening) {
            class_2338 bindingPos = ItemWirelessIO.getBindingPos(baubleItem);
            if (bindingPos == null) {
                return;
            }
            float maxDistance = maid.method_18413();
            if (maid.method_5649(bindingPos.method_10263(), bindingPos.method_10264(), bindingPos.method_10260()) > (maxDistance * maxDistance)) {
                return;
            }
            class_2586 te = maid.field_6002.method_8321(bindingPos);
            if (te == null) {
                return;
            }
            for (IChestType type : ChestManager.getAllChestTypes()) {
                if (!type.isChest(te)) {
                    continue;
                }
                int openCount = type.getOpenCount(maid.field_6002, bindingPos, te);
                if (openCount > 0) {
                    return;
                }
                Storage<ItemVariant> chestInv = ItemStorage.SIDED.find(maid.field_6002, te.method_11016(), te.method_11010(), te, null);
                if (chestInv == null) {
                    IItemHandler maidInv = maid.getAvailableInv(false);
                    boolean isMaidToChest = ItemWirelessIO.isMaidToChest(baubleItem);
                    boolean isBlacklist = ItemWirelessIO.isBlacklist(baubleItem);
                    byte[] slotConfig = ItemWirelessIO.getSlotConfig(baubleItem);
                    byte[] slotConfigTmp = null;
                    if (slotConfig != null) {
                        slotConfigTmp = Arrays.copyOf(slotConfig, slotConfig.length);
                        slotConfigTmp[maidInv.getSlots() - 2] = slotConfigTmp[SLOT_NUM - 2];
                        slotConfigTmp[maidInv.getSlots() - 1] = slotConfigTmp[SLOT_NUM - 1];
                    }
                    boolean[] slotConfigData = bytes2Booleans(slotConfigTmp, SLOT_NUM);
                    IItemHandler filterList = ItemWirelessIO.getFilterList(baubleItem);

                    if (isMaidToChest) {
                        var event = new MaidWirelessIOEvent.MaidToChest(maid, maidInv, chestInv, filterList, isBlacklist, slotConfigData);
                        MaidWirelessIOEvent.MAID_TO_CHEST.invoker().post(event);
                        if (!event.isCanceled()) {
                            maidToChest(maidInv, chestInv, isBlacklist, filterList, slotConfigData);
                        }
                    } else {
                        var event = new MaidWirelessIOEvent.ChestToMaid(maid, maidInv, chestInv, filterList, isBlacklist, slotConfigData);
                        MaidWirelessIOEvent.CHEST_TO_MAID.invoker().post(event);
                        if (!event.isCanceled()) {
                            chestToMaid(chestInv, maidInv, isBlacklist, filterList, slotConfigData);
                        }
                    }
                }
                if (maid.method_35057() instanceof class_3222 serverPlayer) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.USE_WIRELESS_IO);
                }
                return;
            }
        }
    }

    private void maidToChest(IItemHandler maid, Storage<ItemVariant> chest, boolean isBlacklist, IItemHandler filterList, boolean[] slotConfig) {
        for (int i = 0; i < maid.getSlots(); i++) {
            if (i < slotConfig.length && slotConfig[i]) {
                continue;
            }
            class_1799 maidInvItem = maid.getStackInSlot(i);
            boolean allowMove = isBlacklist;
            for (int j = 0; j < filterList.getSlots(); j++) {
                class_1799 filterItem = filterList.getStackInSlot(j);
                boolean isEqual = class_1799.method_7984(maidInvItem, filterItem);
                if (isEqual) {
                    allowMove = !isBlacklist;
                    break;
                }
            }
            if (allowMove) {
                int beforeCount = maidInvItem.method_7947();
//                ItemStack after = ItemHandlerHelper.insertItemStacked(chest, maidInvItem.copy(), false);
//                int afterCount = after.getCount();
//                // Sync Client & Server
//                if (beforeCount != afterCount) {
//                    maid.extractItem(i, beforeCount - afterCount, false);
//                }
                try (Transaction transaction = Transaction.openOuter()) {
                    long inserted = chest.insert(ItemVariant.of(maidInvItem.method_7972()), beforeCount, transaction);
                    if (inserted > 0) {
                        maid.extractItem(i, (int) inserted, false);
                        transaction.commit();
                    }
                }
            }
        }
    }

    private void chestToMaid(Storage<ItemVariant> chest, IItemHandler maid, boolean isBlacklist, IItemHandler filterList, boolean[] slotConfig) {
        for (StorageView<ItemVariant> view : chest.nonEmptyViews()) {
            ItemVariant chestInvStack = view.getResource();
            boolean allowMove = isBlacklist;
            for (int j = 0; j < filterList.getSlots(); j++) {
                class_1799 filterItem = filterList.getStackInSlot(j);
                boolean isEqual = class_1799.method_7984(chestInvStack.toStack(), filterItem);
                if (isEqual) {
                    allowMove = !isBlacklist;
                    break;
                }
            }
            if (allowMove) {
                int beforeCount = (int) view.getAmount();
                class_1799 after = insertItemStacked(maid, chestInvStack.toStack(beforeCount).method_7972(), false, slotConfig);
                int afterCount = after.method_7947();
                // Sync Client & Server
                if (beforeCount != afterCount) {
                    //chest.extractItem(i, beforeCount - afterCount, false);
                    try (Transaction transaction = Transaction.openOuter()) {
                        chest.extract(view.getResource(), beforeCount - afterCount, transaction);
                        transaction.commit();
                    }
                }
            }
        }
    }
}