package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_1802;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class SendNameTagMessage {
    private static final int MAX_STRING_LENGTH = 1024;
    public static final class_2960 ID = getResourceLocation("send_name_tag");

    public static class_2540 encode(int id, String name, boolean alwaysShow) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(id);
        buf.method_10788(name, MAX_STRING_LENGTH);
        buf.writeBoolean(alwaysShow);
        return buf;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        int id = buf.readInt();
        String name = buf.method_10800(MAX_STRING_LENGTH);
        boolean alwaysShow = buf.readBoolean();
        server.execute(() -> {
            class_1297 entity = player.field_6002.method_8469(id);
            if (entity instanceof EntityMaid) {
                setMaidNameTag(name, alwaysShow, player, (EntityMaid) entity);
            }
        });
    }

    private static void setMaidNameTag(String original, boolean alwaysShow, class_3222 player, EntityMaid maid) {
        String name = original.substring(0, Math.min(32, original.length()));
        if (player.equals(maid.method_35057()) && player.method_6047().method_7909() == class_1802.field_8448) {
            maid.method_5665(class_2561.method_43470(name));
            maid.method_5880(alwaysShow);
            maid.method_5971();
            if (!player.method_7337()) {
                player.method_6047().method_7934(1);
            }
        }
    }
}
