/*
 * Decompiled with CFR 0.152.
 */
package cn.sh1rocu.touhoulittlemaid.util.itemhandler.entity;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandlerModifiable;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemHandlerHelper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

public abstract class EntityEquipmentInvWrapper
implements IItemHandlerModifiable {
    protected final class_1309 entity;
    protected final List<class_1304> slots;

    public EntityEquipmentInvWrapper(class_1309 entity, class_1304.class_1305 slotType) {
        this.entity = entity;
        ArrayList<class_1304> slots = new ArrayList<class_1304>();
        for (class_1304 slot : class_1304.values()) {
            if (slot.method_5925() != slotType) continue;
            slots.add(slot);
        }
        this.slots = ImmutableList.copyOf(slots);
    }

    @Override
    public int getSlots() {
        return this.slots.size();
    }

    @Override
    public class_1799 getStackInSlot(int slot) {
        return this.entity.method_6118(this.validateSlotIndex(slot));
    }

    @Override
    public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1304 equipmentSlot = this.validateSlotIndex(slot);
        class_1799 existing = this.entity.method_6118(equipmentSlot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.method_7960()) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.method_7947();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.method_7947() > limit;
        if (!simulate) {
            if (existing.method_7960()) {
                this.entity.method_5673(equipmentSlot, reachedLimit ? stack.method_46651(limit) : stack);
            } else {
                existing.method_7933(reachedLimit ? limit : stack.method_7947());
            }
        }
        return reachedLimit ? stack.method_46651(stack.method_7947() - limit) : class_1799.field_8037;
    }

    @Override
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return class_1799.field_8037;
        }
        class_1304 equipmentSlot = this.validateSlotIndex(slot);
        class_1799 existing = this.entity.method_6118(equipmentSlot);
        if (existing.method_7960()) {
            return class_1799.field_8037;
        }
        int toExtract = Math.min(amount, existing.method_7914());
        if (existing.method_7947() <= toExtract) {
            if (!simulate) {
                this.entity.method_5673(equipmentSlot, class_1799.field_8037);
            }
            return existing;
        }
        if (!simulate) {
            this.entity.method_5673(equipmentSlot, existing.method_46651(existing.method_7947() - toExtract));
        }
        return existing.method_46651(toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        class_1304 equipmentSlot = this.validateSlotIndex(slot);
        return equipmentSlot.method_5925() == class_1304.class_1305.field_6178 ? 1 : 64;
    }

    protected int getStackLimit(int slot, class_1799 stack) {
        return Math.min(this.getSlotLimit(slot), stack.method_7914());
    }

    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        class_1304 equipmentSlot = this.validateSlotIndex(slot);
        if (class_1799.method_7973((class_1799)this.entity.method_6118(equipmentSlot), (class_1799)stack)) {
            return;
        }
        this.entity.method_5673(equipmentSlot, stack);
    }

    @Override
    public boolean isItemValid(int slot, class_1799 stack) {
        return true;
    }

    protected class_1304 validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.slots.size()) {
            throw new IllegalArgumentException("Slot " + slot + " not in valid range - [0," + this.slots.size() + ")");
        }
        return this.slots.get(slot);
    }
}

