/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.simplebedrockmodel.client.bedrock;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.BedrockModelProvider;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.BedrockModelUtil;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockCube;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockCubeBox;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockCubePerFace;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockModelPOJO;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockVersion;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BonesItem;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.CubesItem;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.Description;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.FaceUVsItem;
import com.github.tartaricacid.simplebedrockmodel.client.compat.sodium.SodiumBedrockCubeBox;
import com.github.tartaricacid.simplebedrockmodel.client.compat.sodium.SodiumBedrockCubePerFace;
import com.github.tartaricacid.simplebedrockmodel.client.compat.sodium.SodiumCompat;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_583;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractBedrockEntityModel<T extends class_1297>
extends class_583<T>
implements BedrockModelProvider<AbstractBedrockEntityModel<T>> {
    protected final HashMap<String, BedrockPart> modelMap = new HashMap();
    protected final HashMap<String, BonesItem> indexBones = new HashMap();
    protected final List<BedrockPart> shouldRender = new LinkedList<BedrockPart>();
    protected class_238 renderBoundingBox;

    public AbstractBedrockEntityModel(InputStream stream) {
        super(class_1921::method_23578);
        BedrockModelPOJO pojo = (BedrockModelPOJO)BedrockModelUtil.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), BedrockModelPOJO.class);
        if (BedrockVersion.isLegacyVersion(pojo)) {
            this.loadLegacyModel(pojo);
        }
        if (BedrockVersion.isNewVersion(pojo)) {
            this.loadNewModel(pojo);
        }
    }

    public AbstractBedrockEntityModel(BedrockModelPOJO pojo) {
        this(pojo, BedrockVersion.getVersion(pojo));
    }

    public AbstractBedrockEntityModel(BedrockModelPOJO pojo, BedrockVersion version) {
        super(class_1921::method_23578);
        if (version == BedrockVersion.LEGACY) {
            this.loadLegacyModel(pojo);
        }
        if (version == BedrockVersion.NEW) {
            this.loadNewModel(pojo);
        }
    }

    public AbstractBedrockEntityModel() {
        super(class_1921::method_23578);
        this.renderBoundingBox = new class_238(-1.0, 0.0, -1.0, 1.0, 2.0, 1.0);
    }

    protected void loadNewModel(BedrockModelPOJO pojo) {
        assert (pojo.getGeometryModelNew() != null);
        pojo.getGeometryModelNew().deco();
        Description description = pojo.getGeometryModelNew().getDescription();
        int texWidth = description.getTextureWidth();
        int texHeight = description.getTextureHeight();
        float[] offset = description.getVisibleBoundsOffset();
        float offsetX = offset[0];
        float offsetY = offset[1];
        float offsetZ = offset[2];
        float width = description.getVisibleBoundsWidth() / 2.0f;
        float height = description.getVisibleBoundsHeight() / 2.0f;
        this.renderBoundingBox = new class_238((double)(offsetX - width), (double)(offsetY - height), (double)(offsetZ - width), (double)(offsetX + width), (double)(offsetY + height), (double)(offsetZ + width));
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            this.indexBones.put(bones.getName(), bones);
            this.modelMap.put(bones.getName(), new BedrockPart());
        }
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            String name = bones.getName();
            float[] rotation = bones.getRotation();
            String parent = bones.getParent();
            BedrockPart model = this.modelMap.get(name);
            model.mirror = bones.isMirror();
            model.setPos(this.convertPivot(bones, 0), this.convertPivot(bones, 1), this.convertPivot(bones, 2));
            if (rotation != null) {
                this.setRotationAngle(model, this.convertRotation(rotation[0]), this.convertRotation(rotation[1]), this.convertRotation(rotation[2]));
            }
            if (parent != null) {
                this.modelMap.get(parent).addChild(model);
            } else {
                this.shouldRender.add(model);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cube : bones.getCubes()) {
                float[] uv = cube.getUv();
                FaceUVsItem faceUv = cube.getFaceUv();
                float[] size = cube.getSize();
                float[] cubeRotation = cube.getRotation();
                boolean mirror = cube.isMirror();
                float inflate = cube.getInflate();
                if (cubeRotation == null) {
                    if (faceUv == null) {
                        model.cubes.add((Object)this.createCubeBox(uv[0], uv[1], this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size[0], size[1], size[2], inflate, mirror, texWidth, texHeight));
                        continue;
                    }
                    model.cubes.add((Object)this.createCubePerFace(this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size[0], size[1], size[2], inflate, texWidth, texHeight, faceUv));
                    continue;
                }
                BedrockPart cubeRenderer = new BedrockPart();
                cubeRenderer.setPos(this.convertPivot(bones, cube, 0), this.convertPivot(bones, cube, 1), this.convertPivot(bones, cube, 2));
                this.setRotationAngle(cubeRenderer, this.convertRotation(cubeRotation[0]), this.convertRotation(cubeRotation[1]), this.convertRotation(cubeRotation[2]));
                if (faceUv == null) {
                    cubeRenderer.cubes.add((Object)this.createCubeBox(uv[0], uv[1], this.convertOrigin(cube, 0), this.convertOrigin(cube, 1), this.convertOrigin(cube, 2), size[0], size[1], size[2], inflate, mirror, texWidth, texHeight));
                } else {
                    cubeRenderer.cubes.add((Object)this.createCubePerFace(this.convertOrigin(cube, 0), this.convertOrigin(cube, 1), this.convertOrigin(cube, 2), size[0], size[1], size[2], inflate, texWidth, texHeight, faceUv));
                }
                model.addChild(cubeRenderer);
            }
        }
    }

    protected void loadLegacyModel(BedrockModelPOJO pojo) {
        assert (pojo.getGeometryModelLegacy() != null);
        pojo.getGeometryModelLegacy().deco();
        int texWidth = pojo.getGeometryModelLegacy().getTextureWidth();
        int texHeight = pojo.getGeometryModelLegacy().getTextureHeight();
        float[] offset = pojo.getGeometryModelLegacy().getVisibleBoundsOffset();
        float offsetX = offset[0];
        float offsetY = offset[1];
        float offsetZ = offset[2];
        float width = pojo.getGeometryModelLegacy().getVisibleBoundsWidth() / 2.0f;
        float height = pojo.getGeometryModelLegacy().getVisibleBoundsHeight() / 2.0f;
        this.renderBoundingBox = new class_238((double)(offsetX - width), (double)(offsetY - height), (double)(offsetZ - width), (double)(offsetX + width), (double)(offsetY + height), (double)(offsetZ + width));
        for (BonesItem bones : pojo.getGeometryModelLegacy().getBones()) {
            this.indexBones.put(bones.getName(), bones);
            this.modelMap.put(bones.getName(), new BedrockPart());
        }
        for (BonesItem bones : pojo.getGeometryModelLegacy().getBones()) {
            String name = bones.getName();
            float[] rotation = bones.getRotation();
            String parent = bones.getParent();
            BedrockPart model = this.modelMap.get(name);
            model.mirror = bones.isMirror();
            model.setPos(this.convertPivot(bones, 0), this.convertPivot(bones, 1), this.convertPivot(bones, 2));
            if (rotation != null) {
                this.setRotationAngle(model, this.convertRotation(rotation[0]), this.convertRotation(rotation[1]), this.convertRotation(rotation[2]));
            }
            if (parent != null) {
                this.modelMap.get(parent).addChild(model);
            } else {
                this.shouldRender.add(model);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cube : bones.getCubes()) {
                float[] uv = cube.getUv();
                float[] size = cube.getSize();
                boolean mirror = cube.isMirror();
                float inflate = cube.getInflate();
                model.cubes.add((Object)new BedrockCubeBox(uv[0], uv[1], this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size[0], size[1], size[2], inflate, mirror, texWidth, texHeight));
            }
        }
    }

    protected BedrockCube createCubeBox(float texOffX, float texOffY, float x, float y, float z, float width, float height, float depth, float delta, boolean mirror, float texWidth, float texHeight) {
        if (SodiumCompat.isSodiumInstalled()) {
            return new SodiumBedrockCubeBox(texOffX, texOffY, x, y, z, width, height, depth, delta, mirror, texWidth, texHeight);
        }
        return new BedrockCubeBox(texOffX, texOffY, x, y, z, width, height, depth, delta, mirror, texWidth, texHeight);
    }

    protected BedrockCube createCubePerFace(float x, float y, float z, float width, float height, float depth, float delta, float texWidth, float texHeight, FaceUVsItem faces) {
        if (SodiumCompat.isSodiumInstalled()) {
            return new SodiumBedrockCubePerFace(x, y, z, width, height, depth, delta, texWidth, texHeight, faces);
        }
        return new BedrockCubePerFace(x, y, z, width, height, depth, delta, texWidth, texHeight, faces);
    }

    @ParametersAreNonnullByDefault
    public void method_2828(class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        for (BedrockPart model : this.shouldRender) {
            model.render(poseStack, buffer, packedLight, packedOverlay);
        }
    }

    @Override
    public class_238 getRenderBoundingBox() {
        return this.renderBoundingBox;
    }

    @Override
    public HashMap<String, BedrockPart> getModelMap() {
        return this.modelMap;
    }

    protected void setRotationAngle(BedrockPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
        modelRenderer.setInitRotationAngle(x, y, z);
    }

    protected float convertPivot(BonesItem bones, int index) {
        if (bones.getParent() != null) {
            if (index == 1) {
                return this.indexBones.get(bones.getParent()).getPivot()[index] - bones.getPivot()[index];
            }
            return bones.getPivot()[index] - this.indexBones.get(bones.getParent()).getPivot()[index];
        }
        if (index == 1) {
            return 24.0f - bones.getPivot()[index];
        }
        return bones.getPivot()[index];
    }

    protected float convertPivot(BonesItem parent, CubesItem cube, int index) {
        assert (cube.getPivot() != null);
        if (index == 1) {
            return parent.getPivot()[index] - cube.getPivot()[index];
        }
        return cube.getPivot()[index] - parent.getPivot()[index];
    }

    protected float convertOrigin(BonesItem bone, CubesItem cube, int index) {
        if (index == 1) {
            return bone.getPivot()[index] - cube.getOrigin()[index] - cube.getSize()[index];
        }
        return cube.getOrigin()[index] - bone.getPivot()[index];
    }

    protected float convertOrigin(CubesItem cube, int index) {
        assert (cube.getPivot() != null);
        if (index == 1) {
            return cube.getPivot()[index] - cube.getOrigin()[index] - cube.getSize()[index];
        }
        return cube.getOrigin()[index] - cube.getPivot()[index];
    }

    protected float convertRotation(float degree) {
        return (float)((double)degree * Math.PI / 180.0);
    }
}

