/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.block;

import com.github.tartaricacid.touhoulittlemaid.client.gui.block.ModelSwitcherGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail.MaidModelDetailsGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.AbstractModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_638;
import org.apache.commons.lang3.StringUtils;

public class ModelSwitcherModelGui
extends AbstractModelGui<EntityMaid, MaidModelInfo> {
    private static int PAGE_INDEX = 0;
    private static int PACK_INDEX = 0;
    private static int ROW_INDEX = 0;
    private final TileEntityModelSwitcher.ModeInfo infoIn;
    private final ModelSwitcherGui modelSwitcherGui;

    public ModelSwitcherModelGui(EntityMaid maid, TileEntityModelSwitcher.ModeInfo infoIn, ModelSwitcherGui modelSwitcherGui) {
        super(maid, CustomPackLoader.MAID_MODELS.getPackList());
        this.infoIn = infoIn;
        this.modelSwitcherGui = modelSwitcherGui;
    }

    @Override
    protected void drawLeftEntity(class_332 graphics, int middleX, int middleY, float mouseX, float mouseY) {
        float renderItemScale = CustomPackLoader.MAID_MODELS.getModelRenderItemScale(((EntityMaid)this.entity).getModelId());
        class_490.method_2486((class_332)graphics, (int)((middleX - 128) / 2), (int)(middleY + 90), (int)((int)(45.0f * renderItemScale)), (float)(((float)middleX - 128.0f) / 2.0f - mouseX), (float)((float)(middleY + 80 - 40) - mouseY), (class_1309)this.entity);
    }

    @Override
    protected void drawRightEntity(class_332 graphics, int posX, int posY, MaidModelInfo modelItem) {
        class_2960 cacheIconId = modelItem.getCacheIconId();
        Map allTextures = class_310.method_1551().method_1531().field_5286;
        if (((Boolean)MiscConfig.MODEL_ICON_CACHE.get()).booleanValue() && allTextures.containsKey(cacheIconId)) {
            int textureSize = 24;
            graphics.method_25293(cacheIconId, posX - textureSize / 2, posY - textureSize, textureSize, textureSize, 0.0f, 0.0f, textureSize, textureSize, textureSize, textureSize);
        } else {
            this.drawEntity(graphics, posX, posY, modelItem);
        }
    }

    @Override
    protected void openDetailsGui(EntityMaid maid, MaidModelInfo modelInfo) {
        if (this.field_22787 != null && modelInfo.getEasterEgg() == null) {
            this.field_22787.method_1507((class_437)new MaidModelDetailsGui(maid, modelInfo));
        }
    }

    @Override
    protected void notifyModelChange(EntityMaid maid, MaidModelInfo info) {
        if (info.getEasterEgg() == null) {
            maid.setModelId(info.getModelId().toString());
            this.infoIn.setModelId(info.getModelId());
            Screens.getClient((class_437)this).method_1507((class_437)this.modelSwitcherGui);
        }
    }

    @Override
    protected void addModelCustomTips(MaidModelInfo modelItem, List<class_2561> tooltips) {
        String useSoundPackId = modelItem.getUseSoundPackId();
        if (StringUtils.isNotBlank((CharSequence)useSoundPackId)) {
            tooltips.add((class_2561)class_2561.method_43469((String)"gui.touhou_little_maid.skin.tooltips.maid_use_sound_pack_id", (Object[])new Object[]{useSoundPackId}).method_27692(class_124.field_1065));
        }
    }

    @Override
    protected int getPageIndex() {
        return PAGE_INDEX;
    }

    @Override
    protected void setPageIndex(int pageIndex) {
        PAGE_INDEX = pageIndex;
    }

    @Override
    protected int getPackIndex() {
        return PACK_INDEX;
    }

    @Override
    protected void setPackIndex(int packIndex) {
        PACK_INDEX = packIndex;
    }

    @Override
    protected int getRowIndex() {
        return ROW_INDEX;
    }

    @Override
    protected void setRowIndex(int rowIndex) {
        ROW_INDEX = rowIndex;
    }

    private void drawEntity(class_332 graphics, int posX, int posY, MaidModelInfo modelItem) {
        EntityMaid maid;
        class_638 world = Screens.getClient((class_437)this).field_1687;
        if (world == null) {
            return;
        }
        try {
            maid = (EntityMaid)EntityCacheUtil.ENTITY_CACHE.get(EntityMaid.TYPE, () -> ModelSwitcherModelGui.lambda$drawEntity$1((class_1937)world));
        }
        catch (ClassCastException | ExecutionException e) {
            e.printStackTrace();
            return;
        }
        EntityCacheUtil.clearMaidDataResidue(maid, false);
        if (modelItem.getEasterEgg() != null) {
            maid.setModelId("touhou_little_maid:easter_egg_model");
        } else {
            maid.setModelId(modelItem.getModelId().toString());
        }
        maid.setIsYsmModel(false);
        class_490.method_2486((class_332)graphics, (int)posX, (int)posY, (int)((int)(12.0f * modelItem.getRenderItemScale())), (float)-25.0f, (float)-20.0f, (class_1309)maid);
    }

    private static /* synthetic */ class_1297 lambda$drawEntity$1(class_1937 world) throws Exception {
        class_1297 e = EntityMaid.TYPE.method_5883(world);
        return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
    }
}

