/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.message.FoxScrollMessage;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.commons.lang3.tuple.Pair;

public class ItemFoxScroll
extends class_1792 {
    private static final String TRACK_INFO = "TrackInfo";

    public ItemFoxScroll() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public static boolean hasTrackInfo(class_1799 scroll) {
        return scroll.method_7985() && !Objects.requireNonNull(scroll.method_7969()).method_10562(TRACK_INFO).method_33133();
    }

    public static void setTrackInfo(class_1799 scroll, String dimension, class_2338 pos) {
        class_2487 tag = scroll.method_7911(TRACK_INFO);
        tag.method_10582("Dimension", dimension);
        tag.method_10566("Position", (class_2520)class_2512.method_10692((class_2338)pos));
    }

    @Nullable
    public static Pair<String, class_2338> getTrackInfo(class_1799 scroll) {
        if (ItemFoxScroll.hasTrackInfo(scroll)) {
            class_2487 tag = Objects.requireNonNull(scroll.method_7969()).method_10562(TRACK_INFO);
            String dimension = tag.method_10558("Dimension");
            class_2338 position = class_2512.method_10691((class_2487)tag.method_10562("Position"));
            return Pair.of((Object)dimension, (Object)position);
        }
        return null;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        if (!level.field_9236 && hand == class_1268.field_5808) {
            class_1799 item = player.method_6047();
            MaidWorldData maidWorldData = MaidWorldData.get(level);
            if (maidWorldData == null) {
                return super.method_7836(level, player, hand);
            }
            HashMap data = Maps.newHashMap();
            List<MaidInfo> maidInfos = null;
            if (item.method_7909() == InitItems.RED_FOX_SCROLL) {
                maidInfos = maidWorldData.getPlayerMaidInfos(player);
            } else if (item.method_7909() == InitItems.WHITE_FOX_SCROLL) {
                maidInfos = maidWorldData.getPlayerMaidTombstones(player);
            }
            if (maidInfos == null) {
                maidInfos = Collections.emptyList();
            }
            maidInfos.forEach(info -> {
                List scrollData = data.computeIfAbsent(info.getDimension(), dim -> Lists.newArrayList());
                scrollData.add(new FoxScrollMessage.FoxScrollData(info.getChunkPos(), info.getName(), info.getTimestamp()));
            });
            ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)FoxScrollMessage.ID, (class_2540)FoxScrollMessage.encode(data));
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (item.method_7909() == InitItems.RED_FOX_SCROLL) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, "use_red_fox_scroll");
                } else if (item.method_7909() == InitItems.WHITE_FOX_SCROLL) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, "use_white_fox_scroll");
                }
            }
            return class_1271.method_22427((Object)item);
        }
        return super.method_7836(level, player, hand);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 pLevel, List<class_2561> components, class_1836 pIsAdvanced) {
        Pair<String, class_2338> info = ItemFoxScroll.getTrackInfo(stack);
        if (info != null) {
            components.add((class_2561)class_2561.method_43469((String)"tooltips.touhou_little_maid.fox_scroll.dimension", (Object[])new Object[]{info.getLeft()}).method_27692(class_124.field_1065));
            components.add((class_2561)class_2561.method_43469((String)"tooltips.touhou_little_maid.fox_scroll.position", (Object[])new Object[]{((class_2338)info.getRight()).method_23854()}).method_27692(class_124.field_1061));
            components.add((class_2561)class_2561.method_43473());
        }
        if (stack.method_7909() == InitItems.RED_FOX_SCROLL) {
            components.add((class_2561)class_2561.method_43471((String)"tooltips.touhou_little_maid.fox_scroll.red").method_27692(class_124.field_1080));
        } else if (stack.method_7909() == InitItems.WHITE_FOX_SCROLL) {
            components.add((class_2561)class_2561.method_43471((String)"tooltips.touhou_little_maid.fox_scroll.white").method_27692(class_124.field_1080));
        }
        super.method_7851(stack, pLevel, components, pIsAdvanced);
    }
}

