package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.ImageChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.ProgressChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.TextChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.WaitingChatBubbleData;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import org.jetbrains.annotations.NotNull;

import java.util.Map;
import net.minecraft.class_2941;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

import static com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleDataCollection.MAX_SIZE;

public class ChatBubbleRegister {
    public static Map<class_2960, IChatBubbleData.ChatSerializer> CODEC_MAP = Maps.newHashMap();
    public static final class_2941<ChatBubbleDataCollection> INSTANCE = new class_2941<>() {
        @Override
        public @NotNull class_9139<? super class_9129, ChatBubbleDataCollection> codec() {
            return new class_9139<>() {
                @Override
                public void encode(@NotNull class_9129 buf, @NotNull ChatBubbleDataCollection data) {
                    buf.method_10804(Math.min(MAX_SIZE, data.size()));
                    int i = 0;
                    for (long key : data.keySet()) {
                        if (i < MAX_SIZE) {
                            IChatBubbleData bubbleData = data.get(key);
                            buf.method_52974(key);
                            class_2960 id = bubbleData.id();
                            buf.method_10812(id);
                            ChatBubbleRegister.CODEC_MAP.get(id).writeToBuff(buf, bubbleData);
                        }
                        i++;
                    }
                }

                @Override
                public @NotNull ChatBubbleDataCollection decode(@NotNull class_9129 buf) {
                    ChatBubbleDataCollection map = new ChatBubbleDataCollection(new Long2ObjectAVLTreeMap<>());
                    int size = buf.method_10816();
                    for (int i = 0; i < size; i++) {
                        long key = buf.readLong();
                        class_2960 id = buf.method_10810();
                        IChatBubbleData bubbleData = ChatBubbleRegister.CODEC_MAP.get(id).readFromBuff(buf);
                        map.put(key, bubbleData);
                    }
                    return map;
                }
            };
        }

        @Override
        public @NotNull ChatBubbleDataCollection copy(@NotNull ChatBubbleDataCollection value) {
            return value;
        }
    };

    public static void init() {
        ChatBubbleRegister register = new ChatBubbleRegister();
        register.register(TextChatBubbleData.ID, new TextChatBubbleData.TextChatSerializer());
        register.register(ImageChatBubbleData.ID, new ImageChatBubbleData.ImageChatSerializer());
        register.register(WaitingChatBubbleData.ID, new WaitingChatBubbleData.WaitingChatSerializer());
        register.register(ProgressChatBubbleData.ID, new ProgressChatBubbleData.ProgressChatSerializer());
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.registerChatBubble(register);
        }
        CODEC_MAP = ImmutableMap.copyOf(CODEC_MAP);
        // 同时读取随机表情
        RandomEmoji.init();
    }

    public void register(class_2960 id, IChatBubbleData.ChatSerializer serializer) {
        if (CODEC_MAP.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate codec id: " + id);
        }
        CODEC_MAP.put(id, serializer);
    }
}