package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import cn.sh1rocu.touhoulittlemaid.api.extension.IEntity;
import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ExperienceOrbAccessor;
import cn.sh1rocu.touhoulittlemaid.util.block.BlockUtil;
import cn.sh1rocu.touhoulittlemaid.util.enchant.EnchantmentUtil;
import cn.sh1rocu.touhoulittlemaid.util.forge.CommonHooks;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.*;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.entity.EntityArmorInvWrapper;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.entity.EntityHandsInvWrapper;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.api.client.render.MaidRenderState;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.api.event.*;
import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.event.YsmMaidClientTickEvent;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.EntityTypeGenerator;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagItem;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidBrain;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.control.MaidMoveControl;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.MaidPathNavigation;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.*;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleDataCollection;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManager;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleRegister;
import com.github.tartaricacid.touhoulittlemaid.entity.data.MaidTaskDataMaps;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.info.ServerCustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.MaidFishingHook;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskIdle;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.init.*;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.config.MaidAIChatConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.config.MaidConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.MaidBackpackHandler;
import com.github.tartaricacid.touhoulittlemaid.item.ItemFilm;
import com.github.tartaricacid.touhoulittlemaid.mixin.accessor.ArrowAccessor;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.ItemBreakPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.PlayMaidSoundPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendEffectPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncYsmMaidDataPackage;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.util.TeleportHelper;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_11;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_14;
import net.minecraft.class_1408;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1743;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1781;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1819;
import net.minecraft.class_1839;
import net.minecraft.class_1856;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_3745;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_4174;
import net.minecraft.class_4215;
import net.minecraft.class_4770;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5454;
import net.minecraft.class_5455;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6024;
import net.minecraft.class_6088;
import net.minecraft.class_6862;
import net.minecraft.class_7;
import net.minecraft.class_7923;
import net.minecraft.class_8103;
import net.minecraft.class_9381;
import net.minecraft.class_9701;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.*;
import net.minecraft.world.item.*;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nullable;
import java.time.Duration;
import java.util.*;

import static com.github.tartaricacid.touhoulittlemaid.config.ServerConfig.MAID_AI_TIME_DEBUG;
import static com.github.tartaricacid.touhoulittlemaid.datagen.EnchantmentKeys.getEnchantmentLevel;
import static com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment.MAID_NUM;
import static com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent.MODEL_ID_TAG_NAME;

public class EntityMaid extends class_1321 implements class_3745, IMaid, IEntity {
    private boolean isAddedToLevel;

    public static final class_1299<EntityMaid> TYPE = class_1299.class_1300.<EntityMaid>method_5903(EntityMaid::new, class_1311.field_6294)
            .method_17687(0.6f, 1.5f).method_27299(10).method_5905("maid");

    // YSM 女仆兼容内容
    public static final String IS_YSM_MODEL_TAG = "IsYsmModel";
    public static final String YSM_MODEL_ID_TAG = "YsmModelId";
    public static final String YSM_MODEL_TEXTURE_TAG = "YsmModelTexture";
    public static final String YSM_MODEL_NAME_TAG = "YsmModelName";
    public static final String YSM_ROULETTE_ANIM_TAG = "YsmRouletteAnim";
    public static final String YSM_ROAMING_VARS_TAG = "YsmRoamingVars";
    public static final String YSM_ROAMING_UPDATE_FLAG_TAG = "YsmRoamingUpdateFlag";

    // 女仆默认属性
    public static final String MODEL_ID_TAG = MODEL_ID_TAG_NAME;
    public static final String SOUND_PACK_ID_TAG = "SoundPackId";
    public static final String MAID_BACKPACK_TYPE = "MaidBackpackType";
    public static final String MAID_INVENTORY_TAG = "MaidInventory";
    public static final String MAID_BAUBLE_INVENTORY_TAG = "MaidBaubleInventory";
    public static final String MAID_HIDE_INVENTORY_TAG = "MaidHideInventory";
    public static final String MAID_TASK_INVENTORY_TAG = "MaidTaskInventory";
    public static final String EXPERIENCE_TAG = "MaidExperience";

    // AI 超时检测
    private static final long WARNING_TIME_NANOS = Duration.ofMillis(50L).toNanos();
    // 女仆传送到主人处的最大尝试次数
    private static final int MAX_TELEPORT_ATTEMPTS_TIMES = 10;

    // YSM 女仆兼容同步数据
    private static final class_2940<Boolean> DATA_IS_YSM_MODEL = class_2945.method_12791(EntityMaid.class, class_2943.field_13323);
    private static final class_2940<String> DATA_YSM_MODEL_ID = class_2945.method_12791(EntityMaid.class, class_2943.field_13326);
    private static final class_2940<String> DATA_YSM_MODEL_TEXTURE = class_2945.method_12791(EntityMaid.class, class_2943.field_13326);
    private static final class_2940<class_2561> DATA_YSM_MODEL_NAME = class_2945.method_12791(EntityMaid.class, class_2943.field_13317);

    // 女仆默认同步数据
    private static final class_2940<String> DATA_MODEL_ID = class_2945.method_12791(EntityMaid.class, class_2943.field_13326);
    private static final class_2940<String> DATA_SOUND_PACK_ID = class_2945.method_12791(EntityMaid.class, class_2943.field_13326);
    private static final class_2940<String> DATA_TASK = class_2945.method_12791(EntityMaid.class, class_2943.field_13326);
    private static final class_2940<Boolean> DATA_BEGGING = class_2945.method_12791(EntityMaid.class, class_2943.field_13323);
    private static final class_2940<Boolean> DATA_INVULNERABLE = class_2945.method_12791(EntityMaid.class, class_2943.field_13323);
    private static final class_2940<Integer> DATA_HUNGER = class_2945.method_12791(EntityMaid.class, class_2943.field_13327);
    private static final class_2940<Integer> DATA_FAVORABILITY = class_2945.method_12791(EntityMaid.class, class_2943.field_13327);
    private static final class_2940<Integer> DATA_EXPERIENCE = class_2945.method_12791(EntityMaid.class, class_2943.field_13327);
    private static final class_2940<Boolean> DATA_STRUCK_BY_LIGHTNING = class_2945.method_12791(EntityMaid.class, class_2943.field_13323);
    private static final class_2940<Boolean> DATA_IS_CHARGING_CROSSBOW = class_2945.method_12791(EntityMaid.class, class_2943.field_13323);
    private static final class_2940<Boolean> DATA_ARM_RISE = class_2945.method_12791(EntityMaid.class, class_2943.field_13323);
    private static final class_2940<MaidSchedule> SCHEDULE_MODE = class_2945.method_12791(EntityMaid.class, MaidSchedule.DATA);
    private static final class_2940<class_2338> RESTRICT_CENTER = class_2945.method_12791(EntityMaid.class, class_2943.field_13324);
    private static final class_2940<Float> RESTRICT_RADIUS = class_2945.method_12791(EntityMaid.class, class_2943.field_13320);
    private static final class_2940<ChatBubbleDataCollection> CHAT_BUBBLE = class_2945.method_12791(EntityMaid.class, ChatBubbleRegister.INSTANCE);
    private static final class_2940<String> BACKPACK_TYPE = class_2945.method_12791(EntityMaid.class, class_2943.field_13326);
    private static final class_2940<class_1799> BACKPACK_ITEM_SHOW = class_2945.method_12791(EntityMaid.class, class_2943.field_13322);
    private static final class_2940<String> BACKPACK_FLUID = class_2945.method_12791(EntityMaid.class, class_2943.field_13326);

    // 游戏数据记录，包括赢棋次数和赢棋状态
    static final class_2940<class_2487> GAME_SKILL = class_2945.method_12791(EntityMaid.class, class_2943.field_13318);
    static final class_2940<Byte> GAME_STATUE = class_2945.method_12791(EntityMaid.class, class_2943.field_13319);

    // 给 MaidConfigManager 用的，必须在这里声明，避免 ID 不同步
    static final class_2940<Boolean> DATA_PICKUP = class_2945.method_12791(EntityMaid.class, class_2943.field_13323);
    static final class_2940<Boolean> DATA_HOME_MODE = class_2945.method_12791(EntityMaid.class, class_2943.field_13323);
    static final class_2940<Boolean> DATA_RIDEABLE = class_2945.method_12791(EntityMaid.class, class_2943.field_13323);
    static final class_2940<Boolean> BACKPACK_SHOW = class_2945.method_12791(EntityMaid.class, class_2943.field_13323);
    static final class_2940<Boolean> BACK_ITEM_SHOW = class_2945.method_12791(EntityMaid.class, class_2943.field_13323);
    static final class_2940<Boolean> CHATBUBBLE_SHOW = class_2945.method_12791(EntityMaid.class, class_2943.field_13323);
    static final class_2940<Float> SOUND_FREQ = class_2945.method_12791(EntityMaid.class, class_2943.field_13320);
    static final class_2940<Integer> PICKUP_TYPE = class_2945.method_12791(EntityMaid.class, class_2943.field_13327);
    static final class_2940<Boolean> OPEN_DOOR = class_2945.method_12791(EntityMaid.class, class_2943.field_13323);
    static final class_2940<Boolean> OPEN_FENCE_GATE = class_2945.method_12791(EntityMaid.class, class_2943.field_13323);
    static final class_2940<Boolean> ACTIVE_CLIMBING = class_2945.method_12791(EntityMaid.class, class_2943.field_13323);

    /**
     * 开辟空间给任务存储使用,也便于附属模组存储数据
     */
    private static final class_2940<class_2487> TASK_DATA_SYNC = class_2945.method_12791(EntityMaid.class, class_2943.field_13318);
    private static final String TASK_TAG = "MaidTask";
    private static final String STRUCK_BY_LIGHTNING_TAG = "StruckByLightning";
    private static final String INVULNERABLE_TAG = "Invulnerable";
    private static final String HUNGER_TAG = "MaidHunger";
    private static final String FAVORABILITY_TAG = "MaidFavorability";
    private static final String SCHEDULE_MODE_TAG = "MaidScheduleMode";
    private static final String BACKPACK_DATA_TAG = "MaidBackpackData";
    private static final String STRUCTURE_SPAWN_TAG = "StructureSpawn";
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";

    // 弃用数据，仅用于旧版存档的迁移
    private static final @Deprecated String BACKPACK_LEVEL_TAG = "MaidBackpackLevel";
    private static final @Deprecated String RESTRICT_CENTER_TAG = "MaidRestrictCenter";

    public final class_1799[] handItemsForAnimation = new class_1799[]{class_1799.field_8037, class_1799.field_8037};

    // 物品存储相关
    private final EntityArmorInvWrapper armorInvWrapper = InitCapabilities.MAID_ARMOR.get(this) /*new EntityArmorInvWrapper(this)*/;
    private final EntityHandsInvWrapper handsInvWrapper = InitCapabilities.MAID_HAND.get(this) /*new MaidHandsInvWrapper(this)*/;
    //private final ItemStackHandler maidInv = new MaidBackpackHandler(36, this);
    private final MaidBackpackHandler maidInv = InitCapabilities.MAID_INV.get(this);
    private final BaubleItemHandler maidBauble = InitCapabilities.MAID_BAUBLE.get(this) /*new BaubleItemHandler(9)*/;
    // 用于暂存副手物品的物品栏
    private final ItemStackHandler hideInv = new ItemStackHandler(1);
    // 用于工作任务可能需要的物品栏
    private final ItemStackHandler taskInv = new ItemStackHandler(9);

    private final MaidKillRecordManager killRecordManager = new MaidKillRecordManager();
    private final ChatBubbleManager chatBubbleManager = new ChatBubbleManager(this);
    private final MaidTaskDataMaps taskDataMaps = new MaidTaskDataMaps();
    private final FavorabilityManager favorabilityManager;
    private final MaidSwimManager swimManager;
    // 控制不同的 navigation 切换的条件以及切换后变更女仆相关的 AI 控制参数
    private final MaidNavigationManager navigationManager;
    private final MaidAIChatManager aiChatManager;
    private final SchedulePos schedulePos;
    private final class_1796 cooldowns;

    public boolean guiOpening = false;
    public MaidFishingHook fishing = null;

    public MaidRenderState renderState = MaidRenderState.ENTITY;
    public boolean rouletteAnimPlaying = false;
    public String rouletteAnim = "empty";
    public boolean rouletteAnimDirty = false;
    public int roamingVarsUpdateFlag = 0;
    public Object2FloatOpenHashMap<String> roamingVars = new Object2FloatOpenHashMap<>();

    private List<SendEffectPackage.EffectData> effects = Lists.newArrayList();
    private IMaidTask task = TaskManager.getIdleTask();
    private IMaidBackpack backpack = BackpackManager.getEmptyBackpack();
    private int playerHurtSoundCount = 120;
    private int pickupSoundCount = 5;
    private int backpackDelay = 0;
    private int passiveUseShieldTick = 0;
    private IBackpackData backpackData = null;
    private boolean syncTaskDataMaps = false;
    private MaidConfigManager configManager = new MaidConfigManager(this.field_6011);
    private MaidGameRecordManager gameRecordManager = new MaidGameRecordManager(this);

    /**
     * 女仆现在可以在前哨站生成，那么会打上这个标签
     */
    private boolean structureSpawn = false;
    /**
     * 女仆主动爬行标志位，用于管控女仆当前时刻需不需要攀爬
     */
    private boolean canClimb = false;
    /**
     * 一个记录女仆已经生成墓碑的变量，避免死亡重复生成墓碑
     */
    private boolean alreadyDropped = false;

    /**
     * 爬梯的计时器，用于在爬梯后的一段时间内禁用摔落伤害
     */
    private int climbFallDelayTicks = 0;

    protected EntityMaid(class_1299<EntityMaid> type, class_1937 world) {
        super(type, world);
        this.favorabilityManager = new FavorabilityManager(this);
        this.aiChatManager = new MaidAIChatManager(this);

        // 尝试修复 https://github.com/TartaricAcid/TouhouLittleMaid/issues/631
        class_5321<class_1937> dimension = Objects.requireNonNullElse(world.method_27983(), class_1937.field_25179);
        this.schedulePos = new SchedulePos(class_2338.field_10980, dimension.method_29177());

        this.field_6207 = new MaidMoveControl(this);
        this.swimManager = new MaidSwimManager(this);
        this.navigationManager = new MaidNavigationManager(this);

        this.cooldowns = new class_1796();
    }

    public EntityMaid(class_1937 worldIn) {
        this(TYPE, worldIn);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1309.method_26827()
                // 目前仅用于寻路，女仆最大可寻路 64 格
                .method_26868(class_5134.field_23717, 64)
                .method_26867(class_5134.field_23722)
                .method_26867(class_5134.field_23721)
                .method_26867(class_5134.field_51577)
                // 目前仅用于寻路，女仆最大可寻路 64 格
                .method_26867(class_5134.field_23726)
                // 用于女仆近战的范围判断
                .method_26868(class_5134.field_47759, 2);
    }

    public static boolean canInsertItem(class_1799 stack) {
        class_2960 key = class_7923.field_41178.method_10221(stack.method_7909());
        if (key != null && MaidConfig.MAID_BACKPACK_BLACKLIST.get().contains(key.toString())) {
            return false;
        }
        return stack.method_7909().method_31568();
    }

    public static class_2940<ChatBubbleDataCollection> getChatBubbleKey() {
        return CHAT_BUBBLE;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);

        builder.method_56912(DATA_IS_YSM_MODEL, false);
        builder.method_56912(DATA_YSM_MODEL_ID, StringUtils.EMPTY);
        builder.method_56912(DATA_YSM_MODEL_TEXTURE, StringUtils.EMPTY);
        builder.method_56912(DATA_YSM_MODEL_NAME, class_2561.method_43473());

        builder.method_56912(DATA_MODEL_ID, DEFAULT_MODEL_ID);
        builder.method_56912(DATA_SOUND_PACK_ID, DefaultMaidSoundPack.getInitSoundPackId());
        builder.method_56912(DATA_TASK, TaskIdle.UID.toString());
        builder.method_56912(DATA_BEGGING, false);
        builder.method_56912(DATA_INVULNERABLE, false);
        builder.method_56912(DATA_HUNGER, 0);
        builder.method_56912(DATA_FAVORABILITY, 0);
        builder.method_56912(DATA_EXPERIENCE, 0);
        builder.method_56912(DATA_STRUCK_BY_LIGHTNING, false);
        builder.method_56912(DATA_IS_CHARGING_CROSSBOW, false);
        builder.method_56912(DATA_ARM_RISE, false);
        builder.method_56912(SCHEDULE_MODE, MaidSchedule.DAY);
        builder.method_56912(RESTRICT_CENTER, class_2338.field_10980);
        builder.method_56912(RESTRICT_RADIUS, MaidConfig.MAID_NON_HOME_RANGE.get().floatValue());
        builder.method_56912(CHAT_BUBBLE, ChatBubbleDataCollection.getEmptyCollection());
        builder.method_56912(BACKPACK_TYPE, EmptyBackpack.ID.toString());
        builder.method_56912(BACKPACK_ITEM_SHOW, class_1799.field_8037);
        builder.method_56912(BACKPACK_FLUID, StringUtils.EMPTY);
        builder.method_56912(TASK_DATA_SYNC, new class_2487());

        // 父类构造方法调用此类，就会出现这种初始化混乱的问题
        if (this.configManager == null) {
            this.configManager = new MaidConfigManager(this.field_6011);
        }
        this.configManager.defineSynchedData(builder);
        if (this.gameRecordManager == null) {
            this.gameRecordManager = new MaidGameRecordManager(this);
        }
        this.gameRecordManager.defineSynchedData(builder);
    }

    @Override
    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (this.field_6002.field_9236 && TASK_DATA_SYNC.equals(key)) {
            this.taskDataMaps.readFromServer(this.getSyncTaskData());
        }
    }

    /**
     * 获取注册的数据
     */
    @Nullable
    public <T> T getData(TaskDataKey<T> dataKey) {
        return this.taskDataMaps.getData(dataKey);
    }

    /**
     * 创建或获取注册的数据
     */
    public <T> T getOrCreateData(TaskDataKey<T> dataKey, T defaultValue) {
        return this.taskDataMaps.getOrCreateData(dataKey, defaultValue);
    }

    /**
     * 设置数据
     */
    public <T> void setData(TaskDataKey<T> dataKey, T value) {
        this.taskDataMaps.setData(dataKey, value);
    }

    /**
     * 设置数据，并将其同步到客户端
     */
    public <T> void setAndSyncData(TaskDataKey<T> dataKey, T value) {
        this.setData(dataKey, value);
        this.syncTaskDataMaps = true;
    }

    @Override
    protected class_1408 method_5965(class_1937 levelIn) {
        return new MaidPathNavigation(this, levelIn);
    }

    @Override
    @SuppressWarnings("all")
    public class_4095<EntityMaid> method_18868() {
        return (class_4095<EntityMaid>) super.method_18868();
    }

    @Override
    protected class_4095.class_5303<EntityMaid> method_28306() {
        return class_4095.method_28311(MaidBrain.getMemoryTypes(), MaidBrain.getSensorTypes());
    }

    @Override
    protected class_4095<?> method_18867(Dynamic<?> dynamicIn) {
        class_4095<EntityMaid> brain = this.method_28306().method_28335(dynamicIn);
        MaidBrain.registerBrainGoals(brain, this);
        return brain;
    }

    public void refreshBrain(class_3218 serverWorldIn) {
        class_4095<EntityMaid> brain = this.method_18868();
        brain.method_18900(serverWorldIn, this);
        this.field_18321 = brain.method_18911();
        MaidBrain.registerBrainGoals(this.method_18868(), this);
    }

    @Override
    protected void method_5958() {
        long timeRecord = class_156.method_648();
        this.field_6002.method_16107().method_15396("maidBrain");
        if (!guiOpening) {
            this.method_18868().method_19542((class_3218) this.field_6002, this);
        }
        this.field_6002.method_16107().method_15407();
        timeRecord = class_156.method_648() - timeRecord;
        if (MAID_AI_TIME_DEBUG.get() && timeRecord > WARNING_TIME_NANOS) {
            double timeMs = timeRecord / 1000000.0;
            class_2338 blockPos = this.method_24515();
            String taskId = this.getTask().getUid().toString();
            int searchRange = Math.round(this.method_18413());

            TouhouLittleMaid.LOGGER.error("Maid's AI taking too long! Time: {} ms, Pos: ({},{},{}), Task ID: {}, Search Range: {}",
                    timeMs, blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), taskId, searchRange);
        }
        super.method_5958();
    }

    @Override
    public void method_5773() {
        MaidTickEvent maidTickEvent = new MaidTickEvent(this);
        MaidTickEvent.CALLBACK.invoker().post(maidTickEvent);
        if (!maidTickEvent.isCanceled()) {
            super.method_5773();
            maidBauble.fireEvent((b, s) -> {
                b.onTick(this, s);
                return false;
            });
        }
        if (YsmCompat.isInstalled() && this.isYsmModel()) {
            if (field_6002.field_9236) {
                // 触发 ysm 模型的客户端事件
                YsmMaidClientTickEvent.CALLBACK.invoker().post(new YsmMaidClientTickEvent(this));
            }
            // 同步 ysm 轮盘数据
            if (!field_6002.field_9236 && this.rouletteAnimDirty) {
                this.rouletteAnimDirty = false;
                SyncYsmMaidDataPackage message = new SyncYsmMaidDataPackage(this.method_5628(), this.rouletteAnim, this.rouletteAnimPlaying, this.roamingVars);
                for (class_3222 player : PlayerLookup.tracking(this)) {
                    ServerPlayNetworking.send(player, message);
                }
            }
        }
    }

    @Override
    public void method_5670() {
        super.method_5670();
        if (backpackDelay > 0) {
            backpackDelay--;
        }
        if (playerHurtSoundCount > 0) {
            playerHurtSoundCount--;
        }
        if (climbFallDelayTicks > 0) {
            climbFallDelayTicks--;
            this.field_6017 = 0;
        }
        this.spawnPortalParticle();
        this.randomRestoreHealth();
        this.onMaidSleep();
        this.syncData();
        this.gameRecordManager.tick();
    }

    @Override
    public void method_5842() {
        super.method_5842();
        class_1297 vehicle = this.method_5854();
        if (vehicle != null && !vehicle.method_5864().method_20210(EntityTypeGenerator.MAID_VEHICLE_ROTATE_BLOCKLIST)) {
            this.method_5847(vehicle.method_36454());
            this.method_5636(vehicle.method_36454());
        }
    }

    /**
     * 把数据同步到客户端
     */
    private void syncData() {
        if (!this.field_6002.field_9236 && this.syncTaskDataMaps) {
            this.setSyncTaskData(this.taskDataMaps.getUpdateTag());
            this.syncTaskDataMaps = false;
        }
    }

    private void onMaidSleep() {
        if (method_6113()) {
            method_18398().ifPresent(pos -> method_5814(pos.method_10263() + 0.5, pos.method_10264() + 0.5625, pos.method_10260() + 0.5));
            method_18799(class_243.field_1353);
            if (!method_5701()) {
                this.method_5803(true);
            }
        } else {
            if (method_5701()) {
                this.method_5803(false);
            }
        }
    }

    @Override
    public void method_6007() {
        super.method_6007();
        this.method_6119();
        this.navigationManager.tick();
        if (!field_6002.field_9236) {
            this.chatBubbleManager.tick();
            if (this.backpackData != null) {
                this.field_6002.method_16107().method_15396("maidBackpackData");
                this.backpackData.serverTick(this);
                this.field_6002.method_16107().method_15407();
            }

            this.field_6002.method_16107().method_15396("maidFavorability");
            this.favorabilityManager.tick();
            this.field_6002.method_16107().method_15407();

            this.field_6002.method_16107().method_15396("maidSchedulePos");
            this.schedulePos.tick(this);
            this.field_6002.method_16107().method_15407();

            this.field_6002.method_16107().method_15396("maidCooldowns");
            this.cooldowns.method_7903();
            if (this.passiveUseShieldTick > 0) {
                this.passiveUseShieldTick--;
                // 最后 1 tick 取消盾牌
                if (this.passiveUseShieldTick == 1 && this.method_6115() && this.method_6058() == class_1268.field_5810) {
                    this.method_6021();
                }
            }
            this.field_6002.method_16107().method_15407();
        }
    }

    @Override
    public class_1269 method_5992(class_1657 playerIn, class_1268 hand) {
        // 禁止 fake player 交互女仆
        if (playerIn instanceof FakePlayer) {
            return class_1269.field_5811;
        }
        if (hand == class_1268.field_5808 && method_6171(playerIn)) {
            class_1799 stack = playerIn.method_6047();
            InteractMaidEvent event = new InteractMaidEvent(playerIn, this, stack);
            InteractMaidEvent.CALLBACK.invoker().post(event);
            // 利用短路原理，逐个触发对应的交互事件
            if (event.isCanceled()
                    || stack.method_7920(playerIn, this, hand).method_23665()
                    || openMaidGui(playerIn)) {
                return class_1269.field_5812;
            }
        } else {
            return tameMaid(playerIn.method_5998(hand), playerIn);
        }
        return class_1269.field_5811;
    }

    private class_1269 tameMaid(class_1799 stack, class_1657 player) {
        MaidNumAttachment cap = player.getAttached(MAID_NUM);
        if (cap.canAdd() || player.method_7337()) {
            boolean isNormal = !method_6181() && getTamedItem().method_8093(stack);
            boolean isNtr = getNtrItem().method_8093(stack);
            if (isNormal || isNtr) {
                if (!player.method_7337()) {
                    stack.method_7934(1);
                    cap.add();
                }
                this.method_6170(player);
                // 清掉寻路，清掉敌对记忆
                this.field_6189.method_6340();
                this.method_5980(null);
                this.field_18321.method_18875(class_4140.field_22355);
                this.field_6002.method_8421(this, class_6024.field_30032);
                this.method_5783(InitSounds.MAID_TAMED, 1, 1);
                if (player instanceof class_3222 serverPlayer) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.TAMED_MAID);
                    if (this.isStructureSpawn()) {
                        InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.TAMED_MAID_FROM_STRUCTURE);
                    }
                }
                // 触发事件
                MaidTamedEvent.CALLBACK.invoker().onMaidTamed(new MaidTamedEvent(this, player, isNtr));
                return class_1269.field_5812;
            }
        } else {
            if (player instanceof class_3222) {
                class_5250 msg = class_2561.method_43469("message.touhou_little_maid.owner_maid_num.can_not_add",
                        cap.get(), cap.getMaxNum());
                player.method_43496(msg);
            }
        }
        return class_1269.field_5811;
    }

    @Override
    protected void method_6070() {
        super.method_6070();
        // 只有拾物模式开启，驯服状态下才可以捡起物品
        if (this.isPickup() && this.method_6181()) {
            List<class_1297> entityList = this.field_6002.method_8333(this,
                    this.method_5829().method_1009(0.5, 0, 0.5), this::canPickup);
            if (!entityList.isEmpty() && this.method_5805()) {
                for (class_1297 entityPickup : entityList) {
                    // 如果是物品
                    if (entityPickup instanceof class_1542) {
                        pickupItem((class_1542) entityPickup, false);
                    }
                    // 如果是经验
                    if (entityPickup instanceof class_1303) {
                        pickupXPOrb((class_1303) entityPickup);
                    }
                    // 如果是 P 点
                    if (entityPickup instanceof EntityPowerPoint) {
                        pickupPowerPoint((EntityPowerPoint) entityPickup);
                    }
                    // 如果是箭
                    if (entityPickup instanceof class_1665) {
                        pickupArrow((class_1665) entityPickup, false);
                    }
                }
            }
        }
    }

    public boolean pickupItem(class_1542 entityItem, boolean simulate) {
        MaidPickupEvent.ItemResultPre resultPre = new MaidPickupEvent.ItemResultPre(this, entityItem, simulate);
        MaidPickupEvent.ITEM_RESULT_PRE.invoker().onItemResultPre(resultPre);
        if (resultPre.isCanceled()) {
            return resultPre.isCanPickup();
        }
        if (!field_6002.field_9236 && entityItem.method_5805() && !entityItem.method_6977()) {
            // 获取实体的物品堆
            class_1799 itemstack = entityItem.method_6983();
            // 检查物品是否合法
            if (!canInsertItem(itemstack)) {
                return false;
            }
            // 获取数量，为后面方面用
            int count = itemstack.method_7947();
            itemstack = ItemHandlerHelper.insertItemStacked(getAvailableInv(false), itemstack, simulate);
            if (count == itemstack.method_7947()) {
                return false;
            }
            if (!simulate) {
                // 这是向客户端同步数据用的，如果加了这个方法，会有短暂的拾取动画和音效
                this.method_6103(entityItem, count - itemstack.method_7947());
                MaidPlaySoundEvent event = new MaidPlaySoundEvent(this);
                MaidPlaySoundEvent.CALLBACK.invoker().post(event);
                if (!event.isCanceled()) {
                    pickupSoundCount--;
                    if (pickupSoundCount == 0) {
                        this.method_5783(InitSounds.MAID_ITEM_GET, 1, 1);
                        pickupSoundCount = 5;
                    }
                }
                class_1799 copy = new class_1799(itemstack.method_7909(), count - itemstack.method_7947());
                // 如果遍历塞完后发现为空了
                if (itemstack.method_7960()) {
                    // 清除这个实体
                    entityItem.method_31472();
                } else {
                    // 将物品数量同步到客户端
                    entityItem.method_6979(itemstack);
                }
                MaidPickupEvent.ITEM_RESULT_POST.invoker().onItemResultPost(new MaidPickupEvent.ItemResultPost(this, copy));
            }
            return true;
        }
        return false;
    }

    public void pickupXPOrb(class_1303 entityXPOrb) {
        MaidPickupEvent.ExperienceResult expResult = new MaidPickupEvent.ExperienceResult(this, entityXPOrb, false);
        MaidPickupEvent.EXPERIENCE_RESULT.invoker().onExperienceResult(expResult);
        if (expResult.isCanceled()) {
            return;
        }
        if (!this.field_6002.field_9236 && entityXPOrb.method_5805() && entityXPOrb.field_6012 > 2) {
            // 这是向客户端同步数据用的，如果加了这个方法，会有短暂的拾取动画和音效
            this.method_6103(entityXPOrb, 1);
            MaidPlaySoundEvent event = new MaidPlaySoundEvent(this);
            MaidPlaySoundEvent.CALLBACK.invoker().post(event);
            if (!event.isCanceled()) {
                pickupSoundCount--;
                if (pickupSoundCount == 0) {
                    this.method_5783(InitSounds.MAID_ITEM_GET, 1, 1);
                    pickupSoundCount = 5;
                }
            }

            // 对经验修补的应用，因为全部来自于原版，所以效果也是相同的
            IItemHandler allItems = new CombinedInvWrapper(armorInvWrapper, handsInvWrapper, maidBauble);
            class_1799 itemstack = this.getRandomItemWithMendingEnchantments(allItems);
            if (!itemstack.method_7960() && itemstack.method_7986()) {
                int i = Math.min((int) (entityXPOrb.method_5919() /** itemstack.getXpRepairRatio()*/), itemstack.method_7919());
                ((ExperienceOrbAccessor) entityXPOrb).setValue((entityXPOrb.method_5919() - i / 2));
                itemstack.method_7974(itemstack.method_7919() - i);
            }
            if (entityXPOrb.method_5919() > 0) {
                this.setExperience(getExperience() + entityXPOrb.method_5919());
            }
            entityXPOrb.method_31472();
        }
    }

    public void pickupPowerPoint(EntityPowerPoint powerPoint) {
        MaidPickupEvent.PowerPointResult pointResult = new MaidPickupEvent.PowerPointResult(this, powerPoint, false);
        MaidPickupEvent.POWERPOINT_RESULT.invoker().onPowerPointResult(pointResult);
        if (pointResult.isCanceled()) {
            return;
        }
        if (!this.field_6002.field_9236 && powerPoint.method_5805() && powerPoint.throwTime == 0) {
            // 这是向客户端同步数据用的，如果加了这个方法，会有短暂的拾取动画和音效
            powerPoint.take(this, 1);
            MaidPlaySoundEvent event = new MaidPlaySoundEvent(this);
            MaidPlaySoundEvent.CALLBACK.invoker().post(event);
            if (!event.isCanceled()) {
                pickupSoundCount--;
                if (pickupSoundCount == 0) {
                    this.method_5783(InitSounds.MAID_ITEM_GET, 1, 1);
                    pickupSoundCount = 5;
                }
            }

            // 对经验修补的应用，因为全部来自于原版，所以效果也是相同的
            CombinedInvWrapper allItems = this.getAllInv();
            class_1799 itemstack = this.getRandomItemWithMendingEnchantments(allItems);
            int xpValue = EntityPowerPoint.transPowerValueToXpValue(powerPoint.getValue());
            if (!itemstack.method_7960() && itemstack.method_7986()) {
                int i = Math.min((int) (xpValue /** itemstack.getXpRepairRatio()*/), itemstack.method_7919());
                xpValue -= (i / 2);
                itemstack.method_7974(itemstack.method_7919() - i);
            }
            if (xpValue > 0) {
                this.setExperience(getExperience() + xpValue);
            }
            powerPoint.method_31472();
        }
    }

    private class_1799 getRandomItemWithMendingEnchantments(IItemHandler handler) {
        class_5455 access = this.field_6002.method_30349();
        List<class_1799> stacks = Lists.newArrayList();
        for (int i = 0; i < handler.getSlots(); i++) {
            class_1799 stackInSlot = handler.getStackInSlot(i);
            if (!stackInSlot.method_7960() && getEnchantmentLevel(access, class_1893.field_9101, stackInSlot) > 0
                    && stackInSlot.method_7986() && !stackInSlot.method_31573(TagItem.MAID_MENDING_BLOCKLIST_ITEM)) {
                stacks.add(stackInSlot);
            }
        }
        return stacks.isEmpty() ? class_1799.field_8037 : stacks.get(this.method_59922().method_43048(stacks.size()));
    }

    public boolean pickupArrow(class_1665 arrow, boolean simulate) {
        MaidPickupEvent.ArrowResult arrowResult = new MaidPickupEvent.ArrowResult(this, arrow, simulate);
        MaidPickupEvent.ARROW_RESULT.invoker().onArrowResult(arrowResult);
        if (arrowResult.isCanceled()) {
            return arrowResult.isCanPickup();
        }
        if (!this.field_6002.field_9236 && arrow.method_5805() && arrow.field_7574 <= 0) {
            // 先判断箭是否处于可以拾起的状态
            if (arrow.field_7572 != class_1665.class_1666.field_7593) {
                return false;
            }
            // 能够塞入
            class_1799 stack = getArrowFromEntity(arrow);
            if (stack.method_7960()) {
                return false;
            }
            if (!ItemHandlerHelper.insertItemStacked(getAvailableInv(false), stack, simulate).method_7960()) {
                return false;
            }
            // 非模拟状态下，清除实体箭
            if (!simulate) {
                // 这是向客户端同步数据用的，如果加了这个方法，会有短暂的拾取动画和音效
                this.method_6103(arrow, 1);
                MaidPlaySoundEvent event = new MaidPlaySoundEvent(this);
                MaidPlaySoundEvent.CALLBACK.invoker().post(event);
                if (!event.isCanceled()) {
                    pickupSoundCount--;
                    if (pickupSoundCount == 0) {
                        this.method_5783(InitSounds.MAID_ITEM_GET, 1, 1);
                        pickupSoundCount = 5;
                    }
                }
                arrow.method_31472();
            }
            return true;
        }
        return false;
    }

    private class_1799 getArrowFromEntity(class_1665 entity) {
        if (entity instanceof ArrowAccessor mixinArrow) {
            if (mixinArrow.tlmInGround() || entity.method_7441()) {
                return mixinArrow.getTlmPickupItem();
            }
        }
        return class_1799.field_8037;
    }

    @Override
    public boolean method_42150(class_1309 target) {
        int attackPlusDistance = this.favorabilityManager.getAttackDistancePlusByPoint(this.getFavorability());
        double attackDistance = this.method_45325(class_5134.field_47759) + attackPlusDistance;
        return this.method_5739(target) < attackDistance;
    }

    @Override
    public boolean method_6121(class_1297 target) {
        boolean result = super.method_6121(target);
        if (result) {
            doSweepHurt(target);
        }
        this.method_6047().method_7970(1, this, class_1304.field_6173);
        if (this.getTask() instanceof IAttackTask attackTask && attackTask.hasExtraAttack(this, target)) {
            boolean extraResult = attackTask.doExtraAttack(this, target);
            return result && extraResult;
        }
        return result;
    }

    private void doSweepHurt(class_1297 target) {
        class_1799 mainhandItem = this.method_5998(class_1268.field_5808);
        //boolean canSweep = mainhandItem.canPerformAction(ItemAbilities.SWORD_SWEEP);
        boolean canSweep = EnchantmentUtil.canEnchant(mainhandItem, class_1893.field_9115, this.method_56673());
        float sweepingDamageRatio = (float) this.method_6127().method_26852(class_5134.field_51577);
        if (canSweep && sweepingDamageRatio > 0) {
            float baseDamage = (float) this.method_45325(class_5134.field_23721);
            float sweepDamage = 1.0f + sweepingDamageRatio * baseDamage;
            class_238 sweepRange = this.getFavorabilityManager().getSweepRange(target, this.getFavorability());
            List<class_1309> hurtEntities = this.field_6002.method_18467(class_1309.class, sweepRange);
            for (class_1309 entity : hurtEntities) {
                if (entity != this && entity != target && !this.method_5722(entity) && method_18395(entity) && method_5973(entity.method_5864())) {
                    float posX = class_3532.method_15374(this.method_36454() * ((float) Math.PI / 180F));
                    float posY = -class_3532.method_15362(this.method_36454() * ((float) Math.PI / 180F));
                    entity.method_6005(0.4, posX, posY);
                    entity.method_5643(this.method_48923().method_48812(this), sweepDamage);
                }
            }
            this.field_6002.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14706, this.method_5634(), 1, 1);
            this.spawnSweepAttackParticle();
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        MaidAttackEvent event = new MaidAttackEvent(this, source, amount);
        MaidAttackEvent.CALLBACK.invoker().post(event);
        if (event.isCanceled()) {
            return false;
        }
        if (source.method_5529() instanceof class_1657 player && this.method_5722(player)) {
            // 主人和同 Team 玩家对自己女仆的伤害数值为 1/5，最大为 2
            amount = class_3532.method_15363(amount / 5, 0, 2);
            return super.method_5643(source, amount);
        }
        // 使用盾牌
        if (source.method_48789(class_8103.field_42247) && this.canUseShield()) {
            boolean isUsingShield = this.method_6115() && this.method_6058() == class_1268.field_5810;
            if (!isUsingShield) {
                this.method_6019(class_1268.field_5810);
                // 使用五秒的盾牌
                this.passiveUseShieldTick = 100;
            }
        }
        return super.method_5643(source, amount);
    }

    /**
     * 重新复写父类方法，添加上自己的 Event
     */
    @Override
    @SuppressWarnings("UnstableApiUsage")
    protected void method_6074(class_1282 damageSrc, float damageAmount) {
        if (!this.method_5679(damageSrc) /*&& this.damageContainers != null*/) {
            //DamageContainer peek = this.damageContainers.peek();

            // 获取盔甲减伤后的数值
            float armorAbsorb = this.method_6132(damageSrc, damageAmount/*peek.getNewDamage()*/);
            // peek.setReduction(DamageContainer.Reduction.ARMOR, peek.getNewDamage() - armorAbsorb);

            // 获取抗性提升减伤后的数值
            //this.getDamageAfterMagicAbsorb(damageSrc, peek.getNewDamage());
            float magicAbsorb = this.method_6036(damageSrc, armorAbsorb);

            // 获取事件减伤效果
            MaidHurtEvent maidHurtEvent = new MaidHurtEvent(this, damageSrc, magicAbsorb /*peek.getNewDamage()*/);
            MaidHurtEvent.CALLBACK.invoker().post(maidHurtEvent);
            damageAmount = maidHurtEvent.isCanceled() ? 0 : maidHurtEvent.getAmount();
            //peek.setReduction(DamageContainer.Reduction.ABSORPTION, peek.getNewDamage() - damageAmount);

/*            // NeoForge 事件也来一套
            float damage = onLivingDamagePre(this, peek);
            peek.setReduction(DamageContainer.Reduction.ABSORPTION, Math.min(this.getAbsorptionAmount(), damage));*/

            // 总减伤效果，用于玩家信息统计
            //float damageDealtAbsorbed = Math.min(damage, peek.getReduction(DamageContainer.Reduction.ABSORPTION));
            //this.setAbsorptionAmount(Math.max(0, this.getAbsorptionAmount() - damageDealtAbsorbed));
            float f = damageAmount;
            damageAmount = Math.max(damageAmount - this.method_6067(), 0.0F);
            this.method_6073(this.method_6067() - (f - damageAmount));
            float damageDealtAbsorbed = f - damageAmount;
            if (0 < damageDealtAbsorbed && damageDealtAbsorbed < 3.5 && damageSrc.method_5529() instanceof class_3222 player) {
                player.method_7339(class_3468.field_15408, Math.round(damageDealtAbsorbed * 10));
            }

            // 再来一次事件
            //float damageAfterAbsorption = peek.getNewDamage();
            float damageAfterAbsorption = damageAmount;
            MaidDamageEvent maidDamageEvent = new MaidDamageEvent(this, damageSrc, damageAfterAbsorption /*damageAfterAbsorption*/);
            MaidDamageEvent.CALLBACK.invoker().post(maidDamageEvent);
            damageAfterAbsorption = maidDamageEvent.isCanceled() ? 0 : maidDamageEvent.getAmount();

            // 最终运用实际伤害
            if (damageAfterAbsorption != 0) {
                this.method_6066().method_5547(damageSrc, damageAfterAbsorption);
                this.method_6033(this.method_6032() - damageAfterAbsorption);
                // fabric：按原版写（
                this.method_6073(this.method_6067() - damageAfterAbsorption);
                this.method_32876(class_5712.field_28736);
                //this.onDamageTaken(peek);
            }

/*            // NeoForge 事件也来一套
            onLivingDamagePost(this, peek);*/
        }
    }

    @Nullable
    @Override
    public class_1297 method_5731(class_5454 pTransition) {
        if (this.field_6002 instanceof class_3218 && !this.method_31481()) {
            final int MAX_RETRY = 16;
            for (int i = 0; i < MAX_RETRY; ++i) {
                if (TeleportHelper.teleport(this)) {
                    this.method_6092(new class_1293(class_1294.field_5912, 200, 1, true, false));
                }
            }
        }
        return null;
    }

    @Override
    public final boolean isAddedToLevel() {
        return this.isAddedToLevel;
    }

    @Override
    public void onAddedToLevel() {
        this.isAddedToLevel = true;
        if (this.method_6139() != null) {
            MaidWorldData data = MaidWorldData.get(this.field_6002);
            if (data != null) {
                data.removeInfo(this);
            }
        }

    }

    @Override
    public void onRemovedFromLevel() {
        this.isAddedToLevel = false;
        if (!this.field_6002.field_9236 && this.method_5805() && this.method_6139() != null) {
            MaidWorldData data = MaidWorldData.get(this.field_6002);
            if (data != null) {
                data.addInfo(this);
            }
        }
    }

    @Override
    public void method_6078(class_1282 cause) {
        MaidDeathEvent event = new MaidDeathEvent(this, cause);
        MaidDeathEvent.CALLBACK.invoker().post(event);
        if (!event.isCanceled()) {
            // 清除死亡时需要清除的内容
            this.method_5646();
            this.method_32317(0);
            this.method_33572(false);
            this.method_6066().method_5539();
            this.method_6012();
            // 最后父类方法
            super.method_6078(cause);
        }
    }

    public boolean canPickup(class_1297 pickupEntity, boolean checkInWater) {
        if (isPickup()) {
            if (checkInWater && pickupEntity.method_5799()) {
                return false;
            }
            PickType pickupType = this.configManager.getPickupType();
            if (pickupType.canPickItem() && pickupEntity instanceof class_1542) {
                return pickupItem((class_1542) pickupEntity, true);
            }
            if (pickupType.canPickItem() && pickupEntity instanceof class_1665) {
                return pickupArrow((class_1665) pickupEntity, true);
            }
            if (pickupType.canPickXp() && pickupEntity instanceof class_1303) {
                return true;
            }
            return pickupType.canPickXp() && pickupEntity instanceof EntityPowerPoint;
        }
        return false;
    }

    public boolean canPickup(class_1297 pickupEntity) {
        return canPickup(pickupEntity, false);
    }

    @Override
    public void method_7110(boolean isCharging) {
        this.field_6011.method_12778(DATA_IS_CHARGING_CROSSBOW, isCharging);
    }

    @Override
    public void method_24651() {
        this.field_6278 = 0;
    }

    @Override
    @Nullable
    public class_1309 method_5968() {
        // 实现 CrossbowAttackMob 接口中拿到目标实体的方法
        return this.field_18321.method_18904(class_4140.field_22355).orElse(null);
    }

    // 弩在装载时的 tryLoadProjectiles 方法会从这里拿到需要装填的物品
    @Override
    public class_1799 method_18808(class_1799 weaponStack) {
        // 烟花只检查副手：优先检查副手有没有烟花
        if (this.method_6079().method_7909() instanceof class_1781) {
            return this.method_6079();
        }
        if (!(this.method_6047().method_7909() instanceof class_1811 weaponItem)) {
            return class_1799.field_8037;
        }
        CombinedInvWrapper handler = this.getAvailableInv(true);
        int slot = ItemsUtil.findStackSlot(handler, weaponItem.method_19268());
        if (slot < 0) {
            // 不存在时，返回空
            return class_1799.field_8037;
        } else {
            // 拿到弹药物品
            return handler.getStackInSlot(slot);
        }
    }

    @Override
    public void method_5800(class_3218 world, class_1538 lightning) {
        super.method_5800(world, lightning);
        if (!isStruckByLightning()) {
            double beforeMaxHealth = this.method_45326(class_5134.field_23716);
            Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(beforeMaxHealth + 20);
            setStruckByLightning(true);
            if (this.method_35057() instanceof class_3222 serverPlayer) {
                InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.LIGHTNING_BOLT);
                if (this.method_6063() >= 100) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.MAID_100_HEALTHY);
                }
            }
        }
    }

    @Override
    public void method_6105(class_1282 damageSource, float damage) {
        this.method_57292(damageSource, damage, class_1304.field_6166, class_1304.field_6172, class_1304.field_6174, class_1304.field_6169);
    }

    @Override
    public void method_7105(class_1309 target, float distanceFactor) {
        IMaidTask maidTask = this.getTask();
        if (maidTask instanceof IRangedAttackTask rangedAttackTask) {
            rangedAttackTask.performRangedAttack(this, target, distanceFactor);
        }
    }

    @Override
    public boolean method_5973(class_1299<?> typeIn) {
        return typeIn != class_1299.field_6131;
    }

    @Override
    public boolean method_18395(class_1309 target) {
        if (this.getTask() instanceof IAttackTask attackTask) {
            return attackTask.canAttack(this, target);
        }
        return super.method_18395(target);
    }

    /**
     * 用于物品的耐久损失
     */
    public void hurtAndBreak(class_1799 stack, int amount) {
        if (this.field_6002 instanceof class_3218 serverLevel) {
            stack.method_7956(amount, serverLevel, null/*this*/, stackIn -> NetworkHandler.sendToNearby(this, new ItemBreakPackage(this.method_5628(), stackIn.method_7854())));
        }
    }

    private void randomRestoreHealth() {
        if (this.method_6032() < this.method_6063() && field_5974.method_43057() < 0.0025) {
            this.method_6025(1);
            this.spawnRestoreHealthParticle(field_5974.method_43048(3) + 7);
        }
    }

    private void spawnPortalParticle() {
        if (this.field_6002.field_9236 && this.getIsInvulnerable() && MiscConfig.INVULNERABLE_PARTICLE_EFFECT.get() && this.method_35057() != null) {
            this.field_6002.method_8406(class_2398.field_11214,
                    this.method_23317() + (this.field_5974.method_43058() - 0.5D) * (double) this.method_17681(),
                    this.method_23318() + this.field_5974.method_43058() * (double) this.method_17682() - 0.25D,
                    this.method_23321() + (this.field_5974.method_43058() - 0.5D) * (double) this.method_17681(),
                    (this.field_5974.method_43058() - 0.5D) * 2.0D, -this.field_5974.method_43058(),
                    (this.field_5974.method_43058() - 0.5D) * 2.0D);
        }
    }

    public void spawnRestoreHealthParticle(int particleCount) {
        if (this.field_6002.field_9236) {
            for (int i = 0; i < particleCount; ++i) {
                double xRandom = this.field_5974.method_43059() * 0.02D;
                double yRandom = this.field_5974.method_43059() * 0.02D;
                double zRandom = this.field_5974.method_43059() * 0.02D;

                this.field_6002.method_8406(class_9381.method_58255(class_2398.field_11226, 0.9f, 0.1f, 0.1f),
                        this.method_23317() + (double) (this.field_5974.method_43057() * this.method_17681() * 2.0F) - (double) this.method_17681() - xRandom * 10.0D,
                        this.method_23318() + (double) (this.field_5974.method_43057() * this.method_17682()) - yRandom * 10.0D,
                        this.method_23321() + (double) (this.field_5974.method_43057() * this.method_17681() * 2.0F) - (double) this.method_17681() - zRandom * 10.0D,
                        0, 0, 0);
            }
        }
    }

    public void spawnExplosionParticle() {
        if (this.field_6002.field_9236) {
            for (int i = 0; i < 20; ++i) {
                float mx = (field_5974.method_43057() - 0.5F) * 0.02F;
                float my = (field_5974.method_43057() - 0.5F) * 0.02F;
                float mz = (field_5974.method_43057() - 0.5F) * 0.02F;
                field_6002.method_8406(class_2398.field_11204,
                        method_23317() + field_5974.method_43057() - 0.5F,
                        method_23318() + field_5974.method_43057() - 0.5F,
                        method_23321() + field_5974.method_43057() - 0.5F,
                        mx, my, mz);
            }
        }
    }

    public void spawnBubbleParticle() {
        if (this.field_6002.field_9236) {
            for (int i = 0; i < 8; ++i) {
                double offsetX = 2 * field_5974.method_43058() - 1;
                double offsetY = field_5974.method_43058() / 2;
                double offsetZ = 2 * field_5974.method_43058() - 1;
                field_6002.method_8406(class_2398.field_11247, method_23317() + offsetX, method_23318() + offsetY, method_23321() + offsetZ,
                        0, 0.1, 0);
            }
        }
    }

    public void spawnHeartParticle() {
        if (this.field_6002.field_9236) {
            for (int i = 0; i < 8; ++i) {
                double offsetX = this.field_5974.method_43059() * 0.02;
                double offsetY = this.field_5974.method_43059() * 0.02;
                double offsetZ = this.field_5974.method_43059() * 0.02;
                field_6002.method_8406(class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), offsetX, offsetY, offsetZ);
            }
        }
    }

    @Environment(EnvType.CLIENT)
    public void spawnRankUpParticle() {
        if (this.field_6002.field_9236) {
            class_310 minecraft = class_310.method_1551();
            minecraft.field_1713.method_3051(this, class_2398.field_11220, 30);
            this.field_6002.method_8486(this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_17265, this.method_5634(), 1.0F, 1.0F, false);
            minecraft.field_1705.method_34004(class_2561.method_43471("message.touhou_little_maid.gomoku.rank_up.title"));
            minecraft.field_1705.method_34002(class_2561.method_43471("message.touhou_little_maid.gomoku.rank_up.subtitle"));
        }
    }

    private void spawnSweepAttackParticle() {
        double xOffset = -class_3532.method_15374(this.method_36454() * ((float) Math.PI / 180F));
        double zOffset = class_3532.method_15362(this.method_36454() * ((float) Math.PI / 180F));
        if (this.field_6002 instanceof class_3218 serverLevel) {
            serverLevel.method_14199(class_2398.field_11227,
                    this.method_23317() + xOffset, this.method_23323(0.5),
                    this.method_23321() + zOffset, 0, xOffset, 0, zOffset, 0);
        }
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582(MODEL_ID_TAG_NAME, getModelId());

        compound.method_10556(IS_YSM_MODEL_TAG, isYsmModel());
        compound.method_10582(YSM_MODEL_ID_TAG, getYsmModelId());
        compound.method_10582(YSM_MODEL_TEXTURE_TAG, getYsmModelTexture());
        compound.method_10582(YSM_MODEL_NAME_TAG, class_2561.class_2562.method_10867(getYsmModelName(), this.method_56673()));
        compound.method_10582(YSM_ROULETTE_ANIM_TAG, rouletteAnim);
        compound.method_10569(YSM_ROAMING_UPDATE_FLAG_TAG, roamingVarsUpdateFlag);

        class_2487 roamingVarsTag = new class_2487();
        roamingVars.forEach(roamingVarsTag::method_10548);
        compound.method_10566(YSM_ROAMING_VARS_TAG, roamingVarsTag);

        compound.method_10582(SOUND_PACK_ID_TAG, getSoundPackId());
        compound.method_10582(TASK_TAG, getTask().getUid().toString());
        compound.method_10566(MAID_INVENTORY_TAG, maidInv.serializeNBT(this.method_56673()));
        compound.method_10566(MAID_BAUBLE_INVENTORY_TAG, maidBauble.serializeNBT(this.method_56673()));
        compound.method_10566(MAID_HIDE_INVENTORY_TAG, hideInv.serializeNBT(this.method_56673()));
        compound.method_10566(MAID_TASK_INVENTORY_TAG, taskInv.serializeNBT(this.method_56673()));
        compound.method_10556(STRUCK_BY_LIGHTNING_TAG, isStruckByLightning());
        compound.method_10556(INVULNERABLE_TAG, getIsInvulnerable());
        compound.method_10569(HUNGER_TAG, getHunger());
        compound.method_10569(FAVORABILITY_TAG, getFavorability());
        compound.method_10569(EXPERIENCE_TAG, getExperience());
        compound.method_10582(SCHEDULE_MODE_TAG, getSchedule().name());
        compound.method_10582(MAID_BACKPACK_TYPE, getMaidBackpackType().getId().toString());
        compound.method_10556(STRUCTURE_SPAWN_TAG, this.structureSpawn);
        this.configManager.addAdditionalSaveData(compound);
        this.gameRecordManager.addAdditionalSaveData(compound);
        this.favorabilityManager.addAdditionalSaveData(compound);
        this.schedulePos.save(compound);
        if (this.backpackData != null) {
            class_2487 tag = new class_2487();
            this.backpackData.save(tag, this);
            compound.method_10566(BACKPACK_DATA_TAG, tag);
        } else {
            compound.method_10566(BACKPACK_DATA_TAG, new class_2487());
        }
        this.taskDataMaps.writeSaveData(compound);
        this.killRecordManager.addAdditionalSaveData(compound);
        this.aiChatManager.writeToTag(compound);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.taskDataMaps.readSaveData(compound);
        this.setSyncTaskData(this.taskDataMaps.getUpdateTag());
        if (compound.method_10573(MODEL_ID_TAG_NAME, class_2520.field_33258)) {
            setModelId(compound.method_10558(MODEL_ID_TAG_NAME));
        }
        if (compound.method_10573(IS_YSM_MODEL_TAG, class_2520.field_33251)) {
            setIsYsmModel(compound.method_10577(IS_YSM_MODEL_TAG));
        }
        if (compound.method_10573(YSM_MODEL_ID_TAG, class_2520.field_33258)) {
            setYsmModelId(compound.method_10558(YSM_MODEL_ID_TAG));
        }
        if (compound.method_10573(YSM_MODEL_TEXTURE_TAG, class_2520.field_33258)) {
            setYsmModelTexture(compound.method_10558(YSM_MODEL_TEXTURE_TAG));
        }
        if (compound.method_10573(YSM_MODEL_NAME_TAG, class_2520.field_33258)) {
            class_5250 component = class_2561.class_2562.method_10877(compound.method_10558(YSM_MODEL_NAME_TAG), this.method_56673());
            setYsmModelName(Objects.requireNonNullElse(component, class_2561.method_43473()));
        }
        if (compound.method_10573(YSM_ROULETTE_ANIM_TAG, class_2520.field_33258)) {
            rouletteAnim = compound.method_10558(YSM_ROULETTE_ANIM_TAG);
        }
        if (compound.method_10573(YSM_ROAMING_UPDATE_FLAG_TAG, class_2520.field_33253)) {
            roamingVarsUpdateFlag = compound.method_10550(YSM_ROAMING_UPDATE_FLAG_TAG);
        }
        if (compound.method_10573(YSM_ROAMING_VARS_TAG, class_2520.field_33260)) {
            class_2487 roamingVarsTag = compound.method_10562(YSM_ROAMING_VARS_TAG);
            roamingVarsTag.method_10541().forEach(key -> roamingVars.put(key, roamingVarsTag.method_10583(key)));
        }
        if (compound.method_10573(SOUND_PACK_ID_TAG, class_2520.field_33258)) {
            setSoundPackId(compound.method_10558(SOUND_PACK_ID_TAG));
        }
        if (compound.method_10573(SCHEDULE_MODE_TAG, class_2520.field_33258)) {
            setSchedule(MaidSchedule.valueOf(compound.method_10558(SCHEDULE_MODE_TAG)));
        }
        if (compound.method_10573(TASK_TAG, class_2520.field_33258)) {
            class_2960 uid = class_2960.method_60654(compound.method_10558(TASK_TAG));
            IMaidTask task = TaskManager.findTask(uid).orElse(TaskManager.getIdleTask());
            setTask(task);
        }
        if (compound.method_10573(BACKPACK_LEVEL_TAG, class_2520.field_33253)) {
            // 存档迁移
            int backpackLevel = compound.method_10550(BACKPACK_LEVEL_TAG);
            if (backpackLevel == 1) {
                BackpackManager.findBackpack(SmallBackpack.ID).ifPresent(this::setMaidBackpackType);
            }
            if (backpackLevel == 2) {
                BackpackManager.findBackpack(MiddleBackpack.ID).ifPresent(this::setMaidBackpackType);
            }
            if (backpackLevel == 3) {
                BackpackManager.findBackpack(BigBackpack.ID).ifPresent(this::setMaidBackpackType);
            }
            compound.method_10551(BACKPACK_LEVEL_TAG);
        }
        if (compound.method_10573(MAID_INVENTORY_TAG, class_2520.field_33260)) {
            maidInv.deserializeNBT(this.method_56673(), compound.method_10562(MAID_INVENTORY_TAG));
        }
        if (compound.method_10573(MAID_BAUBLE_INVENTORY_TAG, class_2520.field_33260)) {
            maidBauble.deserializeNBT(this.method_56673(), compound.method_10562(MAID_BAUBLE_INVENTORY_TAG));
        }
        if (compound.method_10573(MAID_HIDE_INVENTORY_TAG, class_2520.field_33260)) {
            hideInv.deserializeNBT(this.method_56673(), compound.method_10562(MAID_HIDE_INVENTORY_TAG));
        }
        if (compound.method_10573(MAID_TASK_INVENTORY_TAG, class_2520.field_33260)) {
            taskInv.deserializeNBT(this.method_56673(), compound.method_10562(MAID_TASK_INVENTORY_TAG));
        }
        if (compound.method_10573(STRUCK_BY_LIGHTNING_TAG, class_2520.field_33251)) {
            setStruckByLightning(compound.method_10577(STRUCK_BY_LIGHTNING_TAG));
        }
        if (compound.method_10573(INVULNERABLE_TAG, class_2520.field_33251)) {
            setEntityInvulnerable(compound.method_10577(INVULNERABLE_TAG));
        }
        if (compound.method_10573(HUNGER_TAG, class_2520.field_33253)) {
            setHunger(compound.method_10550(HUNGER_TAG));
        }
        if (compound.method_10573(FAVORABILITY_TAG, class_2520.field_33253)) {
            setFavorability(compound.method_10550(FAVORABILITY_TAG));
        }
        if (compound.method_10573(EXPERIENCE_TAG, class_2520.field_33253)) {
            setExperience(compound.method_10550(EXPERIENCE_TAG));
        }
        if (compound.method_10573(STRUCTURE_SPAWN_TAG, class_2520.field_33251)) {
            this.structureSpawn = compound.method_10577(STRUCTURE_SPAWN_TAG);
        }
        if (compound.method_10573(RESTRICT_CENTER_TAG, class_2520.field_33260)) {
            // 存档迁移
            class_2512.method_10691(compound, RESTRICT_CENTER_TAG).ifPresent(blockPos -> this.schedulePos.setHomeModeEnable(this, blockPos));
            compound.method_10551(RESTRICT_CENTER_TAG);
        }
        if (compound.method_10573(MAID_BACKPACK_TYPE, class_2520.field_33258)) {
            class_2960 id = class_2960.method_60654(compound.method_10558(MAID_BACKPACK_TYPE));
            IMaidBackpack backpack = BackpackManager.findBackpack(id).orElse(BackpackManager.getEmptyBackpack());
            setMaidBackpackType(backpack);
            if (this.backpackData != null && compound.method_10573(BACKPACK_DATA_TAG, class_2520.field_33260)) {
                this.backpackData.load(compound.method_10562(BACKPACK_DATA_TAG), this);
            }
        }
        this.configManager.readAdditionalSaveData(compound);
        this.gameRecordManager.readAdditionalSaveData(compound);
        this.favorabilityManager.readAdditionalSaveData(compound);
        this.schedulePos.load(compound, this);
        this.setBackpackShowItem(maidInv.getStackInSlot(MaidBackpackHandler.BACKPACK_ITEM_SLOT));
        this.killRecordManager.readAdditionalSaveData(compound);
        this.aiChatManager.readFromTag(compound);
    }

    public boolean openMaidGui(class_1657 player) {
        return openMaidGui(player, TabIndex.MAIN);
    }

    public boolean openMaidGui(class_1657 player, int tabIndex) {
        if (player instanceof class_3222 serverPlayer && !this.method_6113()) {
            this.field_6189.method_6340();
            class_3908 guiProvider = getGuiProvider(tabIndex);
//            int id = getId();
//            if (tabIndex == TabIndex.MAID_AI_CHAT_CONFIG) {
//                CompoundTag configData = this.getAiChatManager().writeToTag(new CompoundTag());
//                serverPlayer.openMenu(guiProvider, buffer -> {
//                    buffer.writeInt(id);
//                    buffer.writeNbt(configData);
//                    ClientAvailableSitesSync.writeToNetwork(buffer);
//                });
//            } else {
//                serverPlayer.openMenu(guiProvider, buffer -> buffer.writeInt(id));
//            }
            serverPlayer.method_17355(guiProvider);
        }
        return true;
    }

    private class_3908 getGuiProvider(int tabIndex) {
        return switch (tabIndex) {
            case TabIndex.TASK_CONFIG -> task.getTaskConfigGuiProvider(this);
            case TabIndex.MAID_CONFIG -> MaidConfigContainer.create(method_5628());
            case TabIndex.MAID_AI_CHAT_CONFIG -> MaidAIChatConfigContainer.create(this);
            default -> this.getMaidBackpackType().getGuiProvider(method_5628());
        };
    }

    @Override
    protected void method_16078() {
        if (this.method_6139() != null && !field_6002.field_9236 /* && !PetBedDrop.hasPetBedPos(this) */) {
            // 掉出世界的判断
            class_243 position = class_243.method_24955(method_24515());
            // 防止卡在基岩里？
            if (this.method_23318() < this.field_6002.method_31607() + 5) {
                position = new class_243(position.field_1352, this.field_6002.method_31607() + 5, position.field_1350);
            }
            if (this.method_23318() > this.field_6002.method_31600()) {
                position = new class_243(position.field_1352, this.field_6002.method_31600(), position.field_1350);
            }
            EntityTombstone tombstone = new EntityTombstone(field_6002, this.method_6139(), position);
            tombstone.setMaidName(this.method_5476());

            // 女仆物品栏
            CombinedInvWrapper invWrapper = new CombinedInvWrapper(armorInvWrapper, handsInvWrapper, maidInv, maidBauble, hideInv, taskInv);
            // 需要考虑消失诅咒附魔
            destroyVanishingCursedItems(invWrapper);
            for (int i = 0; i < invWrapper.getSlots(); i++) {
                int size = invWrapper.getSlotLimit(i);
                tombstone.insertItem(invWrapper.extractItem(i, size, false));
            }
            // 背包额外数据
            IMaidBackpack maidBackpack = this.getMaidBackpackType();
            tombstone.insertItem(maidBackpack.getTakeOffItemStack(class_1799.field_8037, null, this));
            maidBackpack.onSpawnTombstone(this, tombstone);
            // 胶片
            class_1799 filmItem = ItemFilm.maidToFilm(this);
            tombstone.insertItem(filmItem);
            // 全局记录
            MaidWorldData maidWorldData = MaidWorldData.get(field_6002);
            if (maidWorldData != null) {
                maidWorldData.addTombstones(this, tombstone);
            }

            // 记录墓碑已经生成，避免重复生成
            alreadyDropped = true;
            field_6002.method_8649(tombstone);
        }
    }

    private void destroyVanishingCursedItems(CombinedInvWrapper invWrapper) {
        if (this.field_6002.method_8450().method_8355(class_1928.field_19389)) {
            return;
        }
        for (int i = 0; i < invWrapper.getSlots(); ++i) {
            class_1799 stack = invWrapper.getStackInSlot(i);
            if (!stack.method_7960() && class_1890.method_60142(stack, class_9701.field_51655) && !stack.method_31573(TagItem.MAID_VANISHING_BLOCKLIST_ITEM)) {
                invWrapper.setStackInSlot(i, class_1799.field_8037);
            }
        }
    }

    @Override
    public void method_5650(class_5529 reason) {
        // TODO: 尝试修复可能存在的目标生成丢失问题，可能会有问题
        if (reason == class_5529.field_26998 && !alreadyDropped) {
            // 女仆被指令杀后也正常生成墓碑
            this.method_16078();
        }
        super.method_5650(reason);
    }

    @Override
    protected void method_6040() {
        this.getSwimManager().resetEatBreatheItem();
        super.method_6040();
        this.backCurrentHandItemStack();
    }

    /**
     * 当需要临时调换手中物品和背包内物品时，可调用此方法
     * 当置换后的物品使用完后会自动将之前的手中物品再次返回到手上
     *
     * @param itemStack 当前手上的物品（必须是能使用--需要持续使用的物品）
     */
    public void memoryHandItemStack(class_1799 itemStack) {
        // 先检查内部存储是否已经有物品了，有就掉落
        class_1799 hideItemStack = this.getHideInv().getStackInSlot(0);
        if (!hideItemStack.method_7960()) {
            class_1799 extractItem = this.getHideInv().extractItem(0, hideItemStack.method_7947(), false);
            if (!extractItem.method_7960()) {
                class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318() + 0.5, this.method_23321(), extractItem);
                this.field_6002.method_8649(itemEntity);
            }
        }
        // 然后存入我们的物品
        ItemHandlerHelper.insertItemStacked(this.getHideInv(), itemStack, false);
    }

    /**
     * 将之前临时存在背包里的物品再次放在对应的手上
     */
    private void backCurrentHandItemStack() {
        // 先看看副手是否为空？
        class_1799 offhandItem = this.method_5998(class_1268.field_5810);
        if (!offhandItem.method_7960()) {
            class_1799 stack = ItemHandlerHelper.insertItemStacked(this.getAvailableBackpackInv(), offhandItem.method_7972(), false);
            if (!stack.method_7960()) {
                class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318() + 0.5, this.method_23321(), stack);
                this.field_6002.method_8649(itemEntity);
            }
        }
        // 副手此时为空，那么插入我们的物品
        class_1799 output = this.getHideInv().extractItem(0, this.getHideInv().getStackInSlot(0).method_7947(), false);
        this.method_6122(class_1268.field_5810, output);
    }

    @Override
    public class_1799 method_18866(class_1937 level, class_1799 food, class_4174 pFoodProperties) {
        class_1799 copy = food.method_7972();
        class_1799 foodAfterEat = super.method_18866(level, food, pFoodProperties);
        Optional<class_1799> converts = pFoodProperties.comp_2794();
        MaidAfterEatEvent maidAfterEatEvent = new MaidAfterEatEvent(this, foodAfterEat.method_7960() && converts.isPresent() ? copy : foodAfterEat);
        MaidAfterEatEvent.CALLBACK.invoker().post(maidAfterEatEvent);
        return foodAfterEat;
    }

    @Override
    protected boolean method_6071() {
        return true;
    }

    @Override
    public int method_6110() {
        return this.getExperience();
    }

    @Override
    protected class_2561 method_23315() {
        // 优先事件系统
        MaidTypeNameEvent typeNameEvent = new MaidTypeNameEvent(this);
        MaidTypeNameEvent.CALLBACK.invoker().onMaidTypeName(typeNameEvent);
        if (typeNameEvent.getTypeName() != null) {
            return typeNameEvent.getTypeName();
        }
        // 优先使用 YSM 模型名称
        if (YsmCompat.isInstalled() && this.isYsmModel()) {
            class_2561 name = this.getYsmModelName();
            if (name.equals(class_2561.method_43473())) {
                return class_2561.method_43470(this.getYsmModelId());
            }
            return name;
        }
        // 然后才是默认模型名
        Optional<MaidModelInfo> info = ServerCustomPackLoader.SERVER_MAID_MODELS.getInfo(getModelId());
        return info.map(maidModelInfo -> ParseI18n.parse(maidModelInfo.getName())).orElseGet(() -> class_2561.method_43470(method_5864().method_5882()));
    }

    @Override
    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, @Nullable class_1315 spawnDataIn) {
        // 为结构生成的女仆添加特殊标签
        if (reason == class_3730.field_16474) {
            this.structureSpawn = true;
        }
        int modelSize = ServerCustomPackLoader.SERVER_MAID_MODELS.getModelSize();
        // 这里居然可能为 0
        if (modelSize > 0) {
            int skipRandom = field_5974.method_43048(modelSize);
            Optional<String> modelId = ServerCustomPackLoader.SERVER_MAID_MODELS.getModelIdSet().stream().skip(skipRandom).findFirst();
            return modelId.map(id -> {
                this.setModelId(id);
                return spawnDataIn;
            }).orElse(spawnDataIn);
        }
        return spawnDataIn;
    }

    @Override
    public void method_5673(class_1304 slot, class_1799 stack) {
        super.method_5673(slot, stack);
        if (!this.field_6002.field_9236) {
            MaidEquipEvent maidEquipEvent = new MaidEquipEvent(this, slot, stack);
            MaidEquipEvent.CALLBACK.invoker().post(maidEquipEvent);
        }
    }

    @Override
    public void method_6116(class_1304 slot, class_1799 oldItem, class_1799 newItem) {
        super.method_6116(slot, oldItem, newItem);
        if (newItem.method_7960() || this.field_5953 || !slot.method_46643()) {
            return;
        }

        // 触发成就
        if (this.method_35057() instanceof class_3222 serverPlayer) {
            InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.ANY_EQUIPMENT);
        }

        // 如果是下界合金
        if (isNetheriteArmor(newItem)) {
            // 检查全身装备
            for (class_1304 slotIn : class_1304.values()) {
                if (!slotIn.method_46643() || slotIn == slot || slotIn == class_1304.field_48824) {
                    continue;
                }
                class_1799 itemBySlot = method_6118(slotIn);
                if (!isNetheriteArmor(itemBySlot)) {
                    return;
                }
            }
            // 触发事件
            if (this.method_35057() instanceof class_3222 serverPlayer) {
                InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.ALL_NETHERITE_EQUIPMENT);
            }
        }
    }

    private boolean isNetheriteArmor(class_1799 stack) {
        if (stack.method_7909() instanceof class_1738 armorItem) {
            return armorItem.method_7686() == class_1740.field_21977;
        }
        return false;
    }

    @Override
    public void method_5783(class_3414 soundEvent, float volume, float pitch) {
        if (soundEvent.method_14833().method_12832().startsWith("maid") && !field_6002.field_9236) {
            NetworkHandler.sendToNearby(this, new PlayMaidSoundPackage(soundEvent.method_14833(), this.getSoundPackId(), this.method_5628()), 16);
        } else {
            super.method_5783(soundEvent, volume, pitch);
        }
    }

    @Nullable
    @Override
    protected class_3414 method_5994() {
        MaidPlaySoundEvent event = new MaidPlaySoundEvent(this);
        MaidPlaySoundEvent.CALLBACK.invoker().post(event);
        if (event.isCanceled()) {
            return null;
        }
        return task.getAmbientSound(this);
    }

    @Nullable
    @Override
    protected class_3414 method_6011(class_1282 damageSourceIn) {
        MaidPlaySoundEvent event = new MaidPlaySoundEvent(this);
        MaidPlaySoundEvent.CALLBACK.invoker().post(event);
        if (event.isCanceled()) {
            return null;
        }
        if (damageSourceIn.method_48789(class_8103.field_42246)) {
            return InitSounds.MAID_HURT_FIRE;
        } else if (damageSourceIn.method_5529() instanceof class_1657) {
            if (playerHurtSoundCount == 0) {
                playerHurtSoundCount = 120;
                return InitSounds.MAID_PLAYER;
            } else {
                return null;
            }
        } else {
            return InitSounds.MAID_HURT;
        }
    }

    @Nullable
    @Override
    protected class_3414 method_6002() {
        MaidPlaySoundEvent event = new MaidPlaySoundEvent(this);
        MaidPlaySoundEvent.CALLBACK.invoker().post(event);
        if (event.isCanceled()) {
            return null;
        }
        return InitSounds.MAID_DEATH;
    }

    @Override
    public float method_6017() {
        return 1 + field_5974.method_43057() * 0.1F;
    }

    @Override
    public float method_18381(class_4050 pPose) {
        return this.method_18377(pPose).comp_2186() * (isMaidInSittingPose() ? 0.65F : 0.85F);
    }

    @Override
    public boolean method_6109() {
        return false;
    }

    @Override
    public class_1296 method_5613(class_3218 serverWorld, class_1296 ageableEntity) {
        return null;
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public boolean canPathReach(class_2338 pos) {
        class_11 path = this.method_5942().method_6348(pos, 0);
        return path != null && path.method_21655();
    }

    public boolean canPathReach(class_1297 entity) {
        class_11 path = this.method_5942().method_6349(entity, 0);
        return path != null && path.method_21655();
    }

    /**
     * @deprecated 给 BehaviorUtils.isWithinAttackRange() 用的 <br>
     * 但是目前为了实现超远视距打击，已经不用原版提供的这个了 <br>
     * 故这里返回 true 还是 false 都不影响了
     */
    @Override
    @Deprecated
    public boolean method_25938(class_1811 shootableItem) {
        return getTask() instanceof IRangedAttackTask;
    }

    /**
     * 因为原版默认的攻击识别范围是固定死的 16 格，但是一些远程武器我们希望获得超视距打击
     * 通过修改此处来获得更远的攻击距离
     */
    public boolean canSee(class_1309 target) {
        if (this.getTask() instanceof IRangedAttackTask rangedTask) {
            return rangedTask.canSee(this, target);
        }
        return class_4215.method_24565(this, target);
    }

    /**
     * 实体搜索范围
     */
    public class_238 searchDimension() {
        // 仅工作时，才搜索 task 的范围，避免性能压力
        if (this.getScheduleDetail() == class_4168.field_18596) {
            return this.getTask().searchDimension(this);
        }
        return TaskManager.getIdleTask().searchDimension(this);
    }

    /**
     * 实体搜索范围的水平范围值
     */
    public float searchRadius() {
        return this.getTask().searchRadius(this);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public class_238 method_5830() {
        BedrockModel<class_1308> model = CustomPackLoader.MAID_MODELS.getModel(getModelId()).orElse(null);
        if (model == null) {
            return super.method_5830();
        }
        return model.getRenderBoundingBox().method_997(method_19538());
    }

    @Override
    @Environment(EnvType.CLIENT)
    public class_243 method_29919() {
        Optional<BedrockModel<class_1308>> modelOptional = CustomPackLoader.MAID_MODELS.getModel(this.getModelId());
        Optional<MaidModelInfo> infoOptional = CustomPackLoader.MAID_MODELS.getInfo(this.getModelId());
        if (modelOptional.isPresent() && infoOptional.isPresent()) {
            BedrockModel<class_1308> model = modelOptional.get();
            float renderEntityScale = infoOptional.get().getRenderEntityScale();
            if (model.hasHead()) {
                BedrockPart head = model.getHead();
                return new class_243(head.x * renderEntityScale, (1.5 - head.y / 16) * renderEntityScale, head.z * renderEntityScale);
            }
        }
        return super.method_29919();
    }

    @Override
    public boolean method_5640(double distance) {
        // 修正睡觉时渲染问题，默认 64 格内渲染
        double range = 64.0 * method_5824();
        return distance < range * range;
    }

    @Override
    public void method_18403(class_2338 pPos) {
        super.method_18403(pPos);
        this.method_6033(this.method_6063());
        this.favorabilityManager.apply(Type.SLEEP);
        if (this.method_35057() instanceof class_3222 serverPlayer) {
            InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.MAID_SLEEP);
        }
    }

    public void setBackpackDelay() {
        backpackDelay = 20;
    }

    public boolean backpackHasDelay() {
        return backpackDelay > 0;
    }

    @Override
    public String getModelId() {
        return this.field_6011.method_12789(DATA_MODEL_ID);
    }

    public void setModelId(String modelId) {
        this.field_6011.method_12778(DATA_MODEL_ID, modelId);
    }

    @Override
    public boolean isYsmModel() {
        return this.field_6011.method_12789(DATA_IS_YSM_MODEL);
    }

    @Override
    public void setIsYsmModel(boolean isYsmModel) {
        this.field_6011.method_12778(DATA_IS_YSM_MODEL, isYsmModel);
    }

    @Override
    public String getYsmModelId() {
        return this.field_6011.method_12789(DATA_YSM_MODEL_ID);
    }

    protected void setYsmModelId(String modelId) {
        this.field_6011.method_12778(DATA_YSM_MODEL_ID, modelId);
    }

    @Override
    public String getYsmModelTexture() {
        return this.field_6011.method_12789(DATA_YSM_MODEL_TEXTURE);
    }

    protected void setYsmModelTexture(String texture) {
        this.field_6011.method_12778(DATA_YSM_MODEL_TEXTURE, texture);
    }

    @Override
    public class_2561 getYsmModelName() {
        return this.field_6011.method_12789(DATA_YSM_MODEL_NAME);
    }

    protected void setYsmModelName(class_2561 name) {
        this.field_6011.method_12778(DATA_YSM_MODEL_NAME, name);
    }

    @Override
    public void setYsmModel(String modelId, String texture, class_2561 name) {
        if (!modelId.equals(this.getYsmModelId())) {
            this.roamingVars = new Object2FloatOpenHashMap<>();
            this.stopRouletteAnim();
        }
        this.setYsmModelId(modelId);
        this.setYsmModelTexture(texture);
        this.setYsmModelName(name);
    }

    @Override
    public void playRouletteAnim(String rouletteAnim) {
        this.rouletteAnimPlaying = true;
        this.rouletteAnim = rouletteAnim;
        this.rouletteAnimDirty = true;
    }

    @Override
    public void stopRouletteAnim() {
        this.rouletteAnimPlaying = false;
        this.rouletteAnimDirty = true;
    }

    public String getSoundPackId() {
        return this.field_6011.method_12789(DATA_SOUND_PACK_ID);
    }

    public void setSoundPackId(String soundPackId) {
        this.field_6011.method_12778(DATA_SOUND_PACK_ID, soundPackId);
    }

    @Override
    public boolean isMaidInSittingPose() {
        return super.method_6172();
    }

    @Override
    public boolean isBegging() {
        return this.field_6011.method_12789(DATA_BEGGING);
    }

    public void setBegging(boolean begging) {
        this.field_6011.method_12778(DATA_BEGGING, begging);
    }

    public boolean isHomeModeEnable() {
        return this.configManager.isHomeModeEnable();
    }

    public void setHomeModeEnable(boolean enable) {
        this.configManager.setHomeModeEnable(enable);
    }

    public MaidConfigManager getConfigManager() {
        return configManager;
    }

    @Override
    public boolean method_18411() {
        return this.method_18407(this.method_24515());
    }

    @Override
    public boolean method_18407(class_2338 pos) {
        if (method_18410()) {
            return this.method_18412().method_10262(pos) < (double) (this.method_18413() * this.method_18413());
        }
        return true;
    }

    @Override
    public void method_18408(class_2338 pos, int distance) {
        this.field_6011.method_12778(RESTRICT_CENTER, pos);
        this.field_6011.method_12778(RESTRICT_RADIUS, (float) distance);
    }

    @Override
    public class_2338 method_18412() {
        return this.field_6011.method_12789(RESTRICT_CENTER);
    }

    @Override
    public float method_18413() {
        return this.field_6011.method_12789(RESTRICT_RADIUS);
    }

    @Override
    public void method_35055() {
        this.schedulePos.clear(this);
    }

    @Override
    public boolean method_18410() {
        return this.isHomeModeEnable();
    }

    public class_2338 getBrainSearchPos() {
        if (this.method_18410()) {
            return this.method_18412();
        } else {
            return this.method_24515();
        }
    }

    public boolean canBrainMoving() {
        return !this.isMaidInSittingPose() && !this.method_5765() && !this.method_6113() && !this.method_60953();
    }

    public boolean isPickup() {
        return this.configManager.isPickup();
    }

    public void setPickup(boolean isPickup) {
        this.configManager.setPickup(isPickup);
    }

    public boolean isRideable() {
        return this.configManager.isRideable();
    }

    public void setRideable(boolean rideable) {
        this.configManager.setRideable(rideable);
    }

    public int getHunger() {
        return this.field_6011.method_12789(DATA_HUNGER);
    }

    public void setHunger(int hunger) {
        this.field_6011.method_12778(DATA_HUNGER, hunger);
    }

    @Override
    public int getFavorability() {
        return this.field_6011.method_12789(DATA_FAVORABILITY);
    }

    public void setFavorability(int favorability) {
        this.field_6011.method_12778(DATA_FAVORABILITY, favorability);
    }

    @Override
    public int getExperience() {
        return this.field_6011.method_12789(DATA_EXPERIENCE);
    }

    public void setExperience(int experience) {
        this.field_6011.method_12778(DATA_EXPERIENCE, experience);
    }

    public boolean isStruckByLightning() {
        return this.field_6011.method_12789(DATA_STRUCK_BY_LIGHTNING);
    }

    public void setStruckByLightning(boolean isStruck) {
        this.field_6011.method_12778(DATA_STRUCK_BY_LIGHTNING, isStruck);
    }

    @Override
    public boolean isSwingingArms() {
        return this.field_6011.method_12789(DATA_ARM_RISE);
    }

    public void setSwingingArms(boolean swingingArms) {
        this.field_6011.method_12778(DATA_ARM_RISE, swingingArms);
    }

    public String getBackpackFluid() {
        return this.field_6011.method_12789(BACKPACK_FLUID);
    }

    public void setBackpackFluid(String fluidName) {
        this.field_6011.method_12778(BACKPACK_FLUID, fluidName);
    }

    public MaidSchedule getSchedule() {
        return this.field_6011.method_12789(SCHEDULE_MODE);
    }

    public void setSchedule(MaidSchedule schedule) {
        this.field_6011.method_12778(SCHEDULE_MODE, schedule);
        if (this.field_6002 instanceof class_3218) {
            this.refreshBrain((class_3218) this.field_6002);
        }
    }

    public class_4168 getScheduleDetail() {
        MaidSchedule schedule = this.getSchedule();
        int time = (int) (this.field_6002.method_8532() % 24000L);
        switch (schedule) {
            case ALL -> {
                return class_4168.field_18596;
            }
            case NIGHT -> {
                return InitEntities.MAID_NIGHT_SHIFT_SCHEDULES.method_19213(time);
            }
            default -> {
                return InitEntities.MAID_DAY_SHIFT_SCHEDULES.method_19213(time);
            }
        }
    }

    public SchedulePos getSchedulePos() {
        return schedulePos;
    }

    @Override
    public class_1799 getBackpackShowItem() {
        return this.field_6011.method_12789(BACKPACK_ITEM_SHOW);
    }

    public void setBackpackShowItem(class_1799 stack) {
        this.field_6011.method_12778(BACKPACK_ITEM_SHOW, stack);
    }

    @Override
    public IMaidBackpack getMaidBackpackType() {
        class_2960 id = class_2960.method_60654(field_6011.method_12789(BACKPACK_TYPE));
        return BackpackManager.findBackpack(id).orElse(BackpackManager.getEmptyBackpack());
    }

    public void setMaidBackpackType(IMaidBackpack backpack) {
        if (backpack == this.backpack) {
            return;
        }
        this.backpack = backpack;
        if (this.backpack.hasBackpackData()) {
            this.backpackData = this.backpack.getBackpackData(this);
        } else {
            this.backpackData = null;
        }
        this.field_6011.method_12778(BACKPACK_TYPE, backpack.getId().toString());
    }

    public IBackpackData getBackpackData() {
        return backpackData;
    }

    public ItemStackHandler getMaidInv() {
        return maidInv;
    }

    public CombinedInvWrapper getAvailableInv(boolean handsFirst) {
        RangedWrapper combinedInvWrapper = this.getAvailableBackpackInv();
        return handsFirst ? new CombinedInvWrapper(handsInvWrapper, combinedInvWrapper) : new CombinedInvWrapper(combinedInvWrapper, handsInvWrapper);
    }

    public RangedWrapper getAvailableBackpackInv() {
        return new RangedWrapper(maidInv, 0, getMaidBackpackType().getAvailableMaxContainerIndex());
    }

    public EntityHandsInvWrapper getHandsInvWrapper() {
        return handsInvWrapper;
    }

    public EntityArmorInvWrapper getArmorInvWrapper() {
        return armorInvWrapper;
    }

    public BaubleItemHandler getMaidBauble() {
        return maidBauble;
    }

    public CombinedInvWrapper getAllInv() {
        return new CombinedInvWrapper(getHandsInvWrapper(), getArmorInvWrapper(), getMaidInv(), getMaidBauble());
    }

    /**
     * 获取隐藏物品栏
     */
    public ItemStackHandler getHideInv() {
        return hideInv;
    }

    /**
     * 获取任务物品栏
     */
    public ItemStackHandler getTaskInv() {
        return taskInv;
    }

    public boolean getIsInvulnerable() {
        return this.field_6011.method_12789(DATA_INVULNERABLE);
    }

    public void setEntityInvulnerable(boolean isInvulnerable) {
        super.method_5684(isInvulnerable);
        this.field_6011.method_12778(DATA_INVULNERABLE, isInvulnerable);
    }

    @Override
    public IMaidTask getTask() {
        class_2960 uid = class_2960.method_60654(field_6011.method_12789(DATA_TASK));
        return TaskManager.findTask(uid).orElse(TaskManager.getIdleTask());
    }

    public void setTask(IMaidTask task) {
        if (task == this.task) {
            return;
        }
        this.task = task;
        this.field_6011.method_12778(DATA_TASK, task.getUid().toString());
        if (field_6002 instanceof class_3218) {
            refreshBrain((class_3218) field_6002);
        }
    }

    @Override
    public void method_6179(boolean inSittingPose) {
        super.method_6179(inSittingPose);
        method_24346(inSittingPose);
    }

    public MaidGameRecordManager getGameRecordManager() {
        return gameRecordManager;
    }

    private class_2487 getSyncTaskData() {
        return this.field_6011.method_12789(TASK_DATA_SYNC);
    }

    private void setSyncTaskData(class_2487 compoundTag) {
        this.field_6011.method_49743(TASK_DATA_SYNC, compoundTag, true);
    }

    public float getLuck() {
        return (float) this.method_45325(class_5134.field_23726);
    }

    public MaidKillRecordManager getKillRecordManager() {
        return killRecordManager;
    }

    @Override
    public boolean hasFishingHook() {
        return this.fishing != null;
    }

    public boolean isStructureSpawn() {
        return structureSpawn;
    }

    public List<SendEffectPackage.EffectData> getEffects() {
        return effects;
    }

    public void setEffects(List<SendEffectPackage.EffectData> effects) {
        this.effects = effects;
    }

    public boolean canDestroyBlock(class_2338 pos) {
        class_2680 state = field_6002.method_8320(pos);
        return BlockUtil.canEntityDestroy(state.method_26204(), state, field_6002, pos, this) /*&& net.neoforged.neoforge.event.EventHooks.onEntityDestroyBlock(this, pos, state)*/;
    }

    public boolean canPlaceBlock(class_2338 pos) {
        class_2680 oldState = field_6002.method_8320(pos);
        return oldState.method_45474();
    }

    public boolean destroyBlock(class_2338 pos) {
        return destroyBlock(pos, true);
    }

    public boolean destroyBlock(class_2338 pos, boolean dropBlock) {
        return canDestroyBlock(pos) && destroyBlock(field_6002, pos, dropBlock, this);
    }

    public boolean destroyBlock(class_1937 level, class_2338 blockPos, boolean dropBlock, @Nullable class_1297 entity) {
        class_2680 blockState = level.method_8320(blockPos);
        if (blockState.method_26215()) {
            return false;
        } else {
            class_3610 fluidState = level.method_8316(blockPos);
            if (!(blockState.method_26204() instanceof class_4770)) {
                level.method_20290(class_6088.field_31144, blockPos, class_2248.method_9507(blockState));
            }
            if (dropBlock) {
                class_2586 blockEntity = blockState.method_31709() ? level.method_8321(blockPos) : null;
                dropResourcesToMaidInv(blockState, level, blockPos, blockEntity, this, class_1799.field_8037);
            }
            boolean setResult = level.method_8652(blockPos, fluidState.method_15759(), class_2248.field_31036);
            if (setResult) {
                level.method_43276(class_5712.field_28165, blockPos, class_5712.class_7397.method_43286(entity, blockState));
            }
            return setResult;
        }
    }

    public void dropResourcesToMaidInv(class_2680 state, class_1937 level, class_2338 pos, @Nullable class_2586 blockEntity, EntityMaid maid, class_1799 tool) {
        if (level instanceof class_3218 serverLevel) {
            CombinedInvWrapper availableInv = this.getAvailableInv(false);
            class_2248.method_9609(state, serverLevel, pos, blockEntity, maid, tool).forEach(stack -> {
                class_1799 remindItemStack = ItemHandlerHelper.insertItemStacked(availableInv, stack, false);
                if (!remindItemStack.method_7960()) {
                    class_2248.method_9577(level, pos, remindItemStack);
                }
            });
            state.method_26180(serverLevel, pos, tool, true);
        }
    }

    public boolean placeItemBlock(class_1268 hand, class_2338 placePos, class_2350 direction, class_1799 stack) {
        if (stack.method_7909() instanceof class_1747 blockItem) {
            return blockItem.method_7712(new class_1750(field_6002, null, hand, stack,
                    getBlockRayTraceResult(placePos, direction))).method_23665();
        }
        return false;
    }

    public boolean placeItemBlock(class_2338 placePos, class_2350 direction, class_1799 stack) {
        return placeItemBlock(class_1268.field_5808, placePos, direction, stack);
    }

    public boolean placeItemBlock(class_2338 placePos, class_1799 stack) {
        return placeItemBlock(placePos, class_2350.field_11036, stack);
    }

    private class_3965 getBlockRayTraceResult(class_2338 pos, class_2350 direction) {
        return new class_3965(
                new class_243((double) pos.method_10263() + 0.5D + (double) direction.method_10148() * 0.5D,
                        (double) pos.method_10264() + 0.5D + (double) direction.method_10164() * 0.5D,
                        (double) pos.method_10260() + 0.5D + (double) direction.method_10165() * 0.5D),
                direction, pos, false);
    }

    public FavorabilityManager getFavorabilityManager() {
        return favorabilityManager;
    }

    @SuppressWarnings("all")
    public class_1856 getTamedItem() {
        // 可以被配置文件和 tag 同时修改
        class_1856 configIngredient = getConfigIngredient(MaidConfig.MAID_TAMED_ITEM.get(), class_1802.field_17534);
        class_1856 tagIngredient = class_1856.method_8106(TagItem.MAID_TAMED_ITEM);
        return merge(Lists.newArrayList(configIngredient, tagIngredient));
    }

    private class_1856 merge(Collection<class_1856> parts) {

        return class_1856.method_8092(
                parts.stream().filter(ingredient -> ingredient.getCustomIngredient() == null)
                        .flatMap(i -> Arrays.stream(i.field_9019)));
    }

    @SuppressWarnings("all")
    public class_1856 getTemptationItem() {
        return getConfigIngredient(MaidConfig.MAID_TEMPTATION_ITEM.get(), class_1802.field_17534);
    }

    @SuppressWarnings("all")
    public static class_1856 getNtrItem() {
        return class_1856.method_8091(InitItems.OWNER_CONVERSION_TOOL);
    }

    private static class_1856 getConfigIngredient(String config, class_1792 defaultItem) {
        if (config.startsWith(MaidConfig.TAG_PREFIX)) {
            class_2960 key = class_2960.method_60654(config.substring(1));
            class_6862<class_1792> tagKey = class_6862.method_40092(class_7923.field_41178.method_30517(), key);
            return class_1856.method_8106(tagKey);
        } else {
            class_2960 key = class_2960.method_60654(config);
            if (class_7923.field_41178.method_10250(key)) {
                return class_1856.method_8091(class_7923.field_41178.method_10223(key));
            }
        }
        return class_1856.method_8091(defaultItem);
    }

    @Override
    public EntityMaid asStrictMaid() {
        return this;
    }

    @Override
    public class_1308 asEntity() {
        return this;
    }

    @Override
    public class_1799[] getHandItemsForAnimation() {
        return handItemsForAnimation;
    }

    @Override
    public class_243 method_18801(class_243 deltaMovement) {
        class_243 oriDelta = super.method_18801(deltaMovement);
        // 主动爬行过程中严禁水平方向偏移，防止摔伤，y轴保持原样
        if (this.isCanClimb()) {
            class_243 vec3 = this.method_19538();
            if (vec3.method_10216() % 1 != 0.5D || vec3.method_10215() % 1 != 0.5) {
                class_2338 currentPosition = this.method_24515().method_25503();
                class_243 centerPos = class_243.method_24955(currentPosition);
                this.method_24203(centerPos.field_1352, vec3.method_10214(), centerPos.field_1350);
            }
            oriDelta = new class_243(0, oriDelta.field_1351, 0);
        }
        return oriDelta;
    }

    /**
     * 爬梯子状态加上路径判断
     */
    @Override
    public boolean method_6101() {
        boolean result = false;
        class_11 path = this.field_6189.method_6345();
        if (path != null && !path.method_46()) {
            // 女仆是要爬梯子而不是路过梯子，那么也就意味着当前节点的前后必有一个节点是同坐标的
            for (int i = Math.max(0, path.method_39() - 3); i < Math.min(path.method_38(), path.method_39() + 3) - 1; i++) {
                class_2338 pos1 = path.method_31031(i);
                class_2338 pos2 = path.method_31031(i + 1);
                if (pos1.method_10263() == pos2.method_10263() && pos1.method_10260() == pos2.method_10260()) {
                    result = true;
                    break;
                }
            }
        }
        if (result) {
            result = super.method_6101();
            // 用作脚手架和卡在梯子顶部的特判，避免女仆卡在脚手架顶上
            if (!result && !this.method_7325()) {
                Optional<class_2338> ladderPos = CommonHooks.isLivingOnLadder(
                        field_6002.method_8320(method_24515().method_10074()),
                        method_37908(), method_24515().method_10074(), this);
                if (ladderPos.isPresent()) {
                    result = true;
                }
            }
        }
        if (result) {
            // 爬梯后一段时间禁用摔落伤害
            this.climbFallDelayTicks = 30;
            // 爬梯时，禁止旋转
            this.method_24832().ifPresent(climbablePos -> {
                class_2680 blockState = this.field_6002.method_8320(climbablePos);
                blockState.method_28500(class_2383.field_11177).ifPresent(direction -> {
                    int yRot = direction.method_10153().method_10161() * 90;
                    this.method_36456(yRot);
                    this.method_5847(yRot);
                });
            });
        }
        return result;
    }

    /**
     * 略微修改原版的方法，禁用了向上的动力源
     */
    @Override
    public class_243 method_26318(class_243 deltaMovement, float friction) {
        this.method_5724(this.method_18802(friction), deltaMovement);
        this.method_18799(this.method_18801(this.method_18798()));
        this.method_5784(class_1313.field_6308, this.method_18798());
        return this.method_18798();
    }

    public boolean isCanClimb() {
        return canClimb;
    }

    public void setCanClimb(boolean canClimb) {
        this.canClimb = canClimb;
    }

    public void setNavigation(class_1408 navigation) {
        this.field_6189 = navigation;
    }

    public MaidSwimManager getSwimManager() {
        return swimManager;
    }

    @Override
    @SuppressWarnings("deprecation")
    public boolean method_5675() {
        return !this.getSwimManager().wantToSwim();
    }

    @Override
    public void method_6091(class_243 travelVector) {
        if (this.method_5787() && method_5799()) {
            if (this.getSwimManager().wantToSwim()) {
                this.method_5724(0.01F, travelVector);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021(0.9));
            } else if (this.getSwimManager().isReadyToLand() || method_5869()) {
                super.method_6091(travelVector.method_1021(1.2).method_1031(0, 0.5, 0));
            } else {
                super.method_6091(travelVector.method_1021(1.2).method_1031(0, 0.05, 0));
            }
        } else {
            super.method_6091(travelVector);
        }
    }

    @Override
    public class_4048 method_55694(class_4050 pose) {
        return pose == class_4050.field_18079 ? this.getSwimManager().getSwimmingDimensions() : super.method_55694(pose);
    }

    @Override
    public void method_5790() {
        this.getSwimManager().updateSwimming();
    }

    @Override
    public boolean method_20232() {
        return this.method_5681();
    }

    public boolean canUseShield() {
        class_1799 offhandItem = this.method_6079();
        return /*offhandItem.canPerformAction(ItemAbilities.SHIELD_BLOCK)*/
                (offhandItem.method_31573(ConventionalItemTags.SHIELD_TOOLS) || offhandItem.method_7909() instanceof class_1819 || offhandItem.method_7909().method_7853(offhandItem) == class_1839.field_8949)
                        && !this.getCooldowns().method_7904(offhandItem.method_7909());
    }

    @Override
    public boolean method_6039() {
        // 调整原版的机制，女仆只要使用了盾牌，立马就能防御投掷物
        return this.method_6115() && (this.field_6277.method_31573(ConventionalItemTags.SHIELD_TOOLS) || (!this.field_6277.method_7960() && this.field_6277.method_7909().method_7853(this.field_6277) == class_1839.field_8949)) /*this.useItem.canPerformAction(ItemAbilities.SHIELD_BLOCK)*/;
    }

    @Override
    protected void method_6090(class_1309 attacker) {
        super.method_6090(attacker);
        if (attacker.method_6047().method_7909() instanceof class_1743 /*.canDisableShield(this.useItem, this, attacker)*/) {
            this.getCooldowns().method_7906(this.method_6030().method_7909(), 100);
            this.method_6021();
            this.field_6002.method_8421(this, class_6024.field_29998);
        }
    }

    @Override
    public void method_6056(float damage) {
        if (/*this.useItem.canPerformAction(ItemAbilities.SHIELD_BLOCK)*/
                (this.field_6277.method_31573(ConventionalItemTags.SHIELD_TOOLS) ||
                        this.field_6277.method_7909().method_7853(this.field_6277) == class_1839.field_8949) && damage >= 3.0F) {
            int damageAmount = 1 + class_3532.method_15375(damage);
            class_1268 interactionhand = this.method_6058();
            if (this.field_6002 instanceof class_3218 serverlevel) {
                this.field_6277.method_7956(damageAmount, serverlevel, null /*this*/, item -> {
                    this.method_20235(item, method_56079(interactionhand));
                    this.method_6021();
                });
            }
            if (this.field_6277.method_7960()) {
                if (interactionhand == class_1268.field_5808) {
                    this.method_5673(class_1304.field_6173, class_1799.field_8037);
                } else {
                    this.method_5673(class_1304.field_6171, class_1799.field_8037);
                }
                this.field_6277 = class_1799.field_8037;
                this.method_5783(class_3417.field_15239, 0.8F, 0.8F + this.field_6002.field_9229.method_43057() * 0.4F);
            } else {
                this.method_5783(class_3417.field_15150, 1.0F, 1.0F);
            }
        }
    }

    public class_1796 getCooldowns() {
        return cooldowns;
    }

    public MaidAIChatManager getAiChatManager() {
        return aiChatManager;
    }

    public MaidNavigationManager getNavigationManager() {
        return navigationManager;
    }

    /**
     * 参考自 <a href="https://github.com/Snownee/Companion/blob/1.20-forge/src/main/java/snownee/companion/Hooks.java#L313-L322">Snownee's Companion</a>
     * <p>
     * 更加高效的 owner 寻找方式
     */
    @Override
    @Nullable
    public class_1309 method_35057() {
        UUID uuid = this.method_6139();
        if (uuid == null) {
            return null;
        }
        MinecraftServer server = this.method_37908().method_8503();
        if (server == null) {
            return this.method_37908().method_18470(uuid);
        }
        return server.method_3760().method_14602(uuid);
    }

    public boolean teleportToOwner(class_1309 owner) {
        class_2338 blockPos = owner.method_24515();
        for (int i = 0; i < MAX_TELEPORT_ATTEMPTS_TIMES; ++i) {
            int x = this.randomIntInclusive(this.method_59922(), -3, 3);
            int y = this.randomIntInclusive(this.method_59922(), -1, 1);
            int z = this.randomIntInclusive(this.method_59922(), -3, 3);
            if (maybeTeleportTo(owner, blockPos.method_10263() + x, blockPos.method_10264() + y, blockPos.method_10260() + z)) {
                return true;
            }
        }
        return false;
    }

    private boolean maybeTeleportTo(class_1309 owner, int x, int y, int z) {
        if (teleportTooClosed(owner, x, z)) {
            return false;
        } else if (!method_60717(new class_2338(x, y, z))) {
            return false;
        } else {
            this.method_5808(x + 0.5, y, z + 0.5, this.method_36454(), this.method_36455());
            this.method_5942().method_6340();
            this.method_18868().method_18875(class_4140.field_18445);
            this.method_18868().method_18875(class_4140.field_18446);
            this.method_18868().method_18875(class_4140.field_22355);
            this.method_18868().method_18875(class_4140.field_18449);
            return true;
        }
    }

    private boolean teleportTooClosed(class_1309 owner, int x, int z) {
        return Math.abs(x - owner.method_23317()) < 2 && Math.abs(z - owner.method_23321()) < 2;
    }

    private boolean method_60717(class_2338 pos) {
        class_7 pathNodeType = class_14.method_57625(this, pos);
        if (pathNodeType == class_7.field_12 || pathNodeType == class_7.field_18) {
            class_2338 blockPos = pos.method_10059(this.method_24515());
            return this.method_37908().method_8587(this, this.method_5829().method_996(blockPos));
        }
        return false;
    }

    private int randomIntInclusive(class_5819 random, int min, int max) {
        return random.method_43048(max - min + 1) + min;
    }

    public ChatBubbleManager getChatBubbleManager() {
        return chatBubbleManager;
    }
}
