package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1621;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public final class MaidKillRecordManager {
    private static final String KILL_RECORD = "KillRecord";
    private static final String TOTAL_COUNT = "TotalCount";
    private static final String SLIME_COUNT = "Slime";
    private static final String WITHER_COUNT = "Wither";
    private static final String ENDER_DRAGON_COUNT = "EnderDragon";

    private int totalCount;
    private int slimeCount;
    private int witherCount;
    private int enderDragonCount;

    void addAdditionalSaveData(class_2487 compound) {
        class_2487 killRecord = new class_2487();
        killRecord.method_10569(KILL_RECORD, totalCount);
        killRecord.method_10569(SLIME_COUNT, slimeCount);
        killRecord.method_10569(WITHER_COUNT, witherCount);
        killRecord.method_10569(ENDER_DRAGON_COUNT, enderDragonCount);
        compound.method_10566(KILL_RECORD, killRecord);
    }

    void readAdditionalSaveData(class_2487 compound) {
        if (compound.method_10545(KILL_RECORD)) {
            class_2487 killRecord = compound.method_10562(KILL_RECORD);
            totalCount = killRecord.method_10550(TOTAL_COUNT);
            slimeCount = killRecord.method_10550(SLIME_COUNT);
            witherCount = killRecord.method_10550(WITHER_COUNT);
            enderDragonCount = killRecord.method_10550(ENDER_DRAGON_COUNT);
        }
    }

    public void onTargetDeath(EntityMaid maid, class_1309 target) {
        class_1309 owner = maid.method_35057();
        this.totalCount++;
        triggerKill(owner, TriggerType.MAID_KILL_MOB);
        if (this.totalCount >= 100) {
            triggerKill(owner, TriggerType.KILL_100);
        }
        if (target instanceof class_1621) {
            this.slimeCount++;
            if (slimeCount >= 300) {
                triggerKill(owner, TriggerType.KILL_SLIME_300);
            }
        }
        if (target instanceof class_1528) {
            this.witherCount++;
            triggerKill(owner, TriggerType.KILL_WITHER);
        }
        if (target instanceof class_1510) {
            this.enderDragonCount++;
            triggerKill(owner, TriggerType.KILL_DRAGON);
        }
    }

    private void triggerKill(@Nullable class_1309 owner, String eventName) {
        if (owner instanceof class_3222 serverPlayer) {
            InitTrigger.MAID_EVENT.trigger(serverPlayer, eventName);
        }
    }
}
