package com.github.tartaricacid.touhoulittlemaid.item;

import cn.sh1rocu.touhoulittlemaid.api.extension.IItemEntity;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAndItemTransformEvent;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.ItemMaidTooltip;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.YsmMaidInfo;
import com.mojang.serialization.Codec;
import org.apache.commons.lang3.StringUtils;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_5632;
import net.minecraft.class_9279;

import static com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent.MODEL_ID_TAG_NAME;

public abstract class AbstractStoreMaidItem extends class_1792 implements IItemEntity {
    static final String CUSTOM_NAME = "CustomName";
    private static final String MAID_OWNER = "Owner";

    public AbstractStoreMaidItem(class_1793 properties) {
        super(properties);
    }

    public static void storeMaidData(class_1799 stack, EntityMaid maid) {
        class_9279 compoundData = stack.method_57824(InitDataComponent.MAID_INFO);
        if (compoundData == null) {
            class_2487 tag = new class_2487();
            maid.method_5647(tag);
            var event = new MaidAndItemTransformEvent.ToItem(maid, stack, tag);
            MaidAndItemTransformEvent.TO_ITEM.invoker().onToItem(event);
            stack.method_57379(InitDataComponent.MAID_INFO, class_9279.method_57456(tag));
        }
    }

    @Override
    public boolean onEntityItemUpdate(class_1799 stack, class_1542 entity) {
        if (!entity.method_5851()) {
            entity.method_5834(true);
        }
        if (!entity.method_5655()) {
            entity.method_5684(true);
        }
        class_243 position = entity.method_19538();
        int minY = entity.field_6002.method_31607();
        if (position.field_1351 < minY) {
            entity.method_5875(true);
            entity.method_18799(class_243.field_1353);
            entity.method_5814(position.field_1352, minY, position.field_1350);
            return true;
        }
        return IItemEntity.super.onEntityItemUpdate(stack, entity);
    }

    @Override
    public Optional<class_5632> method_32346(class_1799 stack) {
        class_9279 maidInfo = stack.method_57824(InitDataComponent.MAID_INFO);
        if (maidInfo == null) {
            return Optional.empty();
        }
        Optional<String> modelId = maidInfo.method_57446(Codec.STRING.fieldOf(MODEL_ID_TAG_NAME)).result();
        if (modelId.isEmpty()) {
            return Optional.empty();
        }
        String customName = maidInfo.method_57446(Codec.STRING.fieldOf(CUSTOM_NAME)).result().orElse(StringUtils.EMPTY);
        // YSM 渲染相关数据
        YsmMaidInfo ysmMaidInfo = YsmCompat.getYsmMaidInfo(maidInfo.method_57461());
        return Optional.of(new ItemMaidTooltip(modelId.get(), customName, ysmMaidInfo));
    }

    public class_1269 spawnFromStore(class_1838 context, class_1657 player, class_1937 worldIn, EntityMaid maid, Runnable runnable) {
        class_1799 stack = context.method_8041();
        class_9279 compoundData = stack.method_57824(InitDataComponent.MAID_INFO);
        if (compoundData != null) {
            class_2487 maidCompound = compoundData.method_57461();
            UUID ownerUid = maidCompound.method_25926(MAID_OWNER);
            if (!player.method_5667().equals(ownerUid)) {
                return class_1269.field_5814;
            }

            var event = new MaidAndItemTransformEvent.ToMaid(maid, stack, maidCompound);
            MaidAndItemTransformEvent.TO_MAID.invoker().onToMaid(event);

            maid.method_5651(maidCompound);
            maid.method_5725(context.method_8037().method_10084(), 0, 0);
            if (worldIn instanceof class_3218) {
                worldIn.method_8649(maid);
            }
            maid.spawnExplosionParticle();
            maid.method_5783(class_3417.field_14810, 1.0F, worldIn.field_9229.method_43057() * 0.1F + 0.9F);
            runnable.run();
            return class_1269.method_29236(worldIn.field_9236);
        } else {
            if (worldIn.field_9236) {
                player.method_43496(class_2561.method_43471("message.touhou_little_maid.photo.have_no_nbt_data"));
            }
        }
        return super.method_7884(context);
    }
}
