package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record ToggleTabPackage(int entityId, int tabId) implements class_8710 {
    public static final class_8710.class_9154<ToggleTabPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("toggle_tab"));
    public static final class_9139<ByteBuf, ToggleTabPackage> STREAM_CODEC = class_9139.method_56435(
            class_9135.field_48550,
            ToggleTabPackage::entityId,
            class_9135.field_48550,
            ToggleTabPackage::tabId,
            ToggleTabPackage::new
    );

    public static void handle(ToggleTabPackage message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 sender = context.player();
            class_1297 entity = sender.field_6002.method_8469(message.entityId);
            if (entity instanceof EntityMaid maid && maid.method_6171(sender)) {
                maid.openMaidGui(sender, message.tabId);
            }
        });
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
