/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.config;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.ClientAvailableSitesSync;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import java.util.Map;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MaidAIChatConfigContainer
extends AbstractMaidContainer {
    public static final class_3917<MaidAIChatConfigContainer> TYPE = new ExtendedScreenHandlerType(MaidAIChatConfigContainer::create, (class_9139)new class_9139<class_9129, Data>(){

        public Data decode(class_9129 buf) {
            return new Data(buf.readInt(), buf.method_10798(), ClientAvailableSitesSync.readFromNetwork((class_2540)buf));
        }

        public void encode(class_9129 buf, Data data) {
            buf.method_53002(data.entityId);
            buf.method_10794((class_2520)data.configData);
            ClientAvailableSitesSync.writeToNetwork((class_2540)buf);
        }
    });
    private static final int PLAYER_INVENTORY_SIZE = 27;
    private final class_2487 configData;
    private final Map<String, Map<String, String>> llmSites;
    private final Map<String, Map<String, String>> ttsSites;

    public MaidAIChatConfigContainer(int id, class_1661 inventory, int entityId, @Nullable class_2487 configData, Map<String, Map<String, String>> llmSites, Map<String, Map<String, String>> ttsSites) {
        super(TYPE, id, inventory, entityId);
        this.configData = configData;
        this.llmSites = llmSites;
        this.ttsSites = ttsSites;
    }

    public static class_3908 create(final EntityMaid maid) {
        return new ExtendedScreenHandlerFactory<Data>(){

            @NotNull
            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Maid AI Chat Config Container");
            }

            public class_1703 createMenu(int index, @NotNull class_1661 playerInventory, @NotNull class_1657 player) {
                int entityId = maid.method_5628();
                class_2487 configData = maid.getAiChatManager().writeToTag(new class_2487());
                return new MaidAIChatConfigContainer(index, playerInventory, entityId, configData, ClientAvailableSitesSync.getClientLLMSites(), ClientAvailableSitesSync.getClientTTSSites());
            }

            public Data getScreenOpeningData(class_3222 player) {
                int entityId = maid.method_5628();
                class_2487 configData = maid.getAiChatManager().writeToTag(new class_2487());
                return new Data(entityId, configData, (Pair<Map<String, Map<String, String>>, Map<String, Map<String, String>>>)Pair.of(ClientAvailableSitesSync.getClientLLMSites(), ClientAvailableSitesSync.getClientTTSSites()));
            }

            public boolean shouldCloseCurrentScreen() {
                return false;
            }
        };
    }

    @NotNull
    private static MaidAIChatConfigContainer create(int windowId, class_1661 inv, Data data) {
        int entityId = data.entityId;
        class_2487 configData = data.configData;
        Pair<Map<String, Map<String, String>>, Map<String, Map<String, String>>> sites = data.sites;
        return new MaidAIChatConfigContainer(windowId, inv, entityId, configData, (Map)sites.getLeft(), (Map)sites.getRight());
    }

    public class_2487 getConfigData() {
        return this.configData;
    }

    public Map<String, Map<String, String>> getLLMSites() {
        return this.llmSites;
    }

    public Map<String, Map<String, String>> getTTSSites() {
        return this.ttsSites;
    }

    public class_1799 method_7601(class_1657 playerIn, int index) {
        class_1799 stack1 = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 stack2 = slot.method_7677();
            stack1 = stack2.method_7972();
            if (index < 27 ? !this.method_7616(stack2, 27, this.field_7761.size(), false) : !this.method_7616(stack2, 0, 27, true)) {
                return class_1799.field_8037;
            }
            if (stack2.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return stack1;
    }

    public record Data(int entityId, @Nullable class_2487 configData, Pair<Map<String, Map<String, String>>, Map<String, Map<String, String>>> sites) {
        public static final class_9139<class_9129, Data> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_49675, Data::entityId, (class_9139)class_9135.field_48556, Data::configData, (class_9139)new class_9139<class_9129, Pair<Map<String, Map<String, String>>, Map<String, Map<String, String>>>>(){

            public void encode(class_9129 buf, Pair<Map<String, Map<String, String>>, Map<String, Map<String, String>>> sites) {
                ClientAvailableSitesSync.writeToNetwork((class_2540)buf);
            }

            public Pair<Map<String, Map<String, String>>, Map<String, Map<String, String>>> decode(class_9129 buf) {
                return ClientAvailableSitesSync.readFromNetwork((class_2540)buf);
            }
        }, Data::sites, Data::new);
    }
}

