/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.compat.oculus.OculusCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.MaidFishingHook;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class MaidFishingHookRenderer<T extends MaidFishingHook>
extends class_897<T> {
    private static final class_2960 TEXTURE_LOCATION = new class_2960("textures/entity/fishing_hook.png");
    private static final class_1921 RENDER_TYPE = class_1921.method_23576((class_2960)TEXTURE_LOCATION);

    public MaidFishingHookRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void render(T fishingHook, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        EntityMaid maid = ((MaidFishingHook)((Object)fishingHook)).getMaidOwner();
        if (maid == null) {
            return;
        }
        poseStack.method_22903();
        this.renderBobber(fishingHook, poseStack, buffer, packedLight);
        this.renderFishingLine(fishingHook, partialTicks, poseStack, buffer, maid);
        poseStack.method_22909();
        super.method_3936(fishingHook, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void renderBobber(T fishingHook, class_4587 poseStack, class_4597 buffer, int packedLight) {
        poseStack.method_22903();
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        poseStack.method_22907(this.field_4676.method_24197());
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        class_4587.class_4665 lasted = poseStack.method_23760();
        Matrix4f lastedPose = lasted.method_23761();
        Matrix3f lastedNormal = lasted.method_23762();
        class_4588 consumer = buffer.getBuffer(RENDER_TYPE);
        this.vertex(consumer, lastedPose, lastedNormal, packedLight, 0.0f, 0, 0, 1);
        this.vertex(consumer, lastedPose, lastedNormal, packedLight, 1.0f, 0, 1, 1);
        this.vertex(consumer, lastedPose, lastedNormal, packedLight, 1.0f, 1, 1, 0);
        this.vertex(consumer, lastedPose, lastedNormal, packedLight, 0.0f, 1, 0, 0);
        poseStack.method_22909();
    }

    protected float[] getLineColor(T fishingHook) {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    protected void renderFishingLine(T fishingHook, float partialTicks, class_4587 poseStack, class_4597 buffer, EntityMaid maid) {
        float lerpBodyRot;
        class_1297 class_12972 = maid.method_5854();
        if (class_12972 instanceof class_1309) {
            class_1309 vehicle = (class_1309)class_12972;
            lerpBodyRot = class_3532.method_16439((float)partialTicks, (float)vehicle.field_6220, (float)vehicle.field_6283) * ((float)Math.PI / 180);
        } else {
            lerpBodyRot = class_3532.method_16439((float)partialTicks, (float)maid.field_6220, (float)maid.field_6283) * ((float)Math.PI / 180);
        }
        double sin = class_3532.method_15374((float)lerpBodyRot);
        double cos = class_3532.method_15362((float)lerpBodyRot);
        double x1 = class_3532.method_16436((double)partialTicks, (double)maid.field_6014, (double)maid.method_23317()) - cos * 0.35 - sin * 0.8;
        double y1 = maid.field_6036 + (double)maid.method_5751() + (maid.method_23318() - maid.field_6036) * (double)partialTicks - 0.45;
        double z1 = class_3532.method_16436((double)partialTicks, (double)maid.field_5969, (double)maid.method_23321()) - sin * 0.35 + cos * 0.8;
        double x2 = class_3532.method_16436((double)partialTicks, (double)((MaidFishingHook)((Object)fishingHook)).field_6014, (double)fishingHook.method_23317());
        double y2 = class_3532.method_16436((double)partialTicks, (double)((MaidFishingHook)((Object)fishingHook)).field_6036, (double)fishingHook.method_23318()) + 0.25;
        double z2 = class_3532.method_16436((double)partialTicks, (double)((MaidFishingHook)((Object)fishingHook)).field_5969, (double)fishingHook.method_23321());
        float x = (float)(x1 - x2);
        float y = (float)(y1 - y2) - 0.1875f;
        float z = (float)(z1 - z2);
        float[] colors = this.getLineColor(fishingHook);
        class_4588 lineConsumer = buffer.getBuffer(class_1921.method_34572());
        class_4587.class_4665 lasted = poseStack.method_23760();
        for (int i = 0; i <= 16; ++i) {
            this.stringVertex(x, y, z, lineConsumer, lasted, this.fraction(i), this.fraction(i + 1), colors[0], colors[1], colors[2]);
        }
        if (OculusCompat.isOculusInstalled()) {
            lineConsumer.method_22912(0.0, 0.0, 0.0).method_1336(0, 0, 0, 255).method_22914(0.0f, 0.0f, 0.0f).method_1344();
        }
    }

    protected float fraction(int numerator) {
        return (float)numerator / 16.0f;
    }

    protected void vertex(class_4588 consumer, Matrix4f pose, Matrix3f normal, int lightMapUV, float pX, int pY, int pU, int pV) {
        consumer.method_22918(pose, pX - 0.5f, (float)pY - 0.5f, 0.0f).method_1336(255, 255, 255, 255).method_22913((float)pU, (float)pV).method_22922(class_4608.field_21444).method_22916(lightMapUV).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
    }

    protected static void renderPosTexture(class_4588 builder, Matrix4f matrix4f, Matrix3f matrix3f, int lightMapUV, float x, int y, int u, int v) {
        builder.method_22918(matrix4f, x - 0.5f, (float)y - 0.5f, 0.0f).method_1336(255, 255, 255, 255).method_22913((float)u, (float)v).method_22922(class_4608.field_21444).method_22916(lightMapUV).method_23763(matrix3f, 0.0f, 1.0f, 0.0f).method_1344();
    }

    protected static void vertex(class_4588 builder, Matrix4f matrix4f, Matrix3f matrix3f, int lightMapUV, float x, int y, int u, int v, float r, float g, float b) {
        builder.method_22918(matrix4f, x - 0.5f, (float)y - 0.5f, 0.0f).method_22915(r, g, b, 1.0f).method_22913((float)u, (float)v).method_22922(class_4608.field_21444).method_22916(lightMapUV).method_23763(matrix3f, 0.0f, 1.0f, 0.0f).method_1344();
    }

    protected void stringVertex(float pX, float pY, float pZ, class_4588 consumer, class_4587.class_4665 pose, float fraction1, float fraction2, float r, float g, float b) {
        float x = pX * fraction1;
        float y = pY * (fraction1 * fraction1 + fraction1) * 0.5f + 0.25f;
        float z = pZ * fraction1;
        float nx = pX * fraction2 - x;
        float ny = pY * (fraction2 * fraction2 + fraction2) * 0.5f + 0.25f - y;
        float nz = pZ * fraction2 - z;
        float sqrt = class_3532.method_15355((float)(nx * nx + ny * ny + nz * nz));
        consumer.method_22918(pose.method_23761(), x, y, z).method_22915(r, g, b, 1.0f).method_23763(pose.method_23762(), nx /= sqrt, ny /= sqrt, nz /= sqrt).method_1344();
    }

    public class_2960 getTextureLocation(T pEntity) {
        return TEXTURE_LOCATION;
    }
}

