package cn.sh1rocu.touhoulittlemaid.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1311;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_5483;
import net.minecraft.class_6012;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PotentialSpawnsEvent extends CancellableEvent {
    private final class_1936 level;
    private final class_1311 mobcategory;
    private final class_2338 pos;
    @Nullable
    private List<class_5483.class_1964> list;
    private List<class_5483.class_1964> view;

    public PotentialSpawnsEvent(class_1936 level, class_1311 category, class_2338 pos, class_6012<class_5483.class_1964> oldList) {
        this.level = level;
        this.pos = pos;
        this.mobcategory = category;
        this.list = null;
        this.view = oldList.method_34994();
    }

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.post(event);
        }
    });

    public class_1936 getLevel() {
        return level;
    }

    public class_1311 getMobCategory() {
        return mobcategory;
    }

    public class_2338 getPos() {
        return pos;
    }

    public List<class_5483.class_1964> getSpawnerDataList() {
        return view;
    }

    private void makeList() {
        if (list == null) {
            list = new ArrayList<>(view);
            view = Collections.unmodifiableList(list);
        }
    }

    public void addSpawnerData(class_5483.class_1964 data) {
        makeList();
        list.add(data);
    }

    public boolean removeSpawnerData(class_5483.class_1964 data) {
        makeList();
        return list.remove(data);
    }

    public interface Callback {
        void post(PotentialSpawnsEvent event);
    }
}
