package com.github.tartaricacid.simplebedrockmodel.client.manager;

import cn.sh1rocu.touhoulittlemaid.api.event.RegisterClientReloadListenersEvent;
import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ReloadableResourceManagerAccessor;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.AbstractBedrockEntityModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3304;
import java.util.Set;

@Environment(EnvType.CLIENT)
@SuppressWarnings({"unchecked", "rawtypes"})
public class BedrockEntityModelRegister<T extends AbstractBedrockEntityModel<? extends class_1297>> {
    public static BedrockEntityModelRegister INSTANCE = null;
    private final BedrockEntityModelSet<T> modelSet;

    private BedrockEntityModelRegister(BedrockEntityModelSet<T> modelSet) {
        this.modelSet = modelSet;
    }

    public static void onRegisterClientReloadListenersEvent(RegisterClientReloadListenersEvent event) {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        if (resourceManager instanceof class_3304 manager) {
            INSTANCE = new BedrockEntityModelRegister<>(new BedrockEntityModelSet<>());
            BedrockEntityModelRegisterEvent.CALLBACK.invoker().post(new BedrockEntityModelRegisterEvent(INSTANCE.modelSet));
            // 将注册冻结
            INSTANCE.modelSet.immutableKnowLocations();
            // 添加到最前面，避免实体读取模型时模型还没加载完成
            ((ReloadableResourceManagerAccessor) manager).tlm$getListeners().addFirst(INSTANCE.modelSet);
        }
    }

    public AbstractBedrockEntityModel<? extends class_1297> getModel(class_2960 location) {
        return modelSet.getModels().get(location);
    }

    public Set<class_2960> getAllModelKeys() {
        return modelSet.getModels().keySet();
    }
}