package com.github.tartaricacid.touhoulittlemaid.ai.service;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.mojang.serialization.Codec;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

/**
 * 站点序列化接口，用于站点配置的读取与保存，还有站点配置的网络通信
 *
 * @param <T>
 */
public interface SerializableSite<T extends Site> {
    /**
     * 站点序列化反序列化的编码器
     */
    Codec<T> codec();

    /**
     * 生成一个默认站点数据，用于配置文件初始化时生成一个默认配置
     */
    T defaultSite();

    /**
     * 将站点配置写入网络数据包
     */
    default void writeToNetwork(T site, class_2540 buffer) {
        codec().encodeStart(class_2509.field_11560, site)
                .resultOrPartial(TouhouLittleMaid.LOGGER::error)
                .ifPresent(tag -> {
                    if (tag instanceof class_2487 compoundTag) {
                        buffer.method_10794(compoundTag);
                    }
                });
    }

    /**
     * 从网络数据包读取站点配置
     */
    default T fromNetwork(class_2540 buffer) {
        return codec().parse(class_2509.field_11560, buffer.method_10798())
                .resultOrPartial(TouhouLittleMaid.LOGGER::error)
                .orElse(null);
    }

    /**
     * 工具方法，通过站点 ID 获取一个默认图标地址
     */
    static class_2960 defaultIcon(String id) {
        return class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/ai_chat/%s.png".formatted(id));
    }
}