package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import javax.annotation.Nullable;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.isValidResourceLocation;

public class ConditionArmor {
    private static final Pattern ID_PRE_REG = Pattern.compile("^(.+?)\\$(.*?)$");
    private static final Pattern TAG_PRE_REG = Pattern.compile("^(.+?)#(.*?)$");
    private static final String EMPTY = "";

    private final Map<class_1304, List<class_2960>> idTest = Maps.newHashMap();
    private final Map<class_1304, List<class_6862<class_1792>>> tagTest = Maps.newHashMap();

    public void addTest(String name) {
        Matcher matcherId = ID_PRE_REG.matcher(name);
        if (matcherId.find()) {
            class_1304 type = getType(matcherId.group(1));
            if (type == null) {
                return;
            }
            String id = matcherId.group(2);
            if (!isValidResourceLocation(id)) {
                return;
            }
            class_2960 res = class_2960.method_60654(id);
            if (idTest.containsKey(type)) {
                idTest.get(type).add(res);
            } else {
                idTest.put(type, Lists.newArrayList(res));
            }
            return;
        }

        Matcher matcherTag = TAG_PRE_REG.matcher(name);
        if (matcherTag.find()) {
            class_1304 type = getType(matcherTag.group(1));
            if (type == null) {
                return;
            }
            String id = matcherTag.group(2);
            if (!isValidResourceLocation(id)) {
                return;
            }
            class_6862<class_1792> tagKey = class_6862.method_40092(
                    class_7924.field_41197,
                    class_2960.method_60654(id)
            );
            if (tagTest.containsKey(type)) {
                tagTest.get(type).add(tagKey);
            } else {
                tagTest.put(type, Lists.newArrayList(tagKey));
            }
        }
    }

    public String doTest(IMaid maid, class_1304 slot) {
        class_1799 item = maid.asEntity().method_6118(slot);
        if (item.method_7960()) {
            return EMPTY;
        }
        String result = doIdTest(maid, slot);
        if (result.isEmpty()) {
            return doTagTest(maid, slot);
        }
        return result;
    }

    private String doIdTest(IMaid maid, class_1304 slot) {
        if (idTest.isEmpty()) {
            return EMPTY;
        }
        if (!idTest.containsKey(slot) || idTest.get(slot).isEmpty()) {
            return EMPTY;
        }
        List<class_2960> idListTest = idTest.get(slot);
        class_1799 item = maid.asEntity().method_6118(slot);
        class_2960 registryName = class_7923.field_41178.method_10221(item.method_7909());
        if (registryName == null) {
            return EMPTY;
        }
        if (idListTest.contains(registryName)) {
            return slot.method_5923() + "$" + registryName;
        }
        return EMPTY;
    }

    private String doTagTest(IMaid maid, class_1304 slot) {
        if (tagTest.isEmpty()) {
            return EMPTY;
        }
        if (!tagTest.containsKey(slot) || tagTest.get(slot).isEmpty()) {
            return EMPTY;
        }
        List<class_6862<class_1792>> tagListTest = tagTest.get(slot);
        class_1799 item = maid.asEntity().method_6118(slot);
        return tagListTest.stream().filter(item::method_31573).findFirst().map(itemTagKey -> slot.method_5923() + "#" + itemTagKey.comp_327()).orElse(EMPTY);
    }


    @Nullable
    public static class_1304 getType(String type) {
        for (class_1304 equipmentslot : class_1304.values()) {
            if (equipmentslot.method_5923().equals(type)) {
                return equipmentslot;
            }
        }
        return null;
    }
}