package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.util.GuiTools;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_638;
import net.minecraft.class_6382;
import net.minecraft.class_7532;

public class HistoryChatWidget extends class_339 {
    private static final class_2960 TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/maid_history_chat.png");
    private static final long TICKS_PER_DAY = 24000;
    private static final long TICKS_PER_HOUR = 1000;

    private final boolean isLeft;
    private final class_2960 playerSkin;
    private final class_2561 time;

    public HistoryChatWidget(int pX, int pY, int width, int height, class_2561 message, class_2960 playerSkin, long gameTime, boolean isLeft) {
        super(pX, pY, width, height, message);
        this.isLeft = isLeft;
        this.playerSkin = playerSkin;
        this.time = convertGameTime(gameTime);
    }

    private class_2561 convertGameTime(long inputGameTime) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return class_2561.method_43473();
        }
        long currentGameTime = level.method_8510();
        long diff = currentGameTime - inputGameTime;
        if (diff < 0) {
            return class_2561.method_43473();
        }

        long days = diff / TICKS_PER_DAY;
        diff %= TICKS_PER_DAY;
        long hours = diff / TICKS_PER_HOUR;
        if (days > 0) {
            return class_2561.method_43469("gui.touhou_little_maid.button.maid_ai_chat_config.history_chat.days", days);
        } else if (hours > 0) {
            return class_2561.method_43469("gui.touhou_little_maid.button.maid_ai_chat_config.history_chat.hours", hours);
        } else {
            return class_2561.method_43471("gui.touhou_little_maid.button.maid_ai_chat_config.history_chat.just_now");
        }
    }

    @Override
    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_51422(1, 1, 1, this.field_22765);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        this.drawBackground(graphics);
        this.drawAvatar(graphics);
        this.renderString(graphics, class_310.method_1551().field_1772);
    }

    private void drawAvatar(class_332 graphics) {
        int size = 16;
        int offset = 6;
        int xOffset = this.isLeft ? (-size - offset) : this.method_25368() + offset;
        if (isLeft) {
            graphics.method_25302(TEXTURE, this.method_46426() + xOffset, this.getHeightMiddle(size), 0, 32, size, size);
        } else {
            class_7532.method_44443(graphics, this.playerSkin, this.method_46426() + xOffset, this.getHeightMiddle(size), size);
        }
    }

    private void drawBackground(class_332 graphics) {
        int heightMiddle = this.getHeightMiddle(14);
        GuiTools.blitNineSliced(graphics, TEXTURE, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(),
                8, 4, 100, 16, 0, this.getTextureY());
        if (isLeft) {
            graphics.method_25302(TEXTURE, this.method_46426() - 4, heightMiddle, 100, 16, 6, 14);
        } else {
            graphics.method_25302(TEXTURE, this.method_46426() + this.method_25368() - 2, heightMiddle, 100, 0, 6, 14);
        }
    }

    public void renderString(class_332 graphics, class_327 font) {
        class_2561 message = this.method_25369();
        graphics.method_51422(1, 1, 1, 1);
        if (isLeft) {
            graphics.method_51440(font, message, this.method_46426() + 5, this.method_46427() + 5, this.method_25368() - 10, 0x555555);
        } else {
            graphics.method_51440(font, message, this.method_46426() + 5, this.method_46427() + 5, this.method_25368() - 10, 0xFFFFFF);
        }

        float scale = 0.5f;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(scale, scale, 0);
        if (isLeft) {
            graphics.method_51430(font, this.time.method_30937(),
                    (int) ((this.method_46426() + 2) / scale),
                    (int) ((this.method_46427() - 5) / scale),
                    0x999999, false);
        } else {
            float width = font.method_27525(this.time) * scale;
            graphics.method_51430(font, this.time.method_30937(),
                    (int) ((this.method_46426() + this.method_25368() - width - 2) / scale),
                    (int) ((this.method_46427() - 5) / scale),
                    0x999999, false);
        }
        graphics.method_51448().method_22909();
    }

    private int getTextureY() {
        return this.isLeft ? 16 : 0;
    }

    private int getHeightMiddle(int height) {
        return this.method_46427() + (this.method_25364() - height) / 2;
    }

    @Override
    protected void method_47399(class_6382 output) {
        this.method_37021(output);
    }
}