package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class PackInfoButton extends FlatColorButton {
    private static final class_2960 BG = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/download_background.png");
    private final DownloadInfo info;

    public PackInfoButton(int pX, int pY, DownloadInfo info, class_4241 onPress) {
        super(pX, pY, 268, 46, class_2561.method_43473(), onPress);
        this.info = info;
        this.setTooltips(Lists.newArrayList(getI18nFormatDesc(info.getDesc()), getI18nFormatLicense(info.getLicense())));
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float pPartialTick) {
        class_310 minecraft = class_310.method_1551();
        // 背景色
        if (isSelect) {
            graphics.method_25296(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0xff_1E90FF, 0xff_1E90FF);
        } else if (info.getStatus() != DownloadStatus.DOWNLOADED) {
            graphics.method_25296(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0xff_434242, 0xff_434242);
        }

        // 如果是下载状态，绘制下载进度条
        int downloadProgress = info.getDownloadProgress();
        if (info.getStatus() == DownloadStatus.DOWNLOADING && downloadProgress >= 0) {
            int widthProgress = this.field_22758 * downloadProgress / 100;
            graphics.method_25296(this.method_46426(), this.method_46427(), this.method_46426() + widthProgress, this.method_46427() + this.field_22759, 0xff_ff5733, 0xff_ff5733);
        }

        // 绘制需要更新的提示
        if (info.getStatus() == DownloadStatus.NEED_UPDATE) {
            graphics.method_25302(BG, this.method_46426() + 240, this.method_46427() + 15, 48, 16, 16, 16);
        }

        // 悬浮或者选中时，显示为蓝色
        if (this.method_25367()) {
            graphics.method_25296(this.method_46426(), this.method_46427() + 1, this.method_46426() + 1, this.method_46427() + this.field_22759 - 1, 0xff_F3EFE0, 0xff_F3EFE0);
            graphics.method_25296(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + 1, 0xff_F3EFE0, 0xff_F3EFE0);
            graphics.method_25296(this.method_46426() + this.field_22758 - 1, this.method_46427() + 1, this.method_46426() + this.field_22758, this.method_46427() + this.field_22759 - 1, 0xff_F3EFE0, 0xff_F3EFE0);
            graphics.method_25296(this.method_46426(), this.method_46427() + this.field_22759 - 1, this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0xff_F3EFE0, 0xff_F3EFE0);
        }

        // 显示成女仆、坐垫或者声音图标
        int count = info.getTypeCount();
        if (count == 3) {
            graphics.method_25302(BG, this.method_46426() + 7, this.method_46427() + 7, 0, 96, 32, 32);
        } else if (count == 2) {
            if (!info.hasType(DownloadInfo.TypeEnum.MAID)) {
                graphics.method_25302(BG, this.method_46426() + 7, this.method_46427() + 7, 64, 64, 32, 32);
            } else if (!info.hasType(DownloadInfo.TypeEnum.CHAIR)) {
                graphics.method_25302(BG, this.method_46426() + 7, this.method_46427() + 7, 32, 64, 32, 32);
            } else {
                graphics.method_25302(BG, this.method_46426() + 7, this.method_46427() + 7, 0, 64, 32, 32);
            }
        } else {
            if (info.hasType(DownloadInfo.TypeEnum.MAID)) {
                graphics.method_25302(BG, this.method_46426() + 7, this.method_46427() + 7, 0, 32, 32, 32);
            } else if (info.hasType(DownloadInfo.TypeEnum.CHAIR)) {
                graphics.method_25302(BG, this.method_46426() + 7, this.method_46427() + 7, 32, 32, 32, 32);
            } else {
                graphics.method_25302(BG, this.method_46426() + 7, this.method_46427() + 7, 64, 32, 32, 32);
            }
        }

        // 渲染文本
        //int i = getFGColor();
        int i = this.field_22763 ? 16777215 : 10526880;
        this.method_48589(graphics, minecraft.field_1772, i | class_3532.method_15386(this.field_22765 * 255.0F) << 24);

        // 下载完成，灰色遮罩
        if (info.getStatus() == DownloadStatus.DOWNLOADED) {
            graphics.method_25296(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0x7f_232222, 0x7f_232222);
        }
    }

    @Override
    public void method_48589(class_332 graphics, class_327 font, int pColor) {
        int startX = this.method_46426() + 50;
        int startY = this.method_46427() + 4;

        class_5250 packName = class_2561.method_43471(info.getName());
        graphics.method_27535(font, packName, startX, startY, class_124.field_1068.method_532());
        graphics.method_25303(font, getI18nFormatFileVersion(info.getVersion()), startX + 5 + font.method_27525(packName), startY, class_124.field_1060.method_532());
        graphics.method_27535(font, getI18nFormatFileSize(info.getFormatFileSize()), startX, startY + 10, class_124.field_1065.method_532());
        graphics.method_27535(font, getI18nFormatAuthor(info.getAuthor()), startX, startY + 20, class_124.field_1075.method_532());
        graphics.method_27535(font, getI18nFormatFileTime(info.getFormatData()), startX, startY + 30, class_124.field_1080.method_532());
    }

    private String getI18nFormatFileVersion(String version) {
        return "§nv" + version;
    }

    private class_5250 getI18nFormatAuthor(List<String> authors) {
        String str = String.join(class_1074.method_4662("gui.touhou_little_maid.resources_download.author.delimiter"), authors);
        return class_2561.method_43469("gui.touhou_little_maid.resources_download.author", str);
    }

    private class_5250 getI18nFormatFileSize(String size) {
        return class_2561.method_43469("gui.touhou_little_maid.resources_download.file_size", size);
    }

    private class_5250 getI18nFormatFileTime(String time) {
        return class_2561.method_43469("gui.touhou_little_maid.resources_download.upload_time", time);
    }

    private class_5250 getI18nFormatLicense(String license) {
        return class_2561.method_43469("gui.touhou_little_maid.resources_download.license", license).method_27692(class_124.field_1064).method_27692(class_124.field_1056);
    }

    private class_5250 getI18nFormatDesc(String desc) {
        return class_2561.method_43471(desc).method_27692(class_124.field_1080);
    }
}
