package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.compat.simplehats.SimpleHatsCompat;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntityRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.ILocationModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2190;
import net.minecraft.class_2484;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_836;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class GeckoLayerMaidBipedHead<T extends class_1308, R extends IGeoEntityRenderer<T>> extends GeoLayerRenderer<T, R> {
    private final Map<class_2484.class_2485, class_5598> skullModels;
    private final class_5599 modelSet;

    public GeckoLayerMaidBipedHead(R entityRendererIn, class_5599 modelSet) {
        super(entityRendererIn);
        this.modelSet = modelSet;
        this.skullModels = class_836.method_32160(modelSet);
    }

    @Override
    public GeoLayerRenderer<T, R> copy(R entityRendererIn) {
        return new GeckoLayerMaidBipedHead<>(entityRendererIn, modelSet);
    }

    @Override
    public void render(class_4587 poseStack, class_4597 bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        var animatableEntity = getGeoEntity(entity);
        if (animatableEntity.getGeoModel() != null) {
            class_1799 head = entity.method_6118(class_1304.field_6169);
            ILocationModel model = animatableEntity.getGeoModel();
            boolean allowRenderHead = animatableEntity.getMaidInfo().isShowCustomHead() && !model.headBones().isEmpty();
            if (!allowRenderHead) {
                return;
            }

            // 渲染头盔栏的
            if (!head.method_7960()) {
                class_1792 item = head.method_7909();
                poseStack.method_22903();
                RenderUtils.prepMatrixForLocator(poseStack, model.headBones());
                if (item instanceof class_1747 && ((class_1747) item).method_7711() instanceof class_2190 skullBlock) {
                    poseStack.method_22905(-1.1875F, 1.1875F, -1.1875F);
                    class_9296 resolvableProfile = head.method_57824(class_9334.field_49617);
                    poseStack.method_22904(-0.5D, 0.0D, -0.5D);
                    class_2484.class_2485 type = skullBlock.method_9327();
                    class_5598 modelBase = this.skullModels.get(type);
                    class_1921 rendertype = class_836.method_3578(type, resolvableProfile);
                    class_836.method_32161(null, 180.0F, 0.0F, poseStack, bufferIn, packedLightIn, modelBase, rendertype);
                }
                poseStack.method_22909();
            }

            IMaid maid = IMaid.convert(entity);
            if (maid == null) {
                return;
            }

            // 渲染女仆背部的
            class_1799 stack = maid.getBackpackShowItem();
            // 不做限制，任意方块都可以显示
            if (stack.method_7909() instanceof class_1747 blockItem) {
                class_2680 blockState = blockItem.method_7711().method_9564();
                poseStack.method_22903();
                RenderUtils.prepMatrixForLocator(poseStack, model.headBones());
                poseStack.method_22905(-0.8F, 0.8F, -0.8F);
                poseStack.method_22904(-0.5, 0.625, -0.5);
                class_310.method_1551().method_1541().method_3353(blockState, poseStack, bufferIn, packedLightIn, class_4608.field_21444);
                poseStack.method_22909();
            } else {
                SimpleHatsCompat.renderGeckoHat(poseStack, bufferIn, packedLightIn, entity, stack, model.headBones());
            }
        }
    }
}