package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.touhoulittlemaid.compat.carryon.RenderFixer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.processor.ILocationBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntityRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.ILocationModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import java.util.List;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_759;
import net.minecraft.class_7833;
import net.minecraft.class_811;

public class GeckoLayerMaidHeld<T extends class_1308, R extends IGeoEntityRenderer<T>> extends GeoLayerRenderer<T, R> {
    private final class_759 itemInHandRenderer;

    public GeckoLayerMaidHeld(R entityRendererIn, class_759 itemInHandRenderer) {
        super(entityRendererIn);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    @Override
    public GeoLayerRenderer<T, R> copy(R entityRendererIn) {
        return new GeckoLayerMaidHeld<>(entityRendererIn, this.itemInHandRenderer);
    }

    @Override
    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        class_1799 offhandItem = entity.method_6079();
        class_1799 mainHandItem = entity.method_6047();
        ILocationModel geoModel = getLocationModel(entity);
        if (geoModel == null) {
            return;
        }
        if (!offhandItem.method_7960() || !mainHandItem.method_7960()) {
            poseStack.method_22903();
            if (!geoModel.rightHandBones().isEmpty() && !RenderFixer.isCarryOnRender(mainHandItem, buffer)) {
                this.renderArmWithItem(entity, mainHandItem, geoModel, class_811.field_4320, class_1306.field_6183, poseStack, buffer, packedLight);
            }
            if (!geoModel.leftHandBones().isEmpty() && !RenderFixer.isCarryOnRender(offhandItem, buffer)) {
                this.renderArmWithItem(entity, offhandItem, geoModel, class_811.field_4323, class_1306.field_6182, poseStack, buffer, packedLight);
            }
            poseStack.method_22909();
        }
    }

    protected void renderArmWithItem(T livingEntity, class_1799 itemStack, ILocationModel geoModel, class_811 displayContext, class_1306 arm, class_4587 poseStack, class_4597 bufferSource, int light) {
        if (!itemStack.method_7960() && geoModel != null) {
            boolean isLeftHand = arm == class_1306.field_6182;

            // 渲染默认手部物品
            poseStack.method_22903();
            boolean scaleResult = translateToHand(arm, poseStack, geoModel);
            // 缩放不为 0 才会渲染
            if (!scaleResult) {
                poseStack.method_22904(0, -0.0625, -0.1);
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0F));
                this.itemInHandRenderer.method_3233(livingEntity, itemStack, displayContext, isLeftHand, poseStack, bufferSource, light);
            }
            poseStack.method_22909();

            // 渲染额外手部物品
            List<List<? extends ILocationBone>> extraBones = isLeftHand ? geoModel.extraLeftHandBones() : geoModel.extraRightHandBones();
            extraBones.forEach(bones -> {
                poseStack.method_22903();
                boolean extraScaleResult = RenderUtils.prepMatrixForLocator(poseStack, bones);
                // 缩放不为 0 才会渲染
                if (!extraScaleResult) {
                    poseStack.method_22904(0, -0.0625, -0.1);
                    poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0F));
                    this.itemInHandRenderer.method_3233(livingEntity, itemStack, displayContext, isLeftHand, poseStack, bufferSource, light);
                }
                poseStack.method_22909();
            });
        }
    }

    protected boolean translateToHand(class_1306 arm, class_4587 poseStack, ILocationModel geoModel) {
        if (arm == class_1306.field_6182) {
            return RenderUtils.prepMatrixForLocator(poseStack, geoModel.leftHandBones());
        } else {
            return RenderUtils.prepMatrixForLocator(poseStack, geoModel.rightHandBones());
        }
    }
}