package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Objects;
import net.minecraft.class_1088;
import net.minecraft.class_1308;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2185;
import net.minecraft.class_2960;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5253;
import net.minecraft.class_5599;
import net.minecraft.class_7833;
import net.minecraft.class_9307;
import net.minecraft.class_9334;

import static com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader.MAID_BANNER;

public class LayerMaidBanner extends class_3887<class_1308, BedrockModel<class_1308>> {
    private static final class_2960 TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/bedrock/entity/maid_banner.png");
    private final EntityMaidRenderer renderer;
    private final SimpleBedrockModel<EntityMaid> bannerModel;

    public LayerMaidBanner(EntityMaidRenderer renderer, class_5599 modelSet) {
        super(renderer);
        this.renderer = renderer;
        this.bannerModel = Objects.requireNonNull(BedrockModelLoader.getModel(MAID_BANNER));
    }

    @Override
    public void render(class_4587 matrixStack, class_4597 bufferIn, int packedLightIn, class_1308 mob, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IMaid maid = IMaid.convert(mob);
        if (maid == null) {
            return;
        }
        class_1799 stack = maid.getBackpackShowItem();
        if (stack.method_7909() instanceof class_1746 bannerItem) {
            if (!renderer.getMainInfo().isShowBackpack() || mob.method_6113() || mob.method_5767()) {
                return;
            }
            if (maid instanceof EntityMaid entityMaid && !entityMaid.getConfigManager().isShowBackItem()) {
                return;
            }
            matrixStack.method_22903();
            matrixStack.method_22904(0, 0.5, 0.025);
            matrixStack.method_22905(0.5F, 0.5F, 0.5F);
            matrixStack.method_22907(class_7833.field_40713.rotationDegrees(5));
            class_4588 buffer = bufferIn.getBuffer(class_1921.method_23578(TEXTURE));
            this.bannerModel.method_2828(matrixStack, buffer, packedLightIn, class_4608.field_21444, 0xFFFFFFFF);
            class_9307 patterns = maid.getBackpackShowItem().method_57824(class_9334.field_49619);
            class_1767 dyeColor = ((class_2185) bannerItem.method_7711()).method_9303();
            if (patterns != null) {
                renderPatterns(matrixStack, bufferIn, packedLightIn, bannerModel.getPart("banner"), patterns, dyeColor);
            }
            matrixStack.method_22909();
        }
    }

    private void renderPatterns(class_4587 poseStack, class_4597 bufferSource, int packedLight,
                                BedrockPart banner, class_9307 patterns, class_1767 dyeColor) {
        banner.render(poseStack, class_1088.field_20847.method_30001(bufferSource, class_1921::method_23572, false),
                packedLight, class_4608.field_21444);
        renderPatternLayer(poseStack, bufferSource, packedLight, banner, class_4722.field_49769, dyeColor);
        for (int i = 0; i < 16 && i < patterns.comp_2428().size(); ++i) {
            class_9307.class_9308 layer = patterns.comp_2428().get(i);
            class_4730 material = class_4722.method_33081(layer.comp_2429());
            renderPatternLayer(poseStack, bufferSource, packedLight, banner, material, layer.comp_2430());
        }
    }

    private void renderPatternLayer(class_4587 poseStack, class_4597 buffer, int packedLight, BedrockPart banner, class_4730 material, class_1767 color) {
        int packedColor = color.method_7787();
        float red = class_5253.class_5254.method_27765(packedColor) / 255f;
        float green = class_5253.class_5254.method_27766(packedColor) / 255f;
        float blue = class_5253.class_5254.method_27767(packedColor) / 255f;
        banner.render(poseStack, material.method_24145(buffer, class_1921::method_23588), packedLight, class_4608.field_21444, red, green, blue, 1.0F);
    }
}