package com.github.tartaricacid.touhoulittlemaid.compat.emi.transfer;

import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1735;

public class BackpackRecipeHandler<C extends MaidMainContainer> implements StandardRecipeHandler<C> {
    private final EmiRecipeCategory recipeCategory;
    private final int recipeSlotStart;
    private final int recipeSlotCount;
    private final int inventorySlotStart;
    private final int inventorySlotCount;

    public BackpackRecipeHandler(EmiRecipeCategory categoryIdentifier, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        this.recipeCategory = categoryIdentifier;
        this.recipeSlotStart = recipeSlotStart;
        this.recipeSlotCount = recipeSlotCount;
        this.inventorySlotStart = inventorySlotStart;
        this.inventorySlotCount = inventorySlotCount;
    }

    @Override
    public List<class_1735> getInputSources(C handler) {
        List<class_1735> slots = new ArrayList<>();
        for (int i = inventorySlotStart; i < inventorySlotStart + inventorySlotCount; i++) {
            slots.add(handler.method_7611(i));
        }
        return slots;
    }

    @Override
    public List<class_1735> getCraftingSlots(C handler) {
        List<class_1735> slots = new ArrayList<>();
        for (int i = recipeSlotStart; i < recipeSlotStart + recipeSlotCount; i++) {
            slots.add(handler.method_7611(i));
        }
        return slots;
    }

    @Override
    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory() == recipeCategory;
    }
}