package com.github.tartaricacid.touhoulittlemaid.compat.sodium;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoBone;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class SodiumCompat {
    public static final String SODIUM = "sodium";
    public static boolean IS_SODIUM_INSTALLED = false;

    public static void init() {
        IS_SODIUM_INSTALLED = FabricLoader.getInstance().isModLoaded(SODIUM);
    }

    public static boolean isSodiumInstalled() {
        return IS_SODIUM_INSTALLED;
    }

    public static boolean sodiumRenderCubesOfBone(AnimatedGeoBone bone, class_4587 poseStack, class_4588 buffer, int cubePackedLight,
                                                  int packedOverlay, float red, float green, float blue, float alpha) {
        if (SodiumCompat.isSodiumInstalled()) {
            return SodiumGeoRenderer.renderCubesOfBone(bone, poseStack, buffer, cubePackedLight, packedOverlay, red, green, blue, alpha);
        }
        return false;
    }
}
