package com.github.tartaricacid.touhoulittlemaid.datagen.advancement;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.advancements.altar.AltarCraftTrigger;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2073;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5279;
import net.minecraft.class_8779;


public class MaidBaseAdvancement {
    public static void generate(Consumer<class_8779> saver) {
        class_8779 root = make(class_1802.field_8153, "switch_task")
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.SWITCH_TASK))
                .method_694(saver, id("maid_base/switch_task").toString());

        generateTask(root, saver);

        generateOther(saver, root);

        generateBauble(root, saver);

        generatePhoto(root, saver);

        generateFind(saver, root);

        generateReborn(root, saver);
    }

    private static void generateFind(Consumer<class_8779> saver, class_8779 root) {
        class_8779 base = make(InitItems.SERVANT_BELL, "use_servant_bell").method_701(root)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.USE_SERVANT_BELL))
                .method_694(saver, id("maid_base/use_servant_bell").toString());

        make(InitItems.TRUMPET, "use_trumpet").method_701(base)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.USE_TRUMPET))
                .method_694(saver, id("maid_base/use_trumpet").toString());

        class_8779 redFoxScroll = make(InitItems.RED_FOX_SCROLL, "use_red_fox_scroll").method_701(base)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.USE_RED_FOX_SCROLL))
                .method_694(saver, id("maid_base/use_red_fox_scroll").toString());

        make(InitItems.WHITE_FOX_SCROLL, "use_white_fox_scroll").method_701(redFoxScroll)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.USE_WHITE_FOX_SCROLL))
                .method_694(saver, id("maid_base/use_white_fox_scroll").toString());
    }

    private static void generateOther(Consumer<class_8779> saver, class_8779 root) {
        class_8779 base = make(class_1802.field_8175, "pickup_maid").method_701(root)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.PICKUP_MAID))
                .method_694(saver, id("maid_base/pickup_maid").toString());

        make(class_1802.field_8287, "take_maid_xp").method_701(base)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.TAKE_MAID_XP))
                .method_694(saver, id("maid_base/take_maid_xp").toString());

        make(class_1802.field_8103, "clear_maid_effects").method_701(base)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.CLEAR_MAID_EFFECTS))
                .method_694(saver, id("maid_base/clear_maid_effects").toString());
    }

    private static void generateTask(class_8779 root, Consumer<class_8779> saver) {
        class_8779 taskRoot = make(class_1802.field_8557, "switch_schedule").method_701(root)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.SWITCH_SCHEDULE))
                .method_694(saver, id("maid_base/switch_schedule").toString());

        class_8779 backpack = make(InitItems.MAID_BACKPACK_BIG, "maid_backpack").method_701(taskRoot)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.MAID_BACKPACK))
                .method_694(saver, id("maid_base/maid_backpack").toString());

        makeGoal(class_1802.field_8802, "maid_kill_mob").method_701(backpack)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.MAID_KILL_MOB))
                .method_694(saver, id("maid_base/maid_kill_mob").toString());

        make(class_1802.field_8378, "maid_fishing").method_701(backpack)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.MAID_FISHING))
                .method_694(saver, id("maid_base/maid_fishing").toString());

        class_8779 farm = makeGoal(class_1802.field_8609, "maid_farm").method_701(taskRoot)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.MAID_FARM))
                .method_694(saver, id("maid_base/maid_farm").toString());

        class_8779 feedAnimal = make(class_1802.field_8861, "maid_feed_animal").method_701(farm)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.MAID_FEED_ANIMAL))
                .method_694(saver, id("maid_base/maid_feed_animal").toString());

        make(class_1802.field_8176, "maid_feed_player").method_701(feedAnimal)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.MAID_FEED_PLAYER))
                .method_694(saver, id("maid_base/maid_feed_player").toString());
    }

    private static void generateBauble(class_8779 root, Consumer<class_8779> saver) {
        class_8779 baubleRoot = make(InitItems.FIRE_PROTECT_BAUBLE, "use_protect_bauble").method_701(root)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.USE_PROTECT_BAUBLE))
                .method_694(saver, id("maid_base/use_protect_bauble").toString());

        class_8779 fabric = make(InitItems.NIMBLE_FABRIC, "use_nimble_fabric").method_701(baubleRoot)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.USE_NIMBLE_FABRIC))
                .method_694(saver, id("maid_base/use_nimble_fabric").toString());

        makeGoal(InitItems.ULTRAMARINE_ORB_ELIXIR, "use_undead_bauble").method_701(fabric)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.USE_UNDEAD_BAUBLE))
                .method_694(saver, id("maid_base/use_undead_bauble").toString());

        class_8779 magnet = make(InitItems.ITEM_MAGNET_BAUBLE, "use_item_magnet_bauble").method_701(baubleRoot)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.USE_ITEM_MAGNET_BAUBLE))
                .method_694(saver, id("maid_base/use_item_magnet_bauble").toString());

        make(InitItems.WIRELESS_IO, "use_wireless_io").method_701(magnet)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.USE_WIRELESS_IO))
                .method_694(saver, id("maid_base/use_wireless_io").toString());
    }

    private static void generatePhoto(class_8779 root, Consumer<class_8779> saver) {
        class_8779 photoRoot = make(InitItems.CAMERA, "photo_maid").method_701(root)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.PHOTO_MAID))
                .method_694(saver, id("maid_base/photo_maid").toString());

        class_8779 statue = make(InitItems.CHISEL, "chisel_statue").method_701(photoRoot)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.CHISEL_STATUE))
                .method_694(saver, id("maid_base/chisel_statue").toString());

        make(InitItems.GARAGE_KIT, "pickup_garage_kit").method_701(statue)
                .method_705("pickup_item", class_5279.class_5280.method_43277(
                        Optional.empty(),
                        Optional.of(class_2073.class_2074.method_8973().method_8977(InitItems.GARAGE_KIT).method_8976()),
                        Optional.empty()))
                .method_694(saver, id("maid_base/pickup_garage_kit").toString());
    }

    private static void generateReborn(class_8779 root, Consumer<class_8779> saver) {
        class_1799 stack = ItemEntityPlaceholder.setRecipeId(new class_1799(InitItems.ENTITY_PLACEHOLDER), "reborn_maid");
        class_8779 rebornRoot = make(stack, "reborn_maid").method_701(root)
                .method_705("altar_craft", AltarCraftTrigger.Instance.recipe(id("altar_recipe/reborn_maid")))
                .method_694(saver, id("maid_base/reborn_maid").toString());

        makeGoal(InitItems.SHRINE, "shrine_reborn_maid").method_701(rebornRoot)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.SHRINE_REBORN_MAID))
                .method_694(saver, id("maid_base/shrine_reborn_maid").toString());
    }

    private static class_161.class_162 make(class_1935 item, String key) {
        class_5250 title = class_2561.method_43471(String.format("advancements.touhou_little_maid.maid_base.%s.title", key));
        class_5250 desc = class_2561.method_43471(String.format("advancements.touhou_little_maid.maid_base.%s.description", key));

        return class_161.class_162.method_707().method_697(item, title, desc,
                class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/advancements/backgrounds/stone.png"),
                class_189.field_1254, true, true, false);
    }

    private static class_161.class_162 make(class_1799 item, String key) {
        class_5250 title = class_2561.method_43471(String.format("advancements.touhou_little_maid.maid_base.%s.title", key));
        class_5250 desc = class_2561.method_43471(String.format("advancements.touhou_little_maid.maid_base.%s.description", key));

        return class_161.class_162.method_707().method_20416(item, title, desc,
                class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/advancements/backgrounds/stone.png"),
                class_189.field_1254, true, true, false);
    }

    private static class_161.class_162 makeGoal(class_1935 item, String key) {
        class_5250 title = class_2561.method_43471(String.format("advancements.touhou_little_maid.maid_base.%s.title", key));
        class_5250 desc = class_2561.method_43471(String.format("advancements.touhou_little_maid.maid_base.%s.description", key));

        return class_161.class_162.method_707().method_697(item, title, desc,
                class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/advancements/backgrounds/stone.png"),
                class_189.field_1249, true, true, false);
    }

    private static class_2960 id(String id) {
        return class_2960.method_60655(TouhouLittleMaid.MOD_ID, id);
    }
}
