package com.github.tartaricacid.touhoulittlemaid.debug.command;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5996;
import org.apache.commons.lang3.StringUtils;

@class_5996
public final class MaidDebugCommand {
    private static final String MAID_DEBUG_NAME = "debug";

    private static final String ENABLE = "enable";
    private static final String VALUE = "value";

    private static final String SPAWN_MAID = "spawn_maid";
    private static final String COUNT_NAME = "count";
    private static final String MODEL_ID = "model_id";

    private static final String SET_FARM = "set_farm";
    private static final String SIZE = "size";

    public static LiteralArgumentBuilder<class_2168> get() {
        LiteralArgumentBuilder<class_2168> debug = class_2170.method_9247(MAID_DEBUG_NAME);

        // 开启调试渲染功能
        LiteralArgumentBuilder<class_2168> enable = class_2170.method_9247(ENABLE);
        RequiredArgumentBuilder<class_2168, Boolean> value = class_2170.method_9244(VALUE, BoolArgumentType.bool());
        debug.then(enable.then(value.executes(MaidDebugCommand::enableDebug)));

        // 批量生成女仆
        LiteralArgumentBuilder<class_2168> spawnMaid = class_2170.method_9247(SPAWN_MAID);
        RequiredArgumentBuilder<class_2168, String> modelId = class_2170.method_9244(MODEL_ID, StringArgumentType.string());
        RequiredArgumentBuilder<class_2168, Integer> count = class_2170.method_9244(COUNT_NAME, IntegerArgumentType.integer(0));
        debug.then(spawnMaid.then(modelId.then(count.executes(MaidDebugCommand::spawnMaid))));

        // 生成大量农田
        LiteralArgumentBuilder<class_2168> setFarm = class_2170.method_9247(SET_FARM);
        RequiredArgumentBuilder<class_2168, Integer> size = class_2170.method_9244(SIZE, IntegerArgumentType.integer());
        debug.then(setFarm.then(size.executes(MaidDebugCommand::setFarm)));

        return debug;
    }

    private static int enableDebug(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean value = BoolArgumentType.getBool(context, VALUE);
        class_3222 serverPlayer = context.getSource().method_9207();
        if (value) {
            TouhouLittleMaid.DEBUG = true;
            serverPlayer.method_43496(class_2561.method_43471("debug.touhou_little_maid.enable.true"));
        } else {
            TouhouLittleMaid.DEBUG = false;
            serverPlayer.method_43496(class_2561.method_43471("debug.touhou_little_maid.enable.false"));
        }
        return Command.SINGLE_SUCCESS;
    }

    private static int spawnMaid(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (!TouhouLittleMaid.DEBUG) {
            return Command.SINGLE_SUCCESS;
        }

        String modelId = StringArgumentType.getString(context, MODEL_ID);
        int count = IntegerArgumentType.getInteger(context, COUNT_NAME);
        class_3222 serverPlayer = context.getSource().method_9207();
        if (count > 0) {
            for (int i = 0; i < count; i++) {
                class_2338 blockPos = serverPlayer.method_24515();
                int x = blockPos.method_10263() + i % 10 + 1;
                int z = blockPos.method_10260() + i / 10 + 1;
                class_3218 level = serverPlayer.method_51469();
                EntityMaid entityMaid = new EntityMaid(level);
                entityMaid.method_5814(x, blockPos.method_10264(), z);
                entityMaid.method_6170(serverPlayer);
                if (StringUtils.isNotBlank(modelId)) {
                    entityMaid.setModelId(modelId);
                } else {
                    entityMaid.method_5943(level, level.method_8404(serverPlayer.method_24515()), class_3730.field_16465, null);
                }
                entityMaid.method_6179(true);
                level.method_8649(entityMaid);
            }
        }
        return Command.SINGLE_SUCCESS;
    }

    private static int setFarm(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (!TouhouLittleMaid.DEBUG) {
            return Command.SINGLE_SUCCESS;
        }

        int size = IntegerArgumentType.getInteger(context, SIZE);
        class_3222 serverPlayer = context.getSource().method_9207();
        if (size > 0) {
            class_2338 blockPos = serverPlayer.method_24515();
            class_1937 level = serverPlayer.field_6002;
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            for (int x = -size; x < size; x++) {
                for (int z = -size; z < size; z++) {
                    class_2338.class_2339 pos = mutableBlockPos.method_25504(blockPos, x, -1, z);
                    if (x % 5 == 0 && z % 5 == 0) {
                        // 放置水和荷叶
                        level.method_8501(pos, class_2246.field_10382.method_9564());
                        level.method_8501(pos.method_10098(class_2350.field_11036), class_2246.field_10588.method_9564());
                    } else {
                        // 放置农田和作物
                        level.method_8501(pos, class_2246.field_10362.method_9564().method_11657(class_2344.field_11009, 7));
                        level.method_8501(pos.method_10098(class_2350.field_11036), class_2246.field_10293.method_9564().method_11657(class_2302.field_10835, 7));
                    }
                }
            }
        }

        return Command.SINGLE_SUCCESS;
    }
}